/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.util.SystemReporting;

public abstract class CommandAction
extends AbstractAction
implements ElanLocaleListener {
    public static final String MNEMONIC = "MNEMONIC.";
    protected Command command;
    private String commandId;
    protected ViewerManager2 vm;
    private static boolean useMnemonics = true;

    public CommandAction(ViewerManager2 theVM, String name) {
        super(name);
        this.vm = theVM;
        this.commandId = name;
        ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction(this.commandId));
        this.updateLocale();
    }

    public CommandAction(ViewerManager2 theVM, String name, Icon icon) {
        super(name, icon);
        this.vm = theVM;
        this.commandId = name;
        ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        this.updateLocale();
    }

    protected abstract void newCommand();

    protected Object getReceiver() {
        return null;
    }

    protected Object[] getArguments() {
        return null;
    }

    public void actionPerformed(ActionEvent event) {
        this.newCommand();
        if (this.command != null) {
            this.command.execute(this.getReceiver(), this.getArguments());
        }
    }

    public void externalCommand(Object receiver, Object[] args) {
        this.newCommand();
        if (receiver == null) {
            receiver = this.getReceiver();
        }
        if (args == null) {
            args = this.getArguments();
        }
        if (this.command != null) {
            this.command.execute(receiver, args);
        }
    }

    public void updateLocale() {
        String mnemonic;
        String newString = null;
        if (this.commandId != null) {
            newString = "" + ElanLocale.getString(this.commandId);
        }
        Object[] obj = this.getKeys();
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].equals("SmallIcon")) continue;
            newString = "";
        }
        Object object = this.getValue("ShortDescription");
        if (object == null || !object.equals("")) {
            this.putValue("ShortDescription", ElanLocale.getString(this.commandId + "ToolTip"));
        }
        this.putValue("Name", newString);
        if (useMnemonics && (mnemonic = ElanLocale.getString(MNEMONIC + this.commandId)).length() > 0) {
            try {
                this.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
            }
            catch (NumberFormatException nfe) {
                try {
                    this.putValue("MnemonicKey", new Integer(mnemonic));
                }
                catch (NumberFormatException nfe2) {
                    this.putValue("MnemonicKey", null);
                }
            }
        }
    }

    static {
        if (SystemReporting.isMacOS()) {
            useMnemonics = false;
        }
    }
}

