/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.util.TimeFormatter;

public class CopyCurrentTimeToPasteBoardCommand
implements Command {
    private String commandName;
    private static String HH_MM_SS_MS = ElanLocale.getString("TimeCodeFormat.Hours");
    private static String SS_MS = ElanLocale.getString("TimeCodeFormat.Seconds");
    private static String MS = ElanLocale.getString("TimeCodeFormat.MilliSec");
    private static String NTSC = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC");
    private static String PAL = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL");

    public CopyCurrentTimeToPasteBoardCommand(String theName) {
        this.commandName = theName;
    }

    public void execute(Object receiver, Object[] arguments) {
        ElanMediaPlayerController mediaPlayerController = (ElanMediaPlayerController)receiver;
        ElanMediaPlayer player = (ElanMediaPlayer)arguments[0];
        if (player == null) {
            return;
        }
        if (player.isPlaying()) {
            return;
        }
        String timeFormat = null;
        String currentTime = null;
        Object val = Preferences.get("CurrentTime.Copy.TimeFormat", null);
        currentTime = val instanceof String ? ((timeFormat = val.toString()).equals(HH_MM_SS_MS) ? TimeFormatter.toString(player.getMediaTime()) : (timeFormat.equals(SS_MS) ? TimeFormatter.toSSMSString(player.getMediaTime()) : (timeFormat.equals(NTSC) ? TimeFormatter.toTimecodeNTSC(player.getMediaTime()) : (timeFormat.equals(PAL) ? TimeFormatter.toTimecodePAL(player.getMediaTime()) : Long.toString(player.getMediaTime()))))) : Long.toString(player.getMediaTime());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection strSel = new StringSelection(currentTime);
        clipboard.setContents(strSel, null);
    }

    public String getName() {
        return this.commandName;
    }
}

