/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateDependentAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier;
    TranscriptionImpl transcription;
    private long begin;
    private long end;
    List<String> annotationTiers;
    int numberOfannotaionsCreated = 0;

    public CreateDependentAnnotationsCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.begin = (Long)arguments[0];
        this.end = (Long)arguments[1];
        this.transcription = (TranscriptionImpl)this.tier.getParent();
        this.annotationTiers = new ArrayList<String>();
        this.createDependingAnnotations();
        if (this.numberOfannotaionsCreated > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.CREATE_DEPENDING_ANNOTATIONS, this.tier.getName(), this.tier.getAnnotationAtTime(this.begin).getValue(), Long.toString(this.begin), Long.toString(this.end), "number of annotations created : " + this.numberOfannotaionsCreated);
        }
    }

    public void createDependingAnnotations() {
        this.annotationTiers.clear();
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        Vector dependentTiers = this.tier.getDependentTiers();
        int firstAnnotation = -1;
        if (dependentTiers != null) {
            Object ann = null;
            for (int i = 0; i < dependentTiers.size(); ++i) {
                TierImpl currentChildTier = (TierImpl)dependentTiers.elementAt(i);
                if (currentChildTier.getAnnotationAtTime(this.begin) != null) continue;
                if (firstAnnotation < 0) {
                    firstAnnotation = i;
                }
                this.annotationTiers.add(currentChildTier.getName());
                if (currentChildTier.isTimeAlignable()) {
                    currentChildTier.createAnnotation(this.begin, this.end);
                } else {
                    long time = (this.begin + this.end) / 2L;
                    currentChildTier.createAnnotation(time, time);
                }
                ++this.numberOfannotaionsCreated;
            }
            this.transcription.setNotifying(true);
            if (firstAnnotation >= 0) {
                ((TranscriptionImpl)this.tier.getParent()).notifyListeners(this.tier, 3, ((TierImpl)dependentTiers.elementAt(firstAnnotation)).getAnnotationAtTime(this.begin));
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public void redo() {
        this.createDependingAnnotations();
        if (this.numberOfannotaionsCreated > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.CREATE_DEPENDING_ANNOTATIONS);
        }
    }

    public void undo() {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        Annotation ann = null;
        for (int i = 0; i < this.annotationTiers.size(); ++i) {
            TierImpl currentChildTier = (TierImpl)this.transcription.getTierWithId(this.annotationTiers.get(i));
            if (currentChildTier.isTimeAlignable()) {
                ann = currentChildTier.getAnnotationAtTime(this.begin);
                if (ann == null) continue;
                currentChildTier.removeAnnotation(ann);
                continue;
            }
            long time = (this.begin + this.end) / 2L;
            ann = currentChildTier.getAnnotationAtTime(time);
            if (ann == null) continue;
            currentChildTier.removeAnnotation(ann);
        }
        this.numberOfannotaionsCreated = 0;
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.CREATE_DEPENDING_ANNOTATIONS);
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public String getName() {
        return this.commandName;
    }
}

