/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class DeleteCVCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private ControlledVocabulary controlledVocabulary;
    private Vector effectedTypes;

    public DeleteCVCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null && this.controlledVocabulary != null) {
            this.transcription.addControlledVocabulary(this.controlledVocabulary);
            for (int i = 0; i < this.effectedTypes.size(); ++i) {
                LinguisticType type = (LinguisticType)this.effectedTypes.get(i);
                type.setControlledVocabularyName(this.controlledVocabulary.getName());
            }
        }
    }

    public void redo() {
        if (this.transcription != null) {
            this.transcription.removeControlledVocabulary(this.controlledVocabulary);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.controlledVocabulary = (ControlledVocabulary)arguments[0];
        if (this.transcription != null) {
            this.effectedTypes = this.transcription.getLinguisticTypesWithCV(this.controlledVocabulary.getName());
            this.transcription.removeControlledVocabulary(this.controlledVocabulary);
        }
    }

    public String getName() {
        return this.commandName;
    }
}

