/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteTiersCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl[] tiers;
    private Vector[] depTiers;
    private ArrayList[] annotationsNodes;
    private Map[] colorPrefs;
    private Map[] fontPrefs;
    private TranscriptionImpl transcription;

    public DeleteTiersCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription != null && this.tiers != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            for (int i = 0; i < this.tiers.length; ++i) {
                Object fontsObj;
                Object colorsObj;
                if (this.transcription.getTierWithId(this.tiers[i].getName()) == null) {
                    this.transcription.addTier(this.tiers[i]);
                }
                if (this.depTiers[i] != null) {
                    for (int j = 0; j < this.depTiers[i].size(); ++j) {
                        TierImpl deptier = (TierImpl)this.depTiers[i].get(j);
                        if (this.transcription.getTierWithId(deptier.getName()) != null) continue;
                        this.transcription.addTier(deptier);
                    }
                }
                if (this.annotationsNodes[i].size() > 0) {
                    this.transcription.setNotifying(false);
                    if (this.tiers[i].hasParentTier()) {
                        AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.annotationsNodes[i], true);
                    } else {
                        for (int j = 0; j < this.annotationsNodes[i].size(); ++j) {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.annotationsNodes[i].get(j);
                            AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                        }
                    }
                    this.transcription.setNotifying(true);
                }
                if (this.colorPrefs != null && (colorsObj = Preferences.get("TierColors", this.transcription)) instanceof Map) {
                    Map colors = (Map)colorsObj;
                    colors.putAll(this.colorPrefs[i]);
                    Preferences.set("TierColors", colors, this.transcription, true);
                }
                if (this.fontPrefs == null || !((fontsObj = Preferences.get("TierFonts", this.transcription)) instanceof Map)) continue;
                Map fonts = (Map)fontsObj;
                fonts.putAll(this.fontPrefs[i]);
                Preferences.set("TierFonts", fonts, this.transcription, true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    public void redo() {
        for (int i = 0; i < this.tiers.length; ++i) {
            Object fontsObj;
            Object colorsObj;
            if (this.transcription == null || this.tiers[i] == null) continue;
            this.transcription.removeTier(this.tiers[i]);
            if (this.depTiers[i] != null) {
                for (int j = 0; j < this.depTiers[i].size(); ++j) {
                    this.transcription.removeTier((TierImpl)this.depTiers[i].get(j));
                }
            }
            if ((colorsObj = Preferences.get("TierColors", this.transcription)) instanceof Map) {
                Map colors = (Map)colorsObj;
                for (int j = 0; j < this.depTiers[i].size(); ++j) {
                    TierImpl t = (TierImpl)this.depTiers[i].get(j);
                    colors.remove(t.getName());
                }
                colors.remove(this.tiers[i].getName());
            }
            if (!((fontsObj = Preferences.get("TierFonts", this.transcription)) instanceof Map)) continue;
            Map fonts = (Map)fontsObj;
            for (int j = 0; j < this.depTiers[i].size(); ++j) {
                TierImpl t = (TierImpl)this.depTiers[i].get(j);
                fonts.remove(t.getName());
            }
            fonts.remove(this.tiers[i].getName());
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        if (!(receiver instanceof TranscriptionImpl)) {
            return;
        }
        this.transcription = (TranscriptionImpl)receiver;
        this.tiers = new TierImpl[arguments.length];
        this.depTiers = new Vector[arguments.length];
        this.annotationsNodes = new ArrayList[arguments.length];
        this.colorPrefs = new Map[arguments.length];
        this.fontPrefs = new Map[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object fon;
            Object fontsObj;
            this.tiers[i] = (TierImpl)arguments[i];
            if (this.tiers[i] == null) continue;
            this.depTiers[i] = this.tiers[i].getDependentTiers();
            this.annotationsNodes[i] = new ArrayList();
            Vector annos = this.tiers[i].getAnnotations();
            for (AbstractAnnotation ann : annos) {
                this.annotationsNodes[i].add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
            if (this.depTiers[i] != null) {
                for (int j = 0; j < this.depTiers[i].size(); ++j) {
                    this.transcription.removeTier((TierImpl)this.depTiers[i].get(j));
                }
            }
            this.transcription.removeTier(this.tiers[i]);
            Object colorsObj = Preferences.get("TierColors", this.transcription);
            if (colorsObj instanceof Map) {
                Object col;
                Map colors = (Map)colorsObj;
                this.colorPrefs[i] = new HashMap(colors.size());
                for (int j = 0; j < this.depTiers[i].size(); ++j) {
                    TierImpl t = (TierImpl)this.depTiers[i].get(j);
                    col = colors.remove(t.getName());
                    if (col == null) continue;
                    this.colorPrefs[i].put(t.getName(), col);
                }
                col = colors.remove(this.tiers[i].getName());
                if (col != null) {
                    this.colorPrefs[i].put(this.tiers[i].getName(), col);
                }
            }
            if (!((fontsObj = Preferences.get("TierFonts", this.transcription)) instanceof Map)) continue;
            Map fonts = (Map)fontsObj;
            this.fontPrefs[i] = new HashMap(fonts.size());
            for (int j = 0; j < this.depTiers[i].size(); ++j) {
                TierImpl t = (TierImpl)this.depTiers[i].get(j);
                fon = fonts.remove(t.getName());
                if (fon == null) continue;
                this.fontPrefs[i].put(t.getName(), fon);
            }
            fon = fonts.remove(this.tiers[i].getName());
            if (fon == null) continue;
            this.fontPrefs[i].put(this.tiers[i].getName(), fon);
        }
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

