/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.NewAnnotationCommand;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class DuplicateAnnotationCommand
extends NewAnnotationCommand {
    private String value;
    private Object extRef;

    public DuplicateAnnotationCommand(String name) {
        super(name);
    }

    public void execute(Object receiver, Object[] arguments) {
        final ViewerManager2 vm = (ViewerManager2)receiver;
        TierImpl t = (TierImpl)arguments[0];
        AbstractAnnotation ann = (AbstractAnnotation)arguments[1];
        this.value = ann.getValue();
        long[] times = this.adjustTimes(t, ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
        if (times != null) {
            ((TranscriptionImpl)vm.getTranscription()).setNotifying(false);
            super.execute(t, new Object[]{new Long(times[0]), new Long(times[1])});
            if (this.newAnnotation != null) {
                this.newAnnotation.setValue(this.value);
                if (ann.getExtRef() != null) {
                    try {
                        this.extRef = (ExternalReference)((ExternalReference)ann.getExtRef()).clone();
                        ((AbstractAnnotation)this.newAnnotation).setExtRef(this.extRef);
                    }
                    catch (CloneNotSupportedException cnse) {
                        // empty catch block
                    }
                }
            }
            this.transcription.setNotifying(true);
            Command c = ELANCommandFactory.createCommand(vm.getTranscription(), "Commands.ActiveAnnotation");
            c.execute(vm, new Object[]{ann});
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ELANCommandFactory.getRootFrame(vm.getTranscription()).requestFocus();
                }
            });
        }
    }

    public void redo() {
        this.transcription.setNotifying(false);
        super.redo();
        if (this.newAnnotation != null) {
            this.newAnnotation.setValue(this.value);
            if (this.extRef != null) {
                ((AbstractAnnotation)this.newAnnotation).setExtRef(this.extRef);
            }
        }
        this.transcription.setNotifying(true);
    }

    public void undo() {
        super.undo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long[] adjustTimes(TierImpl tier, long begin, long end) {
        long[] result = new long[]{begin, end};
        Constraint c = tier.getLinguisticType().getConstraints();
        if (c == null) {
            return result;
        }
        if (c.getStereoType() == 4 || c.getStereoType() == 3) {
            TierImpl par = (TierImpl)tier.getParentTier();
            long mid = (begin + end) / 2L;
            if (tier.getAnnotationAtTime(mid) == null && par.getAnnotationAtTime(mid) != null) {
                result[0] = mid;
                result[1] = mid;
                return result;
            } else if (tier.getAnnotationAtTime(begin) == null && par.getAnnotationAtTime(begin) != null) {
                result[1] = begin;
                return result;
            } else {
                if (tier.getAnnotationAtTime(end) != null || par.getAnnotationAtTime(end) == null) return null;
                result[0] = end;
            }
            return result;
        } else {
            if (c.getStereoType() != 1 && c.getStereoType() != 0) return result;
            TierImpl par = (TierImpl)tier.getParentTier();
            Annotation ann1 = par.getAnnotationAtTime(begin);
            Annotation ann2 = par.getAnnotationAtTime(end);
            if (ann1 != null && ann2 != null && ann1 != ann2) {
                result[1] = ann1.getEndTimeBoundary();
                return result;
            } else if (ann1 != null && ann2 == null) {
                result[1] = ann1.getEndTimeBoundary();
                return result;
            } else if (ann1 == null && ann2 != null) {
                result[0] = ann2.getBeginTimeBoundary();
                return result;
            } else {
                Vector v = par.getOverlappingAnnotations(begin, end);
                if (v.size() == 0) {
                    return null;
                }
                ann1 = (Annotation)v.get(0);
                result[0] = ann1.getBeginTimeBoundary();
                result[1] = ann1.getEndTimeBoundary();
            }
        }
        return result;
    }
}

