/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ExportOverlapsCommand;
import mpi.eudico.client.annotator.util.ProgressListener;

public class ExportOverlapsMultiCommand
implements Command {
    private String name;
    private ArrayList<ProgressListener> listeners;
    final String NL = "\n";
    final String TAB = "\t";

    public ExportOverlapsMultiCommand(String name) {
        this.name = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        List fileList = (List)arguments[0];
        if (fileList.size() == 0) {
            this.progressComplete("No files specified");
            return;
        }
        String refTier = (String)arguments[1];
        List compTiers = (List)arguments[2];
        String filePath = (String)arguments[3];
        String encoding = (String)arguments[4];
        if (encoding == null) {
            encoding = "UTF-8";
        }
        new ExportRunner(fileList, refTier, compTiers, filePath, encoding).start();
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportRunner
    extends Thread {
        private List<String> fileList;
        private String refTier;
        private List<String> compTiers;
        private String filePath;
        private String encoding;

        public ExportRunner(List<String> fileList, String refTier, List<String> compTiers, String filePath, String encoding) {
            this.fileList = fileList;
            this.refTier = refTier;
            this.compTiers = compTiers;
            this.filePath = filePath;
            this.encoding = encoding;
        }

        @Override
        public void run() {
            File outputFile = new File(this.filePath);
            try {
                BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.encoding));
                outWriter.write("Begin time");
                outWriter.write("\t");
                outWriter.write("End time");
                outWriter.write("\t");
                outWriter.write(this.refTier);
                outWriter.write("\t");
                for (int i = 0; i < this.compTiers.size(); ++i) {
                    String nm = this.compTiers.get(i);
                    outWriter.write(nm + "-ov");
                    outWriter.write("\t");
                    outWriter.write(nm + "-same");
                    outWriter.write("\t");
                    outWriter.write(nm + "ov-dur");
                    outWriter.write("\t");
                    outWriter.write(nm + "-no-ann");
                    outWriter.write("\t");
                    outWriter.write(nm + "-value");
                    outWriter.write("\t");
                }
                outWriter.write("\n");
                float perFile = 100.0f / (float)this.fileList.size();
                for (int i = 0; i < this.fileList.size(); ++i) {
                    String fileName = this.fileList.get(i);
                    ExportOverlapsCommand com = new ExportOverlapsCommand("ExportOverlaps");
                    com.execute(outWriter, new Object[]{fileName, this.refTier, this.compTiers});
                    ExportOverlapsMultiCommand.this.progressUpdate((int)((float)(i + 1) * perFile), "Processed file " + fileName);
                }
                outWriter.flush();
                ExportOverlapsMultiCommand.this.progressComplete("Export complete.");
            }
            catch (FileNotFoundException fnfe) {
                ExportOverlapsMultiCommand.this.progressInterrupt("Export failed: " + fnfe.getMessage());
            }
            catch (UnsupportedEncodingException uee) {
                ExportOverlapsMultiCommand.this.progressInterrupt("Export failed: " + uee.getMessage());
            }
            catch (IOException ioe) {
                ExportOverlapsMultiCommand.this.progressInterrupt("Export failed: " + ioe.getMessage());
            }
        }
    }
}

