/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;

public class ExportPrefsCommand
implements Command {
    private String commandName;
    private Transcription transcription;

    public ExportPrefsCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        if (this.transcription == null) {
            return;
        }
        String filePath = this.promptForExportFile();
        if (filePath == null) {
            return;
        }
        Preferences.exportPreferences(this.transcription, filePath);
    }

    private String promptForExportFile() {
        String prefDir = (String)Preferences.get("LastUsedExportDir", null);
        if (prefDir == null) {
            prefDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(ElanLocale.getString("Button.Save"));
        chooser.setCurrentDirectory(new File(prefDir));
        chooser.setDialogTitle(ElanLocale.getString("ExportDialog.ExportToFile"));
        File prefFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(19);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(ELANCommandFactory.getRootFrame(this.transcription)) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedExportDir", curDir.getAbsolutePath(), null);
            }
            if ((prefFile = chooser.getSelectedFile()) != null) {
                int answer;
                String name = prefFile.getAbsolutePath();
                String lowerPathName = name.toLowerCase();
                String[] extensions = FileExtension.ELAN_XML_PREFS_EXT;
                boolean validExt = false;
                for (int i = 0; i < extensions.length; ++i) {
                    if (!lowerPathName.endsWith("." + extensions[i].toLowerCase())) continue;
                    validExt = true;
                    break;
                }
                if (!validExt) {
                    name = name + "." + extensions[0];
                    prefFile = new File(name);
                }
                if (prefFile.exists() && (answer = JOptionPane.showConfirmDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                    return this.promptForExportFile();
                }
                return name;
            }
        }
        return null;
    }

    public String getName() {
        return this.commandName;
    }
}

