/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ImportRecogTiersCommand
implements Command {
    private String name;
    private TranscriptionImpl trans;

    public ImportRecogTiersCommand(String name) {
        this.name = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.trans = (TranscriptionImpl)receiver;
        String filePath = this.promptForTierFile();
        File f = new File(filePath);
        if (f.exists() && f.canRead()) {
            List<Segmentation> segm = null;
            if (filePath.endsWith("csv")) {
                CsvTierIO cio = new CsvTierIO();
                segm = cio.read(f);
            } else {
                XmlTierIO xio = new XmlTierIO(f);
                segm = xio.parse();
            }
            if (segm != null && segm.size() > 0) {
                Command cc = ELANCommandFactory.createCommand(this.trans, "Seg2TierDlg");
                cc.execute(this.trans, new Object[]{segm});
            } else {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.trans), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoTiers"), ElanLocale.getString("Message.Error"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.trans), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed"), ElanLocale.getString("Message.Error"), 2);
        }
    }

    public String getName() {
        return this.name;
    }

    private String promptForTierFile() {
        String prefPath = null;
        Object val = Preferences.get("Recognizer.Path", null);
        if (val instanceof String) {
            prefPath = (String)val;
        }
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(20);
        FileFilter ff2 = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.addChoosableFileFilter(ff2);
        chooser.setFileFilter(ff2);
        if (chooser.showOpenDialog(ELANCommandFactory.getRootFrame(this.trans)) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("Recognizer.Path", par.getAbsolutePath(), null);
            }
            if (chooser.getFileFilter() == ff) {
                String lower = f.getAbsolutePath().toLowerCase();
                boolean valid = false;
                for (int i = 0; i < FileExtension.CSV_EXT.length; ++i) {
                    if (!lower.endsWith(FileExtension.CSV_EXT[i])) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    f = new File(f.getAbsolutePath() + "." + FileExtension.CSV_EXT[0]);
                }
            } else if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            return f.getAbsolutePath();
        }
        return null;
    }
}

