/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class MergeTranscriptionsCommand
implements Command,
ClientLogger {
    private String commandName;
    private ArrayList listeners;
    private TranscriptionImpl destTrans;
    private TranscriptionImpl srcTrans;
    private String fileName;
    private ArrayList selTiers;
    private boolean overwrite;

    public MergeTranscriptionsCommand(String theName) {
        this.commandName = theName;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.destTrans = (TranscriptionImpl)receiver;
        this.srcTrans = (TranscriptionImpl)arguments[0];
        this.fileName = (String)arguments[1];
        this.selTiers = (ArrayList)arguments[2];
        this.overwrite = (Boolean)arguments[3];
        if (this.destTrans == null) {
            this.progressInterrupt("No first transcription (destination) specified.");
            return;
        }
        this.destTrans.setNotifying(false);
        if (this.srcTrans == null) {
            this.progressInterrupt("No second transcription (source) specified");
            return;
        }
        if (this.fileName == null) {
            this.progressInterrupt("No filename specified");
            return;
        }
        if (this.selTiers == null) {
            this.progressInterrupt("No tiers specifed");
            return;
        }
        new MergeThread().start();
    }

    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    class MergeThread
    extends Thread {
        MergeThread() {
        }

        MergeThread(String name) {
            super(name);
        }

        public void run() {
            try {
                TierImpl t;
                MergeTranscriptionsCommand.this.progressUpdate(5, "Checking tiers to add...");
                MergeUtil mergeUtil = new MergeUtil();
                ArrayList tiersToAdd = mergeUtil.getAddableTiers(MergeTranscriptionsCommand.this.srcTrans, MergeTranscriptionsCommand.this.destTrans, MergeTranscriptionsCommand.this.selTiers);
                MergeTranscriptionsCommand.this.progressUpdate(10, "Sorting the tiers to add...");
                tiersToAdd = mergeUtil.sortTiers(tiersToAdd);
                MergeTranscriptionsCommand.this.progressUpdate(20, "Creating the tiers. linguistic types, cv's...");
                mergeUtil.addTiersTypesAndCVs(MergeTranscriptionsCommand.this.srcTrans, MergeTranscriptionsCommand.this.destTrans, tiersToAdd);
                MergeTranscriptionsCommand.this.progressUpdate(30, "Adding annotations...");
                int numIndivTiers = 0;
                for (int i = 0; i < tiersToAdd.size(); ++i) {
                    t = (TierImpl)tiersToAdd.get(i);
                    if (t.hasParentTier() && tiersToAdd.contains(t.getParentTier())) continue;
                    ++numIndivTiers;
                }
                if (numIndivTiers > 0) {
                    int progPerTier = 60 / numIndivTiers;
                    int count = 1;
                    for (int i = 0; i < tiersToAdd.size(); ++i) {
                        t = (TierImpl)tiersToAdd.get(i);
                        if (t.hasParentTier() && tiersToAdd.contains(t.getParentTier())) continue;
                        this.addAnnotations(t);
                        MergeTranscriptionsCommand.this.progressUpdate(30 + count * progPerTier, "Merging of tier " + t.getName() + " done.");
                    }
                }
                MergeTranscriptionsCommand.this.progressUpdate(92, "Saving transcription...");
                TranscriptionStore transcriptionStore = ACMTranscriptionStore.getCurrentTranscriptionStore();
                transcriptionStore.storeTranscription(MergeTranscriptionsCommand.this.destTrans, null, new Vector(), MergeTranscriptionsCommand.this.fileName, 0);
                ClientLogger.LOG.info("Transcription saved to " + MergeTranscriptionsCommand.this.fileName);
                MergeTranscriptionsCommand.this.progressComplete("Merging complete");
            }
            catch (Exception ex) {
                ClientLogger.LOG.severe("Error while merging: " + ex.getMessage());
                ex.printStackTrace();
                MergeTranscriptionsCommand.this.progressInterrupt("Error while merging: " + ex.getMessage());
            }
        }

        private void addAnnotations(TierImpl tier) {
            TierImpl parent = (TierImpl)tier.getParentTier();
            TierImpl destTier = (TierImpl)MergeTranscriptionsCommand.this.destTrans.getTierWithId(tier.getName());
            if (destTier == null) {
                ClientLogger.LOG.warning("Destination tier " + tier.getName() + " not found in destination description");
                return;
            }
            AbstractAnnotation ann2 = null;
            DefaultMutableTreeNode recordNode = null;
            if (parent != null) {
                LinguisticType lt = tier.getLinguisticType();
                if (lt.getConstraints() == null) {
                    ClientLogger.LOG.warning("Error: illegal type for tier: " + tier.getName());
                    return;
                }
                if (lt.getConstraints().getStereoType() == 4) {
                    Vector annotations = tier.getAnnotations();
                    if (annotations.size() > 0) {
                        for (int i = 0; i < annotations.size(); ++i) {
                            ann2 = (AbstractAnnotation)annotations.get(i);
                            if (!MergeTranscriptionsCommand.this.overwrite && destTier.getOverlappingAnnotations(ann2.getBeginTimeBoundary(), ann2.getEndTimeBoundary()).size() != 0) continue;
                            recordNode = AnnotationRecreator.createTreeForAnnotation(ann2);
                            AnnotationRecreator.createAnnotationFromTree(MergeTranscriptionsCommand.this.destTrans, recordNode);
                        }
                    }
                } else {
                    ArrayList<DefaultMutableTreeNode> group = new ArrayList<DefaultMutableTreeNode>();
                    TierImpl rootTier = tier.getRootTier();
                    Annotation curParent = null;
                    Vector annotations = tier.getAnnotations();
                    for (AbstractAnnotation ann2 : annotations) {
                        int numOverlap = destTier.getOverlappingAnnotations(ann2.getBeginTimeBoundary(), ann2.getEndTimeBoundary()).size();
                        if (curParent == null) {
                            if (MergeTranscriptionsCommand.this.overwrite || numOverlap == 0) {
                                group.add(AnnotationRecreator.createTreeForAnnotation(ann2));
                            }
                            curParent = rootTier.getAnnotationAtTime(ann2.getBeginTimeBoundary());
                            continue;
                        }
                        if (rootTier.getAnnotationAtTime(ann2.getBeginTimeBoundary()) == curParent) {
                            if (!MergeTranscriptionsCommand.this.overwrite && numOverlap != 0) continue;
                            group.add(AnnotationRecreator.createTreeForAnnotation(ann2));
                            continue;
                        }
                        if (group.size() > 0) {
                            AnnotationRecreator.createAnnotationsSequentially(MergeTranscriptionsCommand.this.destTrans, group);
                        }
                        group = new ArrayList();
                        curParent = rootTier.getAnnotationAtTime(ann2.getBeginTimeBoundary());
                        if (!MergeTranscriptionsCommand.this.overwrite && numOverlap != 0) continue;
                        group.add(AnnotationRecreator.createTreeForAnnotation(ann2));
                    }
                    if (group.size() > 0) {
                        AnnotationRecreator.createAnnotationsSequentially(MergeTranscriptionsCommand.this.destTrans, group);
                    }
                }
            } else {
                Vector annotations = tier.getAnnotations();
                if (annotations.size() > 0) {
                    for (int i = 0; i < annotations.size(); ++i) {
                        ann2 = (AbstractAnnotation)annotations.get(i);
                        if (!MergeTranscriptionsCommand.this.overwrite && destTier.getOverlappingAnnotations(ann2.getBeginTimeBoundary(), ann2.getEndTimeBoundary()).size() != 0) continue;
                        recordNode = AnnotationRecreator.createTreeForAnnotation(ann2);
                        AnnotationRecreator.createAnnotationFromTree(MergeTranscriptionsCommand.this.destTrans, recordNode);
                    }
                }
            }
            ClientLogger.LOG.info("Merging of tier " + tier.getName() + " done.");
        }
    }
}

