/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.NewAnnotationCommand;
import mpi.eudico.client.annotator.util.AnnotationDataFlavor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.AnnotationTreeDataFlavor;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.TierNameCompare;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class PasteAnnotationTreeCommand
extends NewAnnotationCommand
implements ClientLogger {
    private DefaultMutableTreeNode node;
    private AnnotationDataRecord record;
    private String destTierName;
    private Long newBeginTime;

    public PasteAnnotationTreeCommand(String name) {
        super(name);
    }

    public void undo() {
        this.transcription.setNotifying(false);
        super.undo();
        this.transcription.setNotifying(true);
    }

    public void redo() {
        if (this.transcription != null) {
            this.setWaitCursor(true);
            this.transcription.setNotifying(false);
            this.newAnnotation();
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
        }
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (this.canAccessSystemClipboard()) {
            TierNameCompare tnc;
            int[] indices;
            Object contents = null;
            Transferable ta = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            try {
                contents = ta.getTransferData(AnnotationTreeDataFlavor.getInstance());
            }
            catch (UnsupportedFlavorException nfe) {
                try {
                    contents = ta.getTransferData(AnnotationDataFlavor.getInstance());
                }
                catch (Exception e) {
                    LOG.warning("Unsupported flavor on the clipboord: " + nfe.getMessage());
                    return;
                }
            }
            catch (IOException ioe) {
                LOG.warning("I/O error: " + ioe.getMessage());
                return;
            }
            if (contents instanceof DefaultMutableTreeNode) {
                this.node = (DefaultMutableTreeNode)contents;
                this.record = (AnnotationDataRecord)this.node.getUserObject();
            } else if (contents instanceof AnnotationDataRecord) {
                this.record = (AnnotationDataRecord)contents;
            } else {
                return;
            }
            this.destTierName = this.record.getTierName();
            if (arguments != null && arguments.length > 0) {
                if (arguments[0] != null) {
                    this.destTierName = (String)arguments[0];
                }
                if (arguments.length > 1) {
                    this.newBeginTime = (Long)arguments[1];
                    if (this.node != null && this.record != null && this.newBeginTime.longValue() != this.record.getBeginTime()) {
                        this.adjustTimes(this.node, this.newBeginTime - this.record.getBeginTime());
                    }
                }
            }
            TierImpl tier = null;
            if (this.destTierName != null && (tier = (TierImpl)this.transcription.getTierWithId(this.destTierName)) != null && this.node != null && !this.destTierName.equals(this.record.getTierName()) && (indices = (tnc = new TierNameCompare()).findCorrespondingAffix(this.record.getTierName(), this.destTierName)) != null && indices[0] > -1) {
                char del = this.record.getTierName().charAt(indices[0]);
                String affix = "";
                if (indices[1] <= 0) {
                    int di = this.destTierName.lastIndexOf(del);
                    if (di > -1) {
                        affix = this.destTierName.substring(di);
                    }
                } else {
                    int di = this.destTierName.indexOf(del);
                    if (di > -1) {
                        affix = this.destTierName.substring(0, di);
                    }
                }
                tnc.adjustTierNames(this.node, affix, del, indices[1]);
            }
            if (tier == null && (tier = (TierImpl)ELANCommandFactory.getViewerManager(this.transcription).getMultiTierControlPanel().getActiveTier()) != null) {
                this.destTierName = tier.getName();
            }
            if (tier == null) {
                LOG.warning("Cannot paste annotation: tier not found: " + this.destTierName);
                return;
            }
            Object[] args = new Long[2];
            if (this.newBeginTime != null) {
                args[0] = this.newBeginTime;
                args[1] = new Long(this.newBeginTime + (this.record.getEndTime() - this.record.getBeginTime()));
            } else {
                args[0] = new Long(this.record.getBeginTime());
                args[1] = new Long(this.record.getEndTime());
            }
            this.transcription.setNotifying(false);
            super.execute(tier, args);
            this.transcription.setNotifying(true);
        }
    }

    void newAnnotation() {
        if (this.node != null) {
            if (this.record != null) {
                if (!this.record.getTierName().equals(this.destTierName)) {
                    super.newAnnotation();
                    if (this.newAnnotation != null) {
                        this.newAnnotation.setValue(this.record.getValue());
                        if (this.record.getExtRef() != null) {
                            ((AbstractAnnotation)this.newAnnotation).setExtRef(this.record.getExtRef());
                        }
                    }
                } else {
                    this.newAnnotation = AnnotationRecreator.createAnnotationFromTree(this.transcription, this.node);
                    if (this.newAnnotation != null) {
                        this.newAnnBegin = this.newAnnotation.getBeginTimeBoundary();
                        this.newAnnEnd = this.newAnnotation.getEndTimeBoundary();
                    }
                }
            }
        } else if (this.record != null) {
            super.newAnnotation();
            if (this.newAnnotation != null) {
                this.newAnnotation.setValue(this.record.getValue());
                if (this.record.getExtRef() != null) {
                    ((AbstractAnnotation)this.newAnnotation).setExtRef(this.record.getExtRef());
                }
            }
        }
    }

    private void adjustTimes(DefaultMutableTreeNode root, long shift) {
        if (root == null) {
            return;
        }
        Enumeration<TreeNode> nodeIt = root.breadthFirstEnumeration();
        while (nodeIt.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)nodeIt.nextElement();
            AnnotationDataRecord adr = (AnnotationDataRecord)n.getUserObject();
            if (adr.getBeginTime() != -1L) {
                adr.setBeginTime(adr.getBeginTime() + shift);
            }
            if (adr.getEndTime() == -1L) continue;
            adr.setEndTime(adr.getEndTime() + shift);
        }
    }

    protected boolean canAccessSystemClipboard() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                return true;
            }
            catch (SecurityException se) {
                LOG.warning("Cannot access the clipboard");
                return false;
            }
        }
        return true;
    }
}

