/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsDS;

public class PlaySelectionCommand
implements Command {
    private String commandName;
    private ElanMediaPlayer player;
    private Selection s;
    private ElanMediaPlayerController mediaPlayerController;
    private long beginTime;
    private long endTime;

    public PlaySelectionCommand(String theName) {
        this.commandName = theName;
    }

    public void execute(Object receiver, Object[] arguments) {
        this.player = (ElanMediaPlayer)receiver;
        this.s = (Selection)arguments[0];
        this.mediaPlayerController = (ElanMediaPlayerController)arguments[1];
        int playAroundSelectionValue = (Integer)arguments[2];
        if (this.player == null) {
            return;
        }
        if (this.player.isPlaying()) {
            this.player.stop();
            this.mediaPlayerController.stopLoop();
            this.mediaPlayerController.setPlaySelectionMode(false);
            if (this.player instanceof NativeMediaPlayerWindowsDS) {
                long t = this.player.getMediaTime();
                this.player.setMediaTime(this.mediaPlayerController.getSelectionEndTime());
                this.player.setStopTime(this.player.getMediaDuration());
                this.player.setMediaTime(t);
            } else {
                this.player.setStopTime(this.player.getMediaDuration());
            }
            return;
        }
        long mediaTime = this.player.getMediaTime();
        this.beginTime = this.s.getBeginTime();
        this.endTime = this.s.getEndTime();
        if (this.beginTime == this.endTime) {
            return;
        }
        if (playAroundSelectionValue > 0) {
            this.beginTime -= (long)playAroundSelectionValue;
            if (this.beginTime < 0L) {
                this.beginTime = 0L;
            }
            this.endTime += (long)playAroundSelectionValue;
            if (this.endTime > this.player.getMediaDuration()) {
                this.endTime = this.player.getMediaDuration();
            }
        }
        if (!this.player.isPlaying() && mediaTime >= this.beginTime && mediaTime < this.endTime - 5L) {
            this.mediaPlayerController.setPlaySelectionMode(true);
            this.playInterval(mediaTime, this.endTime);
            if (this.mediaPlayerController.getLoopMode()) {
                this.delayedStartLoop();
            }
            return;
        }
        if (this.mediaPlayerController.getLoopMode()) {
            this.mediaPlayerController.setPlaySelectionMode(true);
            this.doStartLoop();
        } else {
            this.mediaPlayerController.setPlaySelectionMode(true);
            this.playInterval(this.beginTime, this.endTime);
        }
    }

    private void playInterval(long begin, long end) {
        this.player.playInterval(begin, end);
    }

    public String getName() {
        return this.commandName;
    }

    public void doStartLoop() {
        this.mediaPlayerController.startLoop(this.beginTime, this.endTime);
    }

    private void delayedStartLoop() {
        LoopThread loopthread = new LoopThread();
        loopthread.start();
    }

    private class LoopThread
    extends Thread {
        private LoopThread() {
        }

        public void run() {
            while (PlaySelectionCommand.this.mediaPlayerController.isPlaySelectionMode() && PlaySelectionCommand.this.mediaPlayerController.getLoopMode()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                while (PlaySelectionCommand.this.player.isPlaying()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!PlaySelectionCommand.this.mediaPlayerController.isPlaySelectionMode()) continue;
                PlaySelectionCommand.this.mediaPlayerController.startLoop(PlaySelectionCommand.this.beginTime, PlaySelectionCommand.this.endTime);
            }
        }
    }
}

