/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearPrintable;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class PrintCommand
implements Command {
    public static PrinterJob printJob = PrinterJob.getPrinterJob();
    public static PageFormat pageFormat = printJob.defaultPage();
    private String commandName;

    public PrintCommand(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        Interlinear interlinear;
        Transcription tr = (Transcription)receiver;
        if (arguments == null) {
            interlinear = new Interlinear((TranscriptionImpl)tr);
            interlinear.renderView(new BufferedImage(10, 10, 1));
        } else {
            interlinear = (Interlinear)arguments[0];
        }
        InterlinearPrintable printable = new InterlinearPrintable(interlinear);
        printJob.setPrintable(printable, pageFormat);
        printJob.setPageable(printable);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(tr), ElanLocale.getString("InterlinearizerOptionsDlg.Error.Print") + " \n" + "(" + ex.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    public String getName() {
        return this.commandName;
    }

    static {
        int orient = pageFormat.getOrientation();
        Object curPref = Preferences.get("PageFormat.Height", null);
        double h = curPref instanceof Double ? ((Double)curPref).doubleValue() : pageFormat.getHeight();
        curPref = Preferences.get("PageFormat.Width", null);
        double w = curPref instanceof Double ? ((Double)curPref).doubleValue() : pageFormat.getWidth();
        curPref = Preferences.get("PageFormat.ImgX", null);
        double imgX = curPref instanceof Double ? ((Double)curPref).doubleValue() : pageFormat.getImageableX();
        curPref = Preferences.get("PageFormat.ImgY", null);
        double imgY = curPref instanceof Double ? ((Double)curPref).doubleValue() : pageFormat.getImageableY();
        curPref = Preferences.get("PageFormat.ImgHeight", null);
        double imgH = curPref instanceof Double ? ((Double)curPref).doubleValue() : pageFormat.getImageableHeight();
        curPref = Preferences.get("PageFormat.ImgWidth", null);
        double imgW = curPref instanceof Double ? ((Double)curPref).doubleValue() : pageFormat.getImageableWidth();
        curPref = Preferences.get("PageFormat.Orientation", null);
        if (curPref instanceof Integer) {
            orient = (Integer)curPref;
        }
        Paper p = new Paper();
        p.setSize(w, h);
        p.setImageableArea(imgX, imgY, imgW, imgH);
        PageFormat pf = new PageFormat();
        pf.setOrientation(orient);
        pf.setPaper(p);
        pageFormat = pf;
    }
}

