/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class RegularAnnotationCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    private long start;
    private long end;
    private long realEnd;
    private long annSize;
    private Vector tierNames;
    private Vector tiers;
    private Vector existAnnotationSets;

    public RegularAnnotationCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        if (this.transcription == null || this.tiers == null || this.existAnnotationSets == null) {
            return;
        }
        if (this.tiers.size() != this.existAnnotationSets.size()) {
            LOG.severe("Error while undoing regular annotations.");
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        for (int tierIdx = 0; tierIdx < this.tiers.size(); ++tierIdx) {
            TierImpl tier = (TierImpl)this.tiers.get(tierIdx);
            Vector annos = tier.getAnnotations();
            for (AbstractAnnotation ann : annos) {
                long annBT = ann.getBeginTimeBoundary();
                long annET = ann.getEndTimeBoundary();
                if ((this.start > annBT || annBT >= this.end) && (this.start >= annET || annET > this.end)) continue;
                tier.removeAnnotation(ann);
            }
            ArrayList existAnn = (ArrayList)this.existAnnotationSets.get(tierIdx);
            if (existAnn == null || existAnn.size() <= 0) continue;
            AnnotationRecreator.createAnnotationsSequentially(this.transcription, existAnn);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public void redo() {
        if (this.transcription == null || this.tiers == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        new RegularAnnotationThread().start();
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.start = (Long)arguments[0];
        this.end = (Long)arguments[1];
        this.annSize = (Long)arguments[2];
        this.tierNames = (Vector)arguments[3];
        if (null == this.tierNames || this.tierNames.isEmpty()) {
            LOG.severe("Error in retrieving the tiers.");
            return;
        }
        if (null == this.transcription) {
            LOG.severe("Error in retrieving the transcription.");
            return;
        }
        this.tiers = new Vector();
        for (String tierName : this.tierNames) {
            if (null == tierName) {
                LOG.severe("Error in retrieving the tiers.");
                return;
            }
            TierImpl tier = (TierImpl)this.transcription.getTierWithId(tierName);
            this.tiers.add(tier);
        }
        this.realEnd = this.start + (this.end - this.start) / this.annSize * this.annSize;
        LOG.info("User given end time is " + this.end + "ms; computed end time is " + this.realEnd + "ms");
        this.existAnnotationSets = new Vector();
        for (int i = 0; i < this.tiers.size(); ++i) {
            this.existAnnotationSets.add(new ArrayList());
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.setWaitCursor(true);
        new RegularAnnotationThread().start();
        this.transcription.setTimeChangePropagationMode(curPropMode);
        this.setWaitCursor(false);
    }

    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private class RegularAnnotationThread
    extends Thread {
        RegularAnnotationThread() {
        }

        public void run() {
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(ELANCommandFactory.getRootFrame(RegularAnnotationCommand.this.transcription), true, ElanLocale.getString("RegularAnnotationDialog.Message.Annotating"), true, ElanLocale.getString("Button.Cancel"));
            new Thread(new Runnable(){

                public void run() {
                    monitor.show();
                }
            }).start();
            RegularAnnotationCommand.this.transcription.setNotifying(false);
            for (int tierIdx = 0; tierIdx < RegularAnnotationCommand.this.tiers.size(); ++tierIdx) {
                long annET;
                long annBT;
                TierImpl tier = (TierImpl)RegularAnnotationCommand.this.tiers.get(tierIdx);
                ClientLogger.LOG.info("Creating regular annotations for " + tier.getName() + "...");
                ArrayList existAnnos = (ArrayList)RegularAnnotationCommand.this.existAnnotationSets.get(tierIdx);
                Vector annos = tier.getAnnotations();
                for (AbstractAnnotation ann : annos) {
                    annBT = ann.getBeginTimeBoundary();
                    annET = ann.getEndTimeBoundary();
                    if ((RegularAnnotationCommand.this.start > annBT || annBT >= RegularAnnotationCommand.this.realEnd) && (RegularAnnotationCommand.this.start >= annET || annET > RegularAnnotationCommand.this.realEnd)) continue;
                    existAnnos.add(AnnotationRecreator.createTreeForAnnotation(ann));
                }
                for (AbstractAnnotation ann : annos) {
                    annBT = ann.getBeginTimeBoundary();
                    annET = ann.getEndTimeBoundary();
                    if ((RegularAnnotationCommand.this.start > annBT || annBT >= RegularAnnotationCommand.this.realEnd) && (RegularAnnotationCommand.this.start >= annET || annET > RegularAnnotationCommand.this.realEnd)) continue;
                    tier.removeAnnotation(ann);
                }
                for (long time = RegularAnnotationCommand.this.start; time < RegularAnnotationCommand.this.realEnd; time += RegularAnnotationCommand.this.annSize) {
                    Annotation ann = tier.createAnnotation(time, time + RegularAnnotationCommand.this.annSize);
                }
                if (monitor.isCancelled()) break;
            }
            RegularAnnotationCommand.this.transcription.setNotifying(true);
            monitor.close();
        }
    }
}

