/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.logging.Logger;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.search.result.model.ElanMatch;
import mpi.eudico.client.annotator.search.result.model.Replace;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.search.content.result.model.ContentResult;

public class ReplaceCommand
implements UndoableCommand {
    private String commandName;
    private static final Logger LOG = Logger.getLogger(ReplaceCommand.class.getName());
    private TranscriptionImpl transcription;
    private String replaceString;
    private Annotation[] modifiedAnnotations;
    private String[] oldValues;

    public ReplaceCommand(String name) {
        this.commandName = name;
    }

    public void undo() {
        this.transcription.setNotifying(false);
        for (int i = 0; i < this.modifiedAnnotations.length; ++i) {
            String currentValue = this.modifiedAnnotations[i].getValue();
            this.modifiedAnnotations[i].setValue(this.oldValues[i]);
            this.oldValues[i] = currentValue;
        }
        this.transcription.setNotifying(true);
    }

    public void redo() {
        this.undo();
    }

    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        ContentResult result = (ContentResult)((Object)arguments[0]);
        this.replaceString = (String)arguments[1];
        this.oldValues = new String[result.getRealSize()];
        this.modifiedAnnotations = new Annotation[result.getRealSize()];
        for (int i = 1; i <= result.getRealSize(); ++i) {
            ElanMatch match = (ElanMatch)result.getMatch(i);
            this.modifiedAnnotations[i - 1] = match.getAnnotation();
            this.oldValues[i - 1] = this.modifiedAnnotations[i - 1].getValue();
        }
        Replace.execute(result, this.replaceString, this.transcription);
    }

    public String getName() {
        return this.commandName;
    }
}

