/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortcutsUtil {
    private static ShortcutsUtil shortcutsUtil;
    public static final String ANN_EDIT_CAT = "Frame.ShortcutFrame.Sub.AnnotationEdit";
    public static final String ANN_NAVIGATION_CAT = "Frame.ShortcutFrame.Sub.AnnotationNavigation";
    public static final String TIER_TYPE_CAT = "Frame.ShortcutFrame.Sub.TierType";
    public static final String SELECTION_CAT = "Frame.ShortcutFrame.Sub.Selection";
    public static final String MEDIA_CAT = "Frame.ShortcutFrame.Sub.MediaNavigation";
    public static final String DOCUMENT_CAT = "Frame.ShortcutFrame.Sub.Document";
    public static final String MISC_CAT = "Frame.ShortcutFrame.Sub.Misc";
    private Map<String, List<String>> shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
    private Map<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);

    private ShortcutsUtil() {
        this.fillActionsMap();
        this.fillShortcutMap();
    }

    public static ShortcutsUtil getInstance() {
        if (shortcutsUtil == null) {
            shortcutsUtil = new ShortcutsUtil();
        }
        return shortcutsUtil;
    }

    private void fillActionsMap() {
        ArrayList<String> editActions = new ArrayList<String>(34);
        editActions.add("Menu.Annotation.NewAnnotation");
        editActions.add("Menu.Annotation.NewAnnotationBefore");
        editActions.add("Menu.Annotation.NewAnnotationAfter");
        editActions.add("CommandActions.KeyCreateAnnotation");
        editActions.add("Menu.Annotation.CopyAnnotation");
        editActions.add("Menu.Annotation.CopyAnnotationTree");
        editActions.add("Menu.Annotation.PasteAnnotation");
        editActions.add("Menu.Annotation.PasteAnnotationHere");
        editActions.add("Menu.Annotation.PasteAnnotationTree");
        editActions.add("Menu.Annotation.PasteAnnotationTreeHere");
        editActions.add("Menu.Annotation.DuplicateAnnotation");
        editActions.add("CommandActions.CopyToNextAnnotation");
        editActions.add("Menu.Annotation.ModifyAnnotation");
        editActions.add("CommandActions.ModifyAnnotationTime");
        editActions.add("Menu.Annotation.ModifyAnnotationDatCat");
        editActions.add("CommandActions.Annotation_LBound_Left");
        editActions.add("CommandActions.Annotation_LBound_Right");
        editActions.add("CommandActions.Annotation_RBound_Left");
        editActions.add("CommandActions.Annotation_RBound_Right");
        editActions.add("Menu.Annotation.ShiftActiveAnnotation");
        editActions.add("Menu.Annotation.RemoveAnnotationValue");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        editActions.add("Menu.Tier.RegularAnnotation");
        editActions.add("Menu.Annotation.DeleteAnnotationsInSelection");
        editActions.add("Menu.Annotation.DeleteAnnotationsLeftOf");
        editActions.add("Menu.Annotation.DeleteAnnotationsRightOf");
        editActions.add("Menu.Annotation.DeleteAllLeftOf");
        editActions.add("Menu.Annotation.DeleteAllRightOf");
        editActions.add("Menu.Annotation.ShiftActiveAnnotation");
        editActions.add("Menu.Annotation.ShiftAll");
        editActions.add("Menu.Annotation.ShiftAllLeftOf");
        editActions.add("Menu.Annotation.ShiftAllRightOf");
        editActions.add("Menu.Annotation.ShiftAnnotationsInSelection");
        editActions.add("Menu.Annotation.ShiftAnnotationsLeftOf");
        editActions.add("Menu.Annotation.ShiftAnnotationsRightOf");
        editActions.add("Menu.Annotation.SplitAnnotation");
        this.shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>(8);
        navActions.add("CommandActions.PreviousAnnotation");
        navActions.add("CommandActions.PreviousAnnotationEdit");
        navActions.add("CommandActions.NextAnnotation");
        navActions.add("CommandActions.NextAnnotationEdit");
        navActions.add("CommandActions.AnnotationUp");
        navActions.add("CommandActions.AnnotationDown");
        this.shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList<String> tierActions = new ArrayList<String>(22);
        tierActions.add("Menu.Tier.AddNewTier");
        tierActions.add("Menu.Tier.ChangeTier");
        tierActions.add("Menu.Tier.DeleteTier");
        tierActions.add("Menu.Tier.ReparentTier");
        tierActions.add("Menu.Tier.Tokenize");
        tierActions.add("Menu.Tier.FilterTier");
        tierActions.add("Menu.Tier.CopyTier");
        tierActions.add("Menu.Tier.AnnotationsFromOverlaps");
        tierActions.add("Menu.Tier.MergeTiers");
        tierActions.add("Menu.Tier.AnnotationsFromGaps");
        tierActions.add("Menu.Tier.ChangeCase");
        tierActions.add("Menu.Tier.Segmentation");
        tierActions.add("Menu.Tier.CompareAnnotators");
        tierActions.add("CommandActions.PreviousActiveTier");
        tierActions.add("CommandActions.NextActiveTier");
        tierActions.add("Menu.Tier.RemoveAnnotationsOrValues");
        tierActions.add("Menu.Tier.AnnotationsOnDependentTiers");
        tierActions.add("Menu.Tier.LabelAndNumber");
        tierActions.add("Menu.View.Dependencies");
        tierActions.add("Menu.Type.AddNewType");
        tierActions.add("Menu.Type.ChangeType");
        tierActions.add("Menu.Type.DeleteType");
        this.shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> selActions = new ArrayList<String>(8);
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ClearSelectionAndMode");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        selActions.add("CommandActions.SelectionMode");
        selActions.add("TimeLineViewer.CenterSelection");
        this.shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>(20);
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Options.PlayAroundSelectionDialog");
        medNavActions.add("Menu.Play.PlayStepAndRepeat");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToPreviousScrollview");
        medNavActions.add("Menu.Play.GoToNextScrollview");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("CommandActions.LoopMode");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        this.shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> docActions = new ArrayList<String>(50);
        docActions.add("Menu.File.New");
        docActions.add("Menu.File.Open");
        docActions.add("Menu.File.Save");
        docActions.add("Menu.File.SaveAs");
        docActions.add("Menu.File.SaveAsTemplate");
        docActions.add("Menu.File.SaveSelectionAsEAF");
        docActions.add("Menu.File.MergeTranscriptions");
        docActions.add("Menu.File.Import.Shoebox");
        docActions.add("Menu.File.Import.Toolbox");
        docActions.add("Menu.File.Import.FLEx");
        docActions.add("Menu.File.Import.CHAT");
        docActions.add("Menu.File.Import.Transcriber");
        docActions.add("Menu.File.Import.Delimited");
        docActions.add("Menu.File.Import.PraatTiers");
        docActions.add("Menu.Edit.Preferences.Import");
        docActions.add("Menu.Tier.ImportTiers");
        docActions.add("Menu.Type.ImportTypes");
        docActions.add("Menu.File.Export.Tab");
        docActions.add("Menu.File.Export.AnnotationListMulti");
        docActions.add("Menu.File.Export.WordList");
        docActions.add("Menu.File.Export.Tiers");
        docActions.add("Menu.File.Export.FilmStrip");
        docActions.add("Menu.File.Export.HTML");
        docActions.add("Menu.File.Export.ImageFromWindow");
        docActions.add("Menu.File.Export.Interlinear");
        docActions.add("Menu.File.Export.Media");
        docActions.add("Menu.File.Export.Praat");
        docActions.add("Menu.Edit.Preferences.Export");
        docActions.add("Menu.File.Export.QtSub");
        docActions.add("Menu.File.Export.Shoebox");
        docActions.add("Menu.File.Export.Smil.RealPlayer");
        docActions.add("Menu.File.Export.Smil.QuickTime");
        docActions.add("Menu.File.Export.Subtitles");
        docActions.add("Menu.File.Export.Tab");
        docActions.add("Menu.File.Export.RecognizerTiers");
        docActions.add("Menu.File.Export.Tiger");
        docActions.add("Menu.File.Export.Toolbox");
        docActions.add("Menu.File.Export.TraditionalTransript");
        docActions.add("Menu.File.Export.WordList");
        docActions.add("Menu.File.Print");
        docActions.add("Menu.File.PrintPreview");
        docActions.add("Menu.File.PageSetup");
        docActions.add("Menu.Window.Next");
        docActions.add("Menu.Window.Previous");
        docActions.add("Menu.File.Close");
        docActions.add("Menu.File.Exit");
        this.shortcuttableActions.put(DOCUMENT_CAT, docActions);
        ArrayList<String> miscActions = new ArrayList<String>(28);
        miscActions.add("Menu.Edit.Undo");
        miscActions.add("Menu.Edit.Redo");
        miscActions.add("Menu.Search.Find");
        miscActions.add("Menu.Search.Multiple");
        miscActions.add("Menu.Search.StructuredMultiple");
        miscActions.add("Menu.Search.FindReplaceMulti");
        miscActions.add("CommandActions.PlaybackRateToggle");
        miscActions.add("CommandActions.PlaybackVolumeToggle");
        miscActions.add("Menu.Edit.LinkedFiles");
        miscActions.add("Menu.Edit.EditCV");
        miscActions.add("Menu.Edit.EditLexSrvc");
        miscActions.add("Menu.Edit.Preferences.Edit");
        miscActions.add("Menu.Edit.Preferences.Shortcut");
        miscActions.add("Menu.Edit.Author");
        miscActions.add("Menu.View.FontBrowser");
        miscActions.add("Menu.View.Shortcuts");
        miscActions.add("Menu.View.SpreadSheet");
        miscActions.add("Menu.View.Statistics");
        miscActions.add("Menu.Help.Contents");
        miscActions.add("Menu.Help.About");
        miscActions.add("CommandActions.CopyCurrentTime");
        miscActions.add("Menu.Options.AnnotationMode");
        miscActions.add("Menu.Options.SyncMode");
        miscActions.add("Menu.Options.TranscriptionMode");
        miscActions.add("Menu.Options.SegmentationMode");
        miscActions.add("Menu.Options.BulldozerMode");
        miscActions.add("Menu.Options.NormalPropagationMode");
        miscActions.add("Menu.Options.ShiftMode");
        miscActions.add("MultiTierViewer.ShiftToolTip");
        this.shortcuttableActions.put(MISC_CAT, miscActions);
    }

    private void fillShortcutMap() {
        if (!this.readCurrentShortcuts()) {
            this.loadDefaultShortcuts();
        }
    }

    private void loadDefaultShortcuts() {
        this.shortcutKeyStrokes.put("Menu.Annotation.NewAnnotation", KeyStroke.getKeyStroke(78, 8));
        this.shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Type.AddNewType", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Tier.AddNewTier", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationAfter", KeyStroke.getKeyStroke(78, 9));
        this.shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationBefore", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("CommandActions.AnnotationDown", KeyStroke.getKeyStroke(40, 8));
        this.shortcutKeyStrokes.put("CommandActions.AnnotationUp", KeyStroke.getKeyStroke(38, 8));
        this.shortcutKeyStrokes.put("TimeLineViewer.CenterSelection", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Play.ClearSelectionAndMode", KeyStroke.getKeyStroke(90, 3));
        this.shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        this.shortcutKeyStrokes.put("Menu.File.Close", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.CopyAnnotation", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.CopyAnnotationTree", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("CommandActions.CopyToNextAnnotation", KeyStroke.getKeyStroke(68, 3));
        this.shortcutKeyStrokes.put("CommandActions.CopyCurrentTime", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(68, 8));
        this.shortcutKeyStrokes.put("Menu.Tier.DeleteTier", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Annotation.DuplicateAnnotation", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Edit.EditCV", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("CommandActions.KeyCreateAnnotation", KeyStroke.getKeyStroke(10, 1));
        this.shortcutKeyStrokes.put("Menu.Edit.LinkedFiles", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("CommandActions.LoopMode", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotation", KeyStroke.getKeyStroke(77, 8));
        this.shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotationDatCat", KeyStroke.getKeyStroke(77, 9));
        this.shortcutKeyStrokes.put("CommandActions.ModifyAnnotationTime", KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("CommandActions.Annotation_LBound_Left", KeyStroke.getKeyStroke(74, 2));
        this.shortcutKeyStrokes.put("CommandActions.Annotation_LBound_Right", KeyStroke.getKeyStroke(85, 2));
        this.shortcutKeyStrokes.put("CommandActions.Annotation_RBound_Left", KeyStroke.getKeyStroke(74, 3));
        this.shortcutKeyStrokes.put("CommandActions.Annotation_RBound_Right", KeyStroke.getKeyStroke(85, 3));
        this.shortcutKeyStrokes.put("Menu.Annotation.NewAnnotation", KeyStroke.getKeyStroke(78, 8));
        this.shortcutKeyStrokes.put("CommandActions.NextActiveTier", KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("CommandActions.NextAnnotation", KeyStroke.getKeyStroke(39, 8));
        this.shortcutKeyStrokes.put("CommandActions.NextAnnotationEdit", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Play.GoToNextScrollview", KeyStroke.getKeyStroke(34, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.File.PageSetup", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotation", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationHere", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationTree", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationTreeHere", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8 + 1));
        this.shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        this.shortcutKeyStrokes.put("CommandActions.PlaybackRateToggle", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("CommandActions.PlaybackVolumeToggle", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        this.shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        this.shortcutKeyStrokes.put("Menu.Play.PlayStepAndRepeat", KeyStroke.getKeyStroke(32, 10));
        this.shortcutKeyStrokes.put("CommandActions.PreviousActiveTier", KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("CommandActions.PreviousAnnotation", KeyStroke.getKeyStroke(37, 8));
        this.shortcutKeyStrokes.put("CommandActions.PreviousAnnotationEdit", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Play.GoToPreviousScrollview", KeyStroke.getKeyStroke(33, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.File.Print", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.File.PrintPreview", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.shortcutKeyStrokes.put("Menu.Edit.Redo", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.RemoveAnnotationValue", KeyStroke.getKeyStroke(127, 8));
        this.shortcutKeyStrokes.put("Menu.File.SaveAs", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.File.SaveAsTemplate", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1 + 8));
        this.shortcutKeyStrokes.put("Menu.File.Save", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Search.Find", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Search.Multiple", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        this.shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        this.shortcutKeyStrokes.put("CommandActions.SelectionMode", KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Annotation.ShiftActiveAnnotation", KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        this.shortcutKeyStrokes.put("Menu.Search.StructuredMultiple", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1 + 8));
        this.shortcutKeyStrokes.put("Menu.Edit.Undo", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Help.Contents", KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.File.Exit", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.File.New", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Window.Next", KeyStroke.getKeyStroke(40, 1));
        this.shortcutKeyStrokes.put("Menu.File.Open", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.shortcutKeyStrokes.put("Menu.Window.Previous", KeyStroke.getKeyStroke(38, 1));
        this.addActionsWithoutShortcut();
    }

    private void addActionsWithoutShortcut() {
        for (Map.Entry<String, List<String>> kvpair : this.shortcuttableActions.entrySet()) {
            List<String> actionList = kvpair.getValue();
            for (String action : actionList) {
                if (this.shortcutKeyStrokes.containsKey(action)) continue;
                this.shortcutKeyStrokes.put(action, null);
            }
        }
    }

    public KeyStroke getKeyStrokeForAction(String actionID) {
        if (actionID != null) {
            return this.shortcutKeyStrokes.get(actionID);
        }
        return null;
    }

    public Map<String, KeyStroke> getCurrentShortcuts() {
        return this.shortcutKeyStrokes;
    }

    public Map<String, List<String>> getShortcuttableActions() {
        return this.shortcuttableActions;
    }

    public String getDescriptionForAction(String actionID) {
        if (actionID == null) {
            return "";
        }
        String desc = ElanLocale.getString(actionID + "ToolTip");
        if (desc == null || desc.length() == 0) {
            desc = ElanLocale.getString(actionID);
        }
        return desc;
    }

    public String getCategoryForAction(String actionID) {
        if (actionID == null) {
            return "";
        }
        for (Map.Entry<String, List<String>> pairs : this.shortcuttableActions.entrySet()) {
            String cat = pairs.getKey();
            ArrayList actionList = (ArrayList)pairs.getValue();
            if (!actionList.contains(actionID)) continue;
            return cat;
        }
        return "";
    }

    public String getDescriptionForKeyStroke(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        String nwAcc = "";
        if (SystemReporting.isMacOS()) {
            int modifier = ks.getModifiers();
            if ((modifier & 2) != 0) {
                nwAcc = nwAcc + "\u2303";
            }
            if ((modifier & 1) != 0) {
                nwAcc = nwAcc + "\u21e7";
            }
            if ((modifier & 8) != 0) {
                nwAcc = nwAcc + "\u2325";
            }
            if ((modifier & 4) != 0) {
                nwAcc = nwAcc + "\u2318";
            }
            nwAcc = ks.getKeyChar() == '\uffff' ? (ks.getKeyCode() == 127 ? nwAcc + "Delete" : (ks.getKeyCode() == 33 ? nwAcc + "PageUp" : (ks.getKeyCode() == 34 ? nwAcc + "PageDown" : (ks.getKeyCode() == 32 ? nwAcc + "Space" : nwAcc + KeyEvent.getKeyText(ks.getKeyCode()))))) : nwAcc + String.valueOf(ks.getKeyChar());
        } else {
            int modifier = ks.getModifiers();
            if ((modifier & 2) != 0) {
                nwAcc = nwAcc + "Ctrl+";
            }
            if ((modifier & 8) != 0) {
                nwAcc = nwAcc + "Alt+";
            }
            if ((modifier & 1) != 0) {
                nwAcc = nwAcc + "Shift+";
            }
            nwAcc = ks.getKeyChar() == '\uffff' ? nwAcc + KeyEvent.getKeyText(ks.getKeyCode()) : nwAcc + String.valueOf(ks.getKeyChar());
        }
        return nwAcc;
    }

    public void restoreDefaultShortcuts() {
        this.shortcutKeyStrokes.clear();
        this.loadDefaultShortcuts();
        JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.Restored"));
    }

    public boolean readCurrentShortcuts() {
        String pref_filepath = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "shortcuts.pfsx";
        PreferencesReader xmlPrefsReader = new PreferencesReader();
        HashMap<String, KeyStroke> shortcutMap = new HashMap<String, KeyStroke>();
        HashMap shortcutMapRaw = null;
        try {
            shortcutMapRaw = (HashMap)xmlPrefsReader.parse(pref_filepath);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load the keyboard shortcut preferences file");
        }
        if (shortcutMapRaw != null && !shortcutMapRaw.isEmpty()) {
            for (Map.Entry pair : shortcutMapRaw.entrySet()) {
                String actionName = (String)pair.getKey();
                Object val = pair.getValue();
                if (!(val instanceof ArrayList)) continue;
                ArrayList codes = (ArrayList)val;
                if (codes.isEmpty()) {
                    shortcutMap.put(actionName, null);
                    continue;
                }
                int keycode = Integer.parseInt((String)codes.get(0));
                int modcode = Integer.parseInt((String)codes.get(1));
                KeyStroke aks = KeyStroke.getKeyStroke(keycode, modcode);
                shortcutMap.put(actionName, aks);
            }
            this.shortcutKeyStrokes = shortcutMap;
            this.addActionsWithoutShortcut();
            return true;
        }
        return false;
    }

    public void saveCurrentShortcuts(HashMap<String, List<String>> shortcutMap) {
        String pref_filepath = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "shortcuts.pfsx";
        PreferencesWriter xmlPrefsWriter = new PreferencesWriter();
        try {
            xmlPrefsWriter.encodeAndSave(shortcutMap, pref_filepath);
            JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.Saved"));
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not save the keyboard shortcut preferences file");
            JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.NotSaved"));
        }
    }
}

