/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.EscCloseAction;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import nl.mpi.util.gui.TreeFrame;

public class TierDependenciesCA
extends CommandAction
implements ACMEditListener {
    private JFrame dependencyFrame;
    private int locationX = -1;
    private int locationY = -1;
    private int sizeWidth = -1;
    private int sizeHeight = -1;

    public TierDependenciesCA(ViewerManager2 theVM) {
        super(theVM, "Menu.View.Dependencies");
        try {
            this.vm.getTranscription().addACMEditListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.View.Dependencies");
    }

    protected Object getReceiver() {
        return null;
    }

    protected Object[] getArguments() {
        Object[] args = new Object[]{this.getDependencyFrame()};
        return args;
    }

    public JFrame getFrame() {
        return this.dependencyFrame;
    }

    private JFrame getDependencyFrame() {
        if (this.dependencyFrame == null) {
            this.createDependencyFrame();
        }
        return this.dependencyFrame;
    }

    private void createDependencyFrame() {
        try {
            this.dependencyFrame = new TreeFrame((TreeNode)new TierTree(this.vm.getTranscription()).getTree(), false);
            ((TreeFrame)this.dependencyFrame).setTreeBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.dependencyFrame.setTitle(ElanLocale.getString("Tier Dependencies"));
            if (this.locationX != -1 && this.locationY != -1 && this.sizeWidth != -1 && this.sizeHeight != -1) {
                this.dependencyFrame.setLocation(this.locationX, this.locationY);
                this.dependencyFrame.setSize(this.sizeWidth, this.sizeHeight);
            }
            if (this.dependencyFrame.getHeight() < 100 || this.dependencyFrame.getWidth() < 133) {
                this.dependencyFrame.setSize(133, 200);
            }
            this.addCloseActions();
            this.updateLocale();
        }
        catch (Exception ex) {
            System.out.println("Couldn't create dependencyFrame.");
            ex.printStackTrace();
        }
    }

    public void updateLocale() {
        super.updateLocale();
        if (this.dependencyFrame != null) {
            this.dependencyFrame.setTitle(ElanLocale.getString("Menu.View.DependenciesDialog"));
            this.dependencyFrame.repaint();
        }
    }

    protected void addCloseActions() {
        if (this.dependencyFrame != null) {
            EscCloseAction escAction = new EscCloseAction(this.dependencyFrame);
            CtrlWCloseAction wAction = new CtrlWCloseAction(this.dependencyFrame);
            InputMap inputMap = this.dependencyFrame.getRootPane().getInputMap(2);
            ActionMap actionMap = this.dependencyFrame.getRootPane().getActionMap();
            if (inputMap instanceof ComponentInputMap && actionMap != null) {
                String esc = "esc";
                inputMap.put((KeyStroke)escAction.getValue("AcceleratorKey"), esc);
                actionMap.put(esc, escAction);
                String wcl = "cw";
                inputMap.put((KeyStroke)wAction.getValue("AcceleratorKey"), wcl);
                actionMap.put(wcl, wAction);
            }
            this.dependencyFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    TierDependenciesCA.this.vm.getTranscription().removeACMEditListener(TierDependenciesCA.this);
                }
            });
        }
    }

    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 2: {
                if (this.dependencyFrame == null) break;
                boolean bVisible = this.dependencyFrame.isVisible();
                this.locationX = (int)this.dependencyFrame.getLocation().getX();
                this.locationY = (int)this.dependencyFrame.getLocation().getY();
                this.sizeWidth = (int)this.dependencyFrame.getSize().getWidth();
                this.sizeHeight = (int)this.dependencyFrame.getSize().getHeight();
                this.dependencyFrame.dispose();
                this.createDependencyFrame();
                if (this.command == null || !bVisible) break;
                this.command.execute(this.getReceiver(), this.getArguments());
            }
        }
    }
}

