/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ImportCHATMA
extends FrameMenuAction {
    public ImportCHATMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    public void actionPerformed(ActionEvent ae) {
        JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("ExportCHATDialog.Message.CLANutility"), "ELAN", 1);
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(ElanFileFilter.createFileFilter(5));
        chooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"));
        String dirPath = (String)Preferences.get("LastUsedCHATDir", null);
        if (dirPath == null) {
            dirPath = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File(dirPath));
        int returnVal = chooser.showOpenDialog(this.frame);
        if (returnVal == 0) {
            String fullPath = chooser.getSelectedFile().getAbsolutePath();
            File fileTemp = new File(fullPath);
            if (!fileTemp.exists() || fileTemp.isDirectory()) {
                String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage = strMessage + fullPath;
                strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this.frame, strMessage, strError, 0);
                return;
            }
            if (!fileTemp.toString().toLowerCase().endsWith(".cha")) {
                String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage = strMessage + fullPath;
                strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message3");
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this.frame, strMessage, strError, 0);
                return;
            }
            try {
                int answer;
                String path = fullPath;
                Preferences.set("LastUsedCHATDir", new File(path).getParent(), null);
                path = path.replace('\\', '/');
                TranscriptionImpl transcription = new TranscriptionImpl(new File(path).getAbsolutePath());
                transcription.setChanged();
                int lastSlash = path.lastIndexOf(47);
                String chatPath = path.substring(0, lastSlash);
                boolean validMedia = true;
                if (this.frame != null) {
                    this.frame.checkMedia(transcription, chatPath);
                }
                if (!validMedia && (answer = JOptionPane.showConfirmDialog(this.frame, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaQuestion"), ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0)) != 0) {
                    return;
                }
                FrameManager.getInstance().createFrame(transcription);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

