/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.ImportCSVDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;

public class ImportDelimitedTextMA
extends FrameMenuAction {
    public ImportDelimitedTextMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(ElanFileFilter.createFileFilter(20));
        chooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"));
        String dirPath = (String)Preferences.get("LastUsedCSVDir", null);
        if (dirPath == null) {
            dirPath = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File(dirPath));
        int returnVal = chooser.showOpenDialog(this.frame);
        File csvFile = null;
        String fullPath = null;
        if (returnVal == 0) {
            fullPath = chooser.getSelectedFile().getAbsolutePath();
            File fileTemp = new File(fullPath);
            if (!fileTemp.exists() || fileTemp.isDirectory()) {
                String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage = strMessage + fullPath;
                strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this.frame, strMessage, strError, 0);
                return;
            }
            csvFile = fileTemp;
            ImportCSVDialog dialog = new ImportCSVDialog((Frame)this.frame, fileTemp);
            Object value = dialog.showDialog();
            if (value == null || !(value instanceof DelimitedTextDecoderInfo)) {
                return;
            }
            DelimitedTextDecoderInfo decInfo = (DelimitedTextDecoderInfo)value;
            try {
                String path = fullPath;
                Preferences.set("LastUsedCSVDir", new File(path).getParent(), null);
                path = path.replace('\\', '/');
                path = decInfo.getSourceFilePath();
                TranscriptionImpl transcription = new TranscriptionImpl(path, decInfo);
                transcription.setChanged();
                FrameManager.getInstance().createFrame(transcription);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

