/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ImportRecognizerTiersMA
extends FrameMenuAction {
    public ImportRecognizerTiersMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    public void actionPerformed(ActionEvent e) {
        String filePath;
        TranscriptionImpl transcription = new TranscriptionImpl();
        LinguisticType type = null;
        if (transcription.getLinguisticTypes().size() == 0) {
            type = new LinguisticType("recognizer");
            transcription.addLinguisticType(type);
            transcription.setChanged();
        }
        if ((filePath = this.promptForTierFile()) == null) {
            return;
        }
        File f = new File(filePath);
        if (f.exists() && f.canRead()) {
            List<Segmentation> segm = null;
            if (filePath.endsWith("csv")) {
                CsvTierIO cio = new CsvTierIO();
                segm = cio.read(f);
            } else {
                XmlTierIO xio = new XmlTierIO(f);
                segm = xio.parse();
            }
            if (segm != null && segm.size() > 0) {
                int numTiersCreated = 0;
                transcription.setNotifying(false);
                for (Segmentation s : segm) {
                    if (s == null) continue;
                    TierImpl t = new TierImpl(s.getName(), null, transcription, type);
                    transcription.addTier(t);
                    ++numTiersCreated;
                    ArrayList<RSelection> segments = s.getSegments();
                    for (RSelection sel : segments) {
                        AlignableAnnotation aa;
                        if (sel == null || (aa = (AlignableAnnotation)t.createAnnotation(sel.beginTime, sel.endTime)) == null || !(sel instanceof Segment) || ((Segment)sel).label == null) continue;
                        aa.setValue(((Segment)sel).label);
                    }
                }
                if (numTiersCreated > 0) {
                    FrameManager.getInstance().createFrame(transcription);
                } else {
                    JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoTiers"), ElanLocale.getString("Message.Error"), 2);
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.NoTiers"), ElanLocale.getString("Message.Error"), 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed"), ElanLocale.getString("Message.Error"), 2);
        }
    }

    private String promptForTierFile() {
        String prefPath = null;
        Object val = Preferences.get("Recognizer.Path", null);
        if (val instanceof String) {
            prefPath = (String)val;
        }
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(20);
        FileFilter ff2 = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.addChoosableFileFilter(ff2);
        chooser.setFileFilter(ff2);
        if (chooser.showOpenDialog(this.frame) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("Recognizer.Path", par.getAbsolutePath(), null);
            }
            if (chooser.getFileFilter() == ff) {
                String lower = f.getAbsolutePath().toLowerCase();
                boolean valid = false;
                for (int i = 0; i < FileExtension.CSV_EXT.length; ++i) {
                    if (!lower.endsWith(FileExtension.CSV_EXT[i])) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    f = new File(f.getAbsolutePath() + "." + FileExtension.CSV_EXT[0]);
                }
            } else if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            return f.getAbsolutePath();
        }
        return null;
    }
}

