/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.util.SystemReporting;

public class MenuAction
extends AbstractAction
implements ElanLocaleListener {
    public static final String MNEMONIC = "MNEMONIC.";
    protected String commandId;
    private static boolean useMnemonics = true;

    public MenuAction(String name) {
        super(name);
        this.commandId = name;
        this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction(this.commandId));
        this.updateLocale();
    }

    public void updateLocale() {
        if (this.commandId != null) {
            String mnemonic;
            this.putValue("Name", ElanLocale.getString(this.commandId));
            Object desc = this.getValue("ShortDescription");
            if (desc instanceof String && ((String)desc).length() > 0) {
                this.putValue("ShortDescription", ElanLocale.getString(this.commandId + "ToolTip"));
            }
            if (useMnemonics && (mnemonic = ElanLocale.getString(MNEMONIC + this.commandId)).length() > 0) {
                try {
                    this.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
                }
                catch (NumberFormatException nfe) {
                    try {
                        this.putValue("MnemonicKey", new Integer(mnemonic));
                    }
                    catch (NumberFormatException nfe2) {
                        this.putValue("MnemonicKey", null);
                    }
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    static {
        if (SystemReporting.isMacOS()) {
            useMnemonics = false;
        }
    }
}

