/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileAnnotationsFromOverlapsCommand
implements ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    private String[] sourceTiers;
    private String destTierName;
    private LinguisticType destLingType;
    private int annotationValueType;
    private String timeFormat;
    private String annWithValue;
    private String annFromTier;
    private int overlapsCriteria;
    private List<String[]> tierValueConstraints;
    private int transcriptionMode;
    private TranscriptionImpl[] filenames;
    private boolean usePalFormat;
    private String parentTierName;
    private static final int OVERLAP_CRITERIA_OVERLAP = 0;
    private static final int OVERLAP_CRITERIA_VALUES_EQUAL = 1;
    private static final int OVERLAP_CRITERIA_VALUES_NOT_EQUAL = 2;
    private static final int OVERLAP_CRITERIA_USE_SPECIFIED_CONSTRAINTS = 3;
    private boolean destTierCreated = false;

    public void execute(TranscriptionImpl transImpl, Object[] arguments) {
        this.transcription = transImpl;
        Object[] objectArray = (Object[])arguments[0];
        this.sourceTiers = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.sourceTiers[i] = objectArray[i].toString();
        }
        this.destTierName = (String)arguments[1];
        this.destLingType = (LinguisticType)arguments[2];
        this.annotationValueType = (Integer)arguments[3];
        this.timeFormat = (String)arguments[4];
        this.annWithValue = (String)arguments[5];
        this.annFromTier = (String)arguments[6];
        List tierOrder = (List)arguments[7];
        if (tierOrder != null && this.annotationValueType == 4) {
            this.sourceTiers = new String[tierOrder.size()];
            for (int i = 0; i < tierOrder.size(); ++i) {
                this.sourceTiers[i] = tierOrder.get(i).toString();
            }
        }
        this.overlapsCriteria = (Integer)arguments[8];
        this.tierValueConstraints = (List)arguments[9];
        this.transcriptionMode = (Integer)arguments[10];
        this.usePalFormat = (Boolean)arguments[12];
        this.parentTierName = (String)arguments[13];
        Object[] filenamesObj = null;
        if (arguments[11] != null) {
            filenamesObj = (Object[])arguments[11];
            this.filenames = new TranscriptionImpl[filenamesObj.length];
            for (int i = 0; i < filenamesObj.length; ++i) {
                this.filenames[i] = (TranscriptionImpl)filenamesObj[i];
            }
        }
        if (this.transcriptionMode == 0) {
            this.createAnnotations(this.transcription);
        } else if (this.transcriptionMode == 1) {
            for (TranscriptionImpl t : this.filenames) {
                this.createAnnotations(t);
                if (t.isChanged()) {
                    String directoryToSave = t.getPathName();
                    try {
                        ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(t, null, new Vector(), directoryToSave, 0);
                    }
                    catch (IOException e) {
                        LOG.warning("Can not write transcription to file with directory/filename: " + directoryToSave);
                    }
                    continue;
                }
                ClientLogger.LOG.info("Transcription not changed: " + t.getName());
            }
        }
    }

    public String getName() {
        return this.commandName;
    }

    private void createAnnotations(TranscriptionImpl t) {
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>();
        TierImpl parentTier = (TierImpl)t.getTierWithId(this.parentTierName);
        for (int i = 0; i < this.sourceTiers.length; ++i) {
            TierImpl tier = (TierImpl)t.getTierWithId(this.sourceTiers[i]);
            if (tier == null) {
                return;
            }
            tierList.add(tier);
        }
        if (parentTier == null && this.destLingType.getConstraints() != null) {
            ClientLogger.LOG.severe("Tier to be created has an invalid linguistic type (tier should not be a root tier)");
            return;
        }
        LinguisticType typeToUse = t.getLinguisticTypeByName(this.destLingType.getLinguisticTypeName());
        if (typeToUse == null) {
            ClientLogger.LOG.severe("Linguistic type for the tier to be created is not present in this transcription: " + t.getName());
            return;
        }
        if (typeToUse.getConstraints() == null && this.destLingType.getConstraints() != null || typeToUse.getConstraints() != null && this.destLingType.getConstraints() == null || typeToUse.getConstraints() != null && this.destLingType.getConstraints() != null && typeToUse.getConstraints().getStereoType() != this.destLingType.getConstraints().getStereoType()) {
            ClientLogger.LOG.severe("Linguistic type for the tier to be created in this transcription is not compatible with the selected type: " + t.getName());
            return;
        }
        TierImpl dTier = new TierImpl(parentTier, this.destTierName, ((TierImpl)tierList.get(0)).getParticipant(), t, typeToUse);
        dTier.setAnnotator(((TierImpl)tierList.get(0)).getAnnotator());
        dTier.setDefaultLocale(((TierImpl)tierList.get(0)).getDefaultLocale());
        t.addTier(dTier);
        this.destTierCreated = true;
        int curPropMode = t.getTimeChangePropagationMode();
        t.setNotifying(false);
        if (curPropMode != 0) {
            t.setTimeChangePropagationMode(0);
        }
        ArrayList<Overlap> commonOverlaps = this.getCommonOverlaps(tierList);
        AlignableAnnotation aa = null;
        int numAnnCreated = 0;
        for (int i = 0; i < commonOverlaps.size(); ++i) {
            Overlap overlap = commonOverlaps.get(i);
            if (overlap.end <= overlap.begin) {
                ClientLogger.LOG.warning("Cannot create annotation, begin time >= end time: " + overlap.begin + " - " + overlap.end);
                continue;
            }
            aa = (AlignableAnnotation)dTier.createAnnotation(overlap.begin, overlap.end);
            if (aa != null) {
                switch (this.annotationValueType) {
                    case 0: {
                        aa.setValue(this.getTimeString(overlap.end - overlap.begin));
                        break;
                    }
                    case 1: {
                        aa.setValue(this.annWithValue);
                        break;
                    }
                    case 2: {
                        aa.setValue(overlap.value);
                        break;
                    }
                    case 3: 
                    case 4: {
                        aa.setValue(overlap.value);
                    }
                }
                ++numAnnCreated;
                continue;
            }
            ClientLogger.LOG.warning("Annotation could not be created " + overlap.begin + "-" + overlap.end);
        }
        ClientLogger.LOG.info("Number of annotations created: " + numAnnCreated);
        if (t.getTimeChangePropagationMode() != curPropMode) {
            t.setTimeChangePropagationMode(curPropMode);
        }
        t.setNotifying(true);
    }

    private String getTimeString(long time) {
        if ("hh:mm:ss.ms".equals(this.timeFormat)) {
            return TimeFormatter.toString(time);
        }
        if ("ss.ms".equals(this.timeFormat)) {
            return TimeFormatter.toSSMSString(time);
        }
        if ("hh:mm:ss:ff".equals(this.timeFormat)) {
            if (this.usePalFormat) {
                return TimeFormatter.toTimecodePAL(time);
            }
            return TimeFormatter.toTimecodeNTSC(time);
        }
        return String.valueOf(time);
    }

    private ArrayList<Overlap> getCommonOverlaps(ArrayList<TierImpl> tierList) {
        long beginTime;
        int i;
        ArrayList<Overlap> overlapList = new ArrayList<Overlap>();
        long timeSoFar = 0L;
        if (tierList.size() <= 0) {
            return overlapList;
        }
        TierImpl currentTier = tierList.get(0);
        Vector annotations = currentTier.getAnnotations();
        if (annotations.size() <= 0) {
            return overlapList;
        }
        String constraint = this.getConstraint(currentTier.getName());
        for (i = 0; i < annotations.size(); ++i) {
            AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(i);
            beginTime = abstrAnnotation.getBeginTimeBoundary();
            long endTime = abstrAnnotation.getEndTimeBoundary();
            if (this.overlapsCriteria == 3 && (constraint == null || !constraint.equals(abstrAnnotation.getValue()))) continue;
            overlapList.add(new Overlap(beginTime, endTime, abstrAnnotation.getValue()));
        }
        block1: for (i = 1; i < tierList.size() && overlapList.size() > 0; ++i) {
            currentTier = tierList.get(i);
            annotations = currentTier.getAnnotations();
            constraint = this.getConstraint(currentTier.getName());
            boolean valueFromCurrentTier = this.annotationValueType == 2 && currentTier.getName().equals(this.annFromTier);
            for (int overlapNr = 0; overlapNr < overlapList.size(); ++overlapNr) {
                if (annotations.size() <= 0) {
                    for (int j = overlapList.size() - 1; j >= overlapNr; --j) {
                        overlapList.remove(j);
                    }
                    continue block1;
                }
                AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(0);
                beginTime = abstrAnnotation.getBeginTimeBoundary();
                long endTime = abstrAnnotation.getEndTimeBoundary();
                constraint = this.getConstraint(currentTier.getName());
                boolean matchConstraint = this.checkConstraint(overlapList.get((int)overlapNr).value, abstrAnnotation.getValue(), this.overlapsCriteria, constraint);
                if (!matchConstraint) {
                    if (endTime < overlapList.get((int)overlapNr).end) {
                        annotations.remove(0);
                    } else {
                        overlapList.remove(overlapNr);
                    }
                    --overlapNr;
                    continue;
                }
                if (endTime < overlapList.get((int)overlapNr).begin) {
                    annotations.remove(0);
                    --overlapNr;
                    continue;
                }
                if (beginTime < overlapList.get((int)overlapNr).begin && endTime <= overlapList.get((int)overlapNr).end) {
                    if (endTime < overlapList.get((int)overlapNr).end) {
                        if (valueFromCurrentTier) {
                            overlapList.add(overlapNr, new Overlap(overlapList.get((int)overlapNr).begin, endTime, abstrAnnotation.getValue()));
                        } else if (this.annotationValueType == 3) {
                            overlapList.add(overlapNr, new Overlap(overlapList.get((int)overlapNr).begin, endTime, abstrAnnotation.getValue() + " " + overlapList.get((int)overlapNr).value));
                        } else if (this.annotationValueType == 4) {
                            overlapList.add(overlapNr, new Overlap(overlapList.get((int)overlapNr).begin, endTime, overlapList.get((int)overlapNr).value + " " + abstrAnnotation.getValue()));
                        } else {
                            overlapList.add(overlapNr, new Overlap(overlapList.get((int)overlapNr).begin, endTime, overlapList.get((int)overlapNr).value));
                        }
                        overlapList.get((int)(overlapNr + 1)).begin = endTime;
                    } else {
                        if (valueFromCurrentTier) {
                            overlapList.get((int)overlapNr).value = abstrAnnotation.getValue();
                        } else if (this.annotationValueType == 3) {
                            overlapList.get((int)overlapNr).value = abstrAnnotation.getValue() + " " + overlapList.get((int)overlapNr).value;
                        } else if (this.annotationValueType == 4) {
                            overlapList.get((int)overlapNr).value = overlapList.get((int)overlapNr).value + " " + abstrAnnotation.getValue();
                        }
                        overlapList.get((int)overlapNr).end = endTime;
                    }
                    annotations.remove(0);
                    continue;
                }
                if (beginTime >= overlapList.get((int)overlapNr).begin && endTime <= overlapList.get((int)overlapNr).end) {
                    if (endTime < overlapList.get((int)overlapNr).end) {
                        if (valueFromCurrentTier) {
                            overlapList.add(overlapNr, new Overlap(beginTime, endTime, abstrAnnotation.getValue()));
                        } else if (this.annotationValueType == 3 || this.annotationValueType == 4) {
                            overlapList.add(overlapNr, new Overlap(beginTime, endTime, overlapList.get((int)overlapNr).value + " " + abstrAnnotation.getValue()));
                        } else {
                            overlapList.add(overlapNr, new Overlap(beginTime, endTime, overlapList.get((int)overlapNr).value));
                        }
                        overlapList.get((int)(overlapNr + 1)).begin = endTime;
                    } else {
                        if (valueFromCurrentTier) {
                            overlapList.get((int)overlapNr).value = abstrAnnotation.getValue();
                        } else if (this.annotationValueType == 3 || this.annotationValueType == 4) {
                            overlapList.get((int)overlapNr).value = overlapList.get((int)overlapNr).value + " " + abstrAnnotation.getValue();
                        }
                        overlapList.get((int)overlapNr).begin = beginTime;
                    }
                    annotations.remove(0);
                    continue;
                }
                if (beginTime >= overlapList.get((int)overlapNr).begin && endTime > overlapList.get((int)overlapNr).end) {
                    overlapList.get((int)overlapNr).begin = beginTime;
                    if (valueFromCurrentTier) {
                        overlapList.get((int)overlapNr).value = abstrAnnotation.getValue();
                        continue;
                    }
                    if (this.annotationValueType != 3 && this.annotationValueType != 4) continue;
                    overlapList.get((int)overlapNr).value = overlapList.get((int)overlapNr).value + " " + abstrAnnotation.getValue();
                    continue;
                }
                if (beginTime < overlapList.get((int)overlapNr).begin && endTime > overlapList.get((int)overlapNr).end) {
                    if (valueFromCurrentTier) {
                        overlapList.get((int)overlapNr).value = abstrAnnotation.getValue();
                        continue;
                    }
                    if (this.annotationValueType == 3) {
                        overlapList.get((int)overlapNr).value = abstrAnnotation.getValue() + " " + overlapList.get((int)overlapNr).value;
                        continue;
                    }
                    if (this.annotationValueType != 4) continue;
                    overlapList.get((int)overlapNr).value = overlapList.get((int)overlapNr).value + " " + abstrAnnotation.getValue();
                    continue;
                }
                if (beginTime < overlapList.get((int)overlapNr).end) continue;
                overlapList.remove(overlapNr);
                --overlapNr;
            }
        }
        return overlapList;
    }

    private boolean checkConstraint(String overlapValue, String newValue, int overlapsCriteria, String constraint) {
        if (overlapsCriteria == 0) {
            return true;
        }
        if (overlapsCriteria == 1) {
            return overlapValue.equals(newValue);
        }
        if (overlapsCriteria == 2) {
            return !overlapValue.equals(newValue);
        }
        if (overlapsCriteria == 3) {
            return constraint == null || newValue.equals(constraint);
        }
        return true;
    }

    private String getConstraint(String tierName) {
        for (int i = 0; i < this.tierValueConstraints.size(); ++i) {
            if (!this.tierValueConstraints.get(i)[0].equals(tierName)) continue;
            return this.tierValueConstraints.get(i)[1];
        }
        return null;
    }

    private class Overlap {
        public long begin;
        public long end;
        public String value;

        public Overlap(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }

        public Overlap(long begin, long end, String value) {
            this(begin, end);
            this.value = value;
        }
    }
}

