/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.MultiFileChooser;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class NewMA
extends FrameMenuAction {
    public NewMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        Vector mediaDescriptors = new Vector();
        Vector<String> fileNames = null;
        MultiFileChooser chooser = new MultiFileChooser(1);
        chooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.NewDialog.Title"));
        int option = chooser.showDialog(this.frame, null);
        if (option == 0) {
            Object[] files = chooser.getFiles();
            if (files.length > 0) {
                fileNames = new Vector<String>();
                for (i = 0; i < files.length; ++i) {
                    if (fileNames.contains(files[i])) continue;
                    fileNames.add("" + files[i]);
                }
            }
        } else {
            return;
        }
        if (fileNames != null) {
            TranscriptionImpl nextTranscription;
            int fileNames_size = fileNames.size();
            for (i = 0; i < fileNames_size; ++i) {
                String strFile = (String)fileNames.elementAt(i);
                if (strFile.startsWith("rtsp") || new File(strFile).exists()) continue;
                String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage = strMessage + new File(strFile).getName();
                strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this.frame, strMessage, strError, 0);
                return;
            }
            String strTemplate = "";
            for (int i2 = fileNames_size - 1; i2 >= 0; --i2) {
                String strFile = (String)fileNames.elementAt(i2);
                if (!strFile.toLowerCase().endsWith(".etf")) continue;
                strTemplate = (String)fileNames.elementAt(i2);
                fileNames.remove(i2);
            }
            mediaDescriptors = MediaDescriptorUtil.createMediaDescriptors(fileNames);
            if (strTemplate.equals("")) {
                nextTranscription = new TranscriptionImpl();
                if (nextTranscription.getLinguisticTypes().size() == 0 && nextTranscription.getTiers().size() == 0) {
                    LinguisticType type = new LinguisticType("default-lt");
                    TierImpl tier = new TierImpl("default", "", nextTranscription, type);
                    nextTranscription.addLinguisticType(type);
                    nextTranscription.addTier(tier);
                    tier.setDefaultLocale(null);
                }
            } else {
                nextTranscription = new TranscriptionImpl(new File(strTemplate).getAbsolutePath());
                nextTranscription.setName("aishug294879ryshfda9763afo8947a5gf");
                nextTranscription.setPathName("aishug294879ryshfda9763afo8947a5gf");
                if (nextTranscription.getControlledVocabularies().size() > 0) {
                    new TranscriptionECVLoader().loadExternalCVs(nextTranscription, this.frame);
                }
            }
            nextTranscription.setMediaDescriptors(mediaDescriptors);
            nextTranscription.setChanged();
            if (!strTemplate.equals("")) {
                String prefPath = strTemplate.substring(0, strTemplate.length() - 3) + "pfsx";
                try {
                    File pFile = new File(prefPath);
                    if (pFile.exists()) {
                        Preferences.importPreferences(nextTranscription, prefPath);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            ElanFrame2 frame = FrameManager.getInstance().createFrame(nextTranscription);
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(null).log(MonitoringLogger.NEW_FILE, new String[0]);
                MonitoringLogger.getLogger(frame.getViewerManager().getTranscription()).log(MonitoringLogger.NEW_FILE, new String[0]);
            }
        }
    }
}

