/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.LogTextFrame;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.ErrOutLogFileHandler;

public class ShowLogMA
extends FrameMenuAction {
    public ShowLogMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Enumeration<String> en = LogManager.getLogManager().getLoggerNames();
            boolean handlerFound = false;
            block5: while (en.hasMoreElements()) {
                Logger l = LogManager.getLogManager().getLogger(en.nextElement());
                Handler[] h = l.getHandlers();
                for (int i = 0; i < h.length; ++i) {
                    if (!(h[i] instanceof ErrOutLogFileHandler)) continue;
                    ErrOutLogFileHandler target = (ErrOutLogFileHandler)h[i];
                    String fileName = "";
                    handlerFound = true;
                    try {
                        String s = target.getCurrentContent();
                        this.showLog(s);
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.warning("Cannot read from the log file: " + fileName + " : " + ioe.getMessage());
                        this.showMessage(ElanLocale.getString("ExportDialog.LogView.Message") + "\n" + fileName + " : " + ioe.getMessage());
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Cannot read from the log file: " + fileName + " : " + ex.getMessage());
                        this.showMessage(ElanLocale.getString("ExportDialog.LogView.Message") + "\n" + fileName + " : " + ex.getMessage());
                    }
                    continue block5;
                }
            }
            if (!handlerFound) {
                this.showMessage(ElanLocale.getString("ExportDialog.LogView.Message") + "\n" + ElanLocale.getString("ExportDialog.LogView.Message2"));
            }
        }
        catch (Exception exc) {
            this.showMessage(ElanLocale.getString("ExportDialog.LogView.Message") + "\n" + exc.getMessage());
        }
    }

    private void showLog(String log) {
        if (log != null) {
            LogTextFrame ltframe = new LogTextFrame(ElanLocale.getString("ExportDialog.LogView.Title"), log);
            ltframe.pack();
            ltframe.setLocationRelativeTo(this.frame);
            ltframe.setVisible(true);
        }
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this.frame, message, ElanLocale.getString("Warning"), 2);
    }
}

