/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;

public class WebMA
extends FrameMenuAction {
    private String url;

    public WebMA(String name, ElanFrame2 frame, String webpageURL) {
        super(name, frame);
        this.url = webpageURL;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.url == null) {
            return;
        }
        if (SystemReporting.isMacOS()) {
            String[] command = new String[]{"open", this.url};
            String error = this.execCommand(command);
            if (error != null) {
                this.errorMessage(error);
            }
        } else if (SystemReporting.isWindows()) {
            String[] command = new String[]{"rundll32", "url.dll", "FileProtocolHandler", this.url};
            String error = this.execCommand(command);
            if (error != null) {
                this.errorMessage(error);
            }
        } else {
            String[][] commands = new String[][]{{"xdg-open", this.url}, {"gnome-open", this.url}, {"kde-open", this.url}, {"firefox", this.url}};
            String error = "";
            for (int i = 0; i < commands.length; ++i) {
                String nextError = this.execCommand(commands[i]);
                if (nextError == null) {
                    return;
                }
                error = error + ", " + nextError;
            }
            this.errorMessage(error);
        }
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Message.Web.NoConnection") + ": " + message, ElanLocale.getString("Message.Warning"), 2);
    }

    private String execCommand(String[] command) {
        try {
            Process proc = Runtime.getRuntime().exec(command);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        catch (SecurityException se) {
            ClientLogger.LOG.warning("No connection: " + se.getMessage());
            return se.getMessage();
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("No connection: " + ioe.getMessage());
            return ioe.getMessage();
        }
    }
}

