/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.dcr.LocalDCSPanel;

public class AnnotationDCPanel
extends LocalDCSPanel {
    protected JPanel dcrPanel;
    protected JLabel dcrLabel;
    protected JTextField dcrField;
    protected JTextField dcIdField;
    protected JButton dcrButton;
    private String annotationLabel;

    public AnnotationDCPanel(ILATDCRConnector connector) {
        super(connector);
    }

    public AnnotationDCPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
    }

    public AnnotationDCPanel(ILATDCRConnector connector, ResourceBundle resBundle, String annotationLabel) {
        super(connector, resBundle);
        this.annotationLabel = annotationLabel;
        this.updateLocale();
    }

    public void setAnnotationDCId(String dcId) {
        this.dcIdField.setText(dcId);
        DCSmall sm = ELANLocalDCRConnector.getInstance().getDCSmall(dcId);
        if (sm != null) {
            this.dcrField.setText(sm.getIdentifier());
        }
    }

    public String getAnnotationDCId() {
        if (this.dcIdField.getText() != null && this.dcIdField.getText().length() > 0) {
            return this.dcIdField.getText();
        }
        return null;
    }

    protected void initComponents() {
        this.dcrPanel = new JPanel(new GridBagLayout());
        this.dcrLabel = new JLabel();
        this.dcrField = new JTextField();
        this.dcIdField = new JTextField();
        this.dcIdField.setEditable(false);
        this.dcrField.setEditable(false);
        this.dcrButton = new JButton();
        super.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.dcrPanel.add((Component)this.dcrLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.dcrPanel.add((Component)this.dcrField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        this.dcrPanel.add((Component)this.dcIdField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.dcrPanel.add((Component)this.dcrButton, gridBagConstraints);
        this.remove(this.catPanel);
        this.remove(this.profPanel);
        this.remove(this.descPanel);
        Insets insets = new Insets(2, 6, 2, 6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.dcrPanel, gridBagConstraints);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        this.add((Component)this.profPanel, gbc);
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        this.add((Component)this.catPanel, gbc);
        gbc.gridx = 2;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.descPanel, gbc);
        this.dcrButton.addActionListener(this);
    }

    protected void updateLocale() {
        super.updateLocale();
        this.dcrPanel.setBorder(new TitledBorder(ElanLocale.getString("DCR.Label.ISOCategory")));
        if (this.annotationLabel != null) {
            this.dcrLabel.setText(this.annotationLabel);
        }
        this.dcrButton.setText(ElanLocale.getString("Button.Delete"));
    }

    protected void updateDescription(DCSmall dc) {
        super.updateDescription(dc);
        if (dc != null) {
            this.dcrField.setText(dc.getIdentifier());
            this.dcIdField.setText(dc.getId());
        } else {
            this.dcIdField.setText("");
            this.dcrField.setText("");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dcrButton) {
            this.dcIdField.setText("");
            this.dcrField.setText("");
            return;
        }
        super.actionPerformed(e);
    }
}

