/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DCRCacheReaderWriter {
    private final String struct = "struct";
    private final String feat = "feat";
    private final String dcs = "DCS";
    private final String dc = "DC";
    private final String ai = "AI";
    private final String ar = "AR";
    private final String desc = "Desc";
    private final String def = "definition";
    private final String ident = "identifier";
    private final String prof = "profile";
    private final String broad = "broaderConceptGeneric";
    private final String type = "type";
    private final String id = "id";
    private final String name = "name";
    private final String urlPref = "http://www.isocat.org/datcat/DC-";
    private DocumentBuilder db;
    private XMLReader reader;
    private String filePath;
    private boolean profileIdsNeeded = false;

    public DCRCacheReaderWriter() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.db = dbf.newDocumentBuilder();
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", false);
            this.reader.setFeature("http://apache.org/xml/features/validation/schema", false);
            this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        }
        catch (SAXException se) {
            ClientLogger.LOG.warning("Could not create a parser for the DCR cache: " + se.getMessage());
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public synchronized void save(List categories) throws IOException, ParserConfigurationException {
        if (this.filePath == null) {
            throw new IOException("No filepath specified.");
        }
        if (categories == null) {
            throw new NullPointerException("The list of categories is null");
        }
        if (this.db != null) {
            Document doc = this.db.newDocument();
            Element dcsElem = doc.createElement("struct");
            doc.appendChild(dcsElem);
            dcsElem.setAttribute("type", "DCS");
            DCSmall dcsmall = null;
            for (int i = 0; i < categories.size(); ++i) {
                dcsmall = (DCSmall)categories.get(i);
                Element dcEl = doc.createElement("struct");
                dcEl.setAttribute("type", "DC");
                dcEl.setAttribute("id", dcsmall.getId());
                dcsElem.appendChild(dcEl);
                if (dcsmall.getIdentifier() != null && dcsmall.getIdentifier().length() > 0) {
                    Element aiEl = doc.createElement("struct");
                    aiEl.setAttribute("type", "AI");
                    dcEl.appendChild(aiEl);
                    Element arEl = doc.createElement("struct");
                    arEl.setAttribute("type", "AR");
                    aiEl.appendChild(arEl);
                    Element idEl = doc.createElement("feat");
                    idEl.setAttribute("type", "identifier");
                    idEl.appendChild(doc.createTextNode(dcsmall.getIdentifier()));
                    arEl.appendChild(idEl);
                }
                Element descEl = doc.createElement("struct");
                descEl.setAttribute("type", "Desc");
                dcEl.appendChild(descEl);
                if (dcsmall.getDesc() != null && dcsmall.getDesc().length() > 0) {
                    Element defEl = doc.createElement("feat");
                    defEl.setAttribute("type", "definition");
                    defEl.appendChild(doc.createTextNode(dcsmall.getDesc()));
                    descEl.appendChild(defEl);
                }
                if (dcsmall.getProfiles() != null && dcsmall.getProfiles().length > 0) {
                    for (int j = 0; j < dcsmall.getProfiles().length; ++j) {
                        if (dcsmall.getProfiles()[j].getName().length() == 0) continue;
                        Element prEl = doc.createElement("struct");
                        prEl.setAttribute("type", "profile");
                        prEl.setAttribute("id", dcsmall.getProfiles()[j].getId());
                        Element nameEl = doc.createElement("feat");
                        nameEl.setAttribute("type", "name");
                        nameEl.appendChild(doc.createTextNode(dcsmall.getProfiles()[j].getName()));
                        prEl.appendChild(nameEl);
                        descEl.appendChild(prEl);
                    }
                }
                if (dcsmall.getBroaderDCId() == null || dcsmall.getBroaderDCId().length() <= 0) continue;
                Element brEl = doc.createElement("feat");
                brEl.setAttribute("type", "broaderConceptGeneric");
                brEl.appendChild(doc.createTextNode(dcsmall.getBroaderDCId()));
                descEl.appendChild(brEl);
            }
            try {
                IoUtil.writeEncodedFile("UTF-8", this.filePath, doc.getDocumentElement());
            }
            catch (Exception ioe) {
                throw new IOException(ioe.getMessage());
            }
        }
    }

    public synchronized List read() throws IOException {
        if (this.reader != null) {
            try {
                DcrGmtAdapter adapter = new DcrGmtAdapter();
                this.reader.setContentHandler(adapter);
                this.reader.parse(this.filePath);
                List curDCList = adapter.getDCS();
                if (this.profileIdsNeeded) {
                    try {
                        RestDCRConnector rconn = new RestDCRConnector();
                        List<Profile> profs = rconn.getProfiles();
                        for (int i = 0; i < curDCList.size(); ++i) {
                            DCSmall small1 = (DCSmall)curDCList.get(i);
                            Profile[] curProfs = small1.getProfiles();
                            block5: for (int j = 0; j < curProfs.length; ++j) {
                                if (curProfs[j].getId().length() != 0) continue;
                                for (int k = 0; k < profs.size(); ++k) {
                                    Profile pr = profs.get(k);
                                    if (!pr.getName().equals(curProfs[j].getName())) continue;
                                    curProfs[j].setId(pr.getId());
                                    continue block5;
                                }
                            }
                        }
                    }
                    catch (DCRConnectorException dce) {
                        ClientLogger.LOG.warning("Could not retrieve additional information from ISOCat");
                    }
                }
                return curDCList;
            }
            catch (SAXException se) {
                ClientLogger.LOG.warning("Could not read the local data categories cache: " + se.getMessage());
            }
        }
        return new ArrayList();
    }

    private class DcrGmtAdapter
    extends DefaultHandler {
        private List<DCSmall> datcats = new ArrayList<DCSmall>();
        private String idAttr;
        private String identifierAttr;
        private String descAttr;
        private DCSmall dcsmall;
        private String broaderDCIdAttr;
        private List<Profile> profiles = new ArrayList<Profile>();
        private String curProfId;
        private String curStruct;
        private String curFeat;
        private String content = "";
        private int structLevel = 0;
        boolean in = false;

        public List getDCS() {
            return this.datcats;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.in) {
                this.content = new String(ch, start, length);
                if (this.curFeat == "identifier") {
                    this.identifierAttr = this.content;
                } else if (this.curFeat == "definition") {
                    this.descAttr = this.content;
                } else if (this.curFeat == "broaderConceptGeneric") {
                    this.broaderDCIdAttr = this.content;
                } else if (this.curFeat == "profile") {
                    this.profiles.add(new Profile("", this.content));
                } else if (this.curFeat == "name") {
                    this.profiles.add(new Profile(this.curProfId, this.content));
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.in = false;
            if (localName.equals("struct")) {
                --this.structLevel;
            }
            if (this.structLevel == 1 && this.idAttr != null && this.profiles.size() > 0) {
                this.dcsmall = new DCSmall(null, this.idAttr, this.identifierAttr);
                this.dcsmall.setBroaderDCId(this.broaderDCIdAttr);
                this.dcsmall.setProfiles(this.profiles.toArray(new Profile[0]));
                this.dcsmall.setDesc(this.descAttr);
                this.dcsmall.setLoaded(true);
                this.datcats.add(this.dcsmall);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("struct")) {
                ++this.structLevel;
                String ty = atts.getValue("type");
                if ("DC".equals(ty)) {
                    this.curStruct = "DC";
                    this.idAttr = atts.getValue("id");
                    if (this.idAttr.length() > 0) {
                        try {
                            Integer.parseInt(this.idAttr);
                            this.idAttr = "http://www.isocat.org/datcat/DC-" + this.idAttr;
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                    this.identifierAttr = null;
                    this.descAttr = null;
                    this.broaderDCIdAttr = null;
                    this.profiles.clear();
                    this.content = "";
                } else if ("AR".equals(ty)) {
                    this.curStruct = "AR";
                } else if ("Desc".equals(ty)) {
                    this.curStruct = "Desc";
                } else if ("profile".equals(ty)) {
                    this.curStruct = "profile";
                    this.curProfId = atts.getValue("id");
                }
            } else if (localName.equals("feat")) {
                this.in = true;
                String fty = atts.getValue("type");
                if ("identifier".equals(fty)) {
                    this.curFeat = "identifier";
                } else if ("definition".equals(fty)) {
                    this.curFeat = "definition";
                } else if ("profile".equals(fty)) {
                    this.curFeat = "profile";
                    DCRCacheReaderWriter.this.profileIdsNeeded = true;
                } else if ("broaderConceptGeneric".equals(fty)) {
                    this.curFeat = "broaderConceptGeneric";
                } else if ("name".equals(fty)) {
                    this.curFeat = "name";
                }
            }
        }
    }
}

