/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.dcr.AbstractDCSelectPanel;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.RemoteDCSelectPanel;
import mpi.dcr.isocat.RestDCRConnector;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.dcr.LocalDCSPanel;
import mpi.eudico.client.annotator.gui.ClosableDialog;

public class ELANDCRDialog
extends ClosableDialog
implements ActionListener {
    public static final int LOCAL_MODE = 1;
    public static final int REMOTE_MODE = 2;
    private int mode = 1;
    protected ResourceBundle bundle = null;
    protected String dcrName;
    protected String dcrLocation;
    protected JPanel titlePanel;
    protected JLabel titleLabel;
    protected JLabel subtitleLabel;
    protected JLabel subtitleLabel2;
    protected AbstractDCSelectPanel dcPanel;
    protected JPanel buttonPanel;
    protected JButton applyButton;
    protected JButton cancelButton;
    private Object value = null;

    public ELANDCRDialog(Frame owner, boolean modal, int mode) throws HeadlessException {
        super(owner, modal);
        if (mode == 2) {
            this.mode = mode;
        }
        this.initComponents();
    }

    public ELANDCRDialog(Dialog owner, boolean modal, int mode) throws HeadlessException {
        super(owner, modal);
        if (mode == 2) {
            this.mode = mode;
        }
        this.initComponents();
    }

    protected void initComponents() {
        this.bundle = ElanLocale.getResourceBundle();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel = new JPanel(new GridBagLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.subtitleLabel = new JLabel();
        this.subtitleLabel.setFont(Constants.SMALLFONT);
        this.subtitleLabel.setHorizontalAlignment(0);
        this.subtitleLabel2 = new JLabel();
        this.subtitleLabel2.setFont(Constants.SMALLFONT);
        this.subtitleLabel2.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.titlePanel.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = insets;
        this.titlePanel.add((Component)this.subtitleLabel, gbc);
        gbc.gridy = 2;
        this.titlePanel.add((Component)this.subtitleLabel2, gbc);
        gbc.gridy = 0;
        this.getContentPane().add((Component)this.titlePanel, gbc);
        if (this.mode == 2) {
            RestDCRConnector conn = new RestDCRConnector();
            this.dcrName = conn.getName();
            this.dcrLocation = conn.getDCRLocation();
            this.dcPanel = new RemoteDCSelectPanel((ILATDCRConnector)conn, this.bundle);
        } else {
            this.dcPanel = new LocalDCSPanel(ELANLocalDCRConnector.getInstance(), this.bundle);
        }
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.dcPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.applyButton = new JButton();
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
    }

    protected void updateLocale() {
        if (this.mode == 2) {
            this.titleLabel.setText(ElanLocale.getString("DCR.Label.Remote") + " " + this.dcrName);
            this.subtitleLabel.setText("(" + this.dcrLocation + ")");
            this.subtitleLabel2.setText(ElanLocale.getString("DCR.Label.RemoteHelp"));
        } else {
            this.titleLabel.setText(ElanLocale.getString("DCR.Label.LocalDCS"));
            this.subtitleLabel2.setText(ElanLocale.getString("DCR.Label.LocalDCSHelp"));
        }
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    public Object getValue() {
        return this.value;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.value = this.dcPanel.getSelectedCategories();
        } else if (e.getSource() == this.cancelButton) {
            this.value = null;
        }
        this.setVisible(false);
        this.dispose();
    }
}

