/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileAndEncodingChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;

public abstract class AbstractBasicExportDialog
extends ClosableDialog
implements ActionListener,
ClientLogger {
    public static final String LAST_USED_EXPORT_DIR = "LastUsedExportDir";
    protected final Insets insets = new Insets(4, 6, 4, 6);
    protected final JLabel titleLabel = new JLabel();
    protected final JPanel buttonPanel = new JPanel();
    protected final JPanel optionsPanel = new JPanel();
    protected final String defaultEncoding = "UTF-8";
    protected final Transcription transcription;
    protected String encoding = "UTF-8";
    private final JButton closeButton = new JButton();
    private final JButton startButton = new JButton();
    private final int minimalHeight = 400;
    private final int minimalWidth = 550;

    public AbstractBasicExportDialog(Frame parent, boolean modal, Transcription transcription) {
        super(parent, modal);
        this.transcription = transcription;
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            try {
                boolean success = this.startExport();
                if (success) {
                    this.closeDialog(null);
                }
            }
            catch (Exception ee) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n" + "(" + ee.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
                ee.printStackTrace();
            }
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        }
    }

    protected abstract boolean startExport() throws IOException;

    protected void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    protected void makeLayout() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AbstractBasicExportDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
    }

    protected void postInit() {
        this.pack();
        this.setSize(this.getSize().width < 550 ? 550 : this.getSize().width, this.getSize().height < 400 ? 400 : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    protected File promptForFile(String chooserTitle, String[] extensions, FileFilter filter, boolean showEncodingBox, String[] encodings) {
        JFileChooser chooser = null;
        if (showEncodingBox) {
            chooser = new FileAndEncodingChooser();
            if (encodings != null) {
                ((FileAndEncodingChooser)chooser).setEncodings(encodings);
                for (int i = encodings.length - 1; i >= 0; --i) {
                    if ("UTF-8".equals(encodings[i])) {
                        ((FileAndEncodingChooser)chooser).setSelectedEncoding(encodings[i]);
                        break;
                    }
                    if (i != 0) continue;
                    ((FileAndEncodingChooser)chooser).setSelectedEncoding(encodings[0]);
                }
            } else {
                ((FileAndEncodingChooser)chooser).setSelectedEncoding("UTF-8");
            }
        } else {
            chooser = new JFileChooser();
        }
        if (this.transcription != null) {
            chooser.setSelectedFile(AbstractBasicExportDialog.getDefaultExportFile(this.transcription.getFullPath(), extensions[0]));
        } else {
            chooser.setSelectedFile(AbstractBasicExportDialog.getDefaultExportFile(null, extensions[0]));
        }
        chooser.setDialogTitle(chooserTitle);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(this) == 0) {
            int answer;
            AbstractBasicExportDialog.setDefaultExportDir(chooser.getCurrentDirectory());
            File exportFile = chooser.getSelectedFile();
            if (showEncodingBox) {
                this.encoding = ((FileAndEncodingChooser)chooser).getSelectedEncoding();
            }
            String name = exportFile.getAbsolutePath();
            String lowerPathName = name.toLowerCase();
            boolean validExt = false;
            for (int i = 0; i < extensions.length; ++i) {
                if (!lowerPathName.endsWith("." + extensions[i].toLowerCase())) continue;
                validExt = true;
                break;
            }
            if (!validExt) {
                name = name + "." + extensions[0];
                exportFile = new File(name);
            }
            if (exportFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                return this.promptForFile(chooserTitle, extensions, filter, showEncodingBox);
            }
            return exportFile;
        }
        return null;
    }

    protected File promptForFile(String chooserTitle, String[] extensions, FileFilter filter, boolean showEncodingBox) {
        return this.promptForFile(chooserTitle, extensions, filter, showEncodingBox, null);
    }

    protected void updateLocale() {
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private static void setDefaultExportDir(File directory) {
        if (directory != null) {
            Preferences.set(LAST_USED_EXPORT_DIR, directory.getAbsolutePath(), null);
        }
    }

    private static File getDefaultExportFile(String transcriptionPath, String extension) {
        String exportDir = (String)Preferences.get(LAST_USED_EXPORT_DIR, null);
        File file = null;
        if (transcriptionPath != null) {
            file = new File(transcriptionPath);
        }
        if (exportDir == null && file != null) {
            exportDir = file.getParent();
        }
        if (exportDir == null) {
            exportDir = System.getProperty("user.dir");
        }
        int index = -1;
        if (file != null) {
            index = file.getName().lastIndexOf(46);
        }
        String exportFileName = index > -1 ? file.getName().substring(0, index) : ElanLocale.getString("Frame.ElanFrame.Untitled");
        return new File(exportDir, exportFileName + "." + extension);
    }
}

