/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.gui.TextExportFileChooser;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class ExportGridTable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTableAsTabDelimitedText(AnnotationTable table) {
        if (table == null) {
            return;
        }
        String encoding = "UTF-8";
        String exportDir = (String)Preferences.get("LastUsedExportDir", null);
        if (exportDir == null) {
            exportDir = System.getProperty("user.dir");
        }
        TextExportFileChooser chooser = new TextExportFileChooser();
        chooser.setCurrentDirectory(new File(exportDir));
        chooser.setDialogTitle(ElanLocale.getString("ExportTabDialog.Title"));
        File exportFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(11);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(null, null) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedExportDir", curDir.getAbsolutePath(), null);
            }
            if ((exportFile = chooser.getSelectedFile()) != null) {
                int answer;
                encoding = chooser.getSelectedEncoding();
                String name = exportFile.getAbsolutePath();
                String lowerPathName = name.toLowerCase();
                String[] exts = FileExtension.TEXT_EXT;
                boolean validExt = false;
                for (int i = 0; i < exts.length; ++i) {
                    if (!lowerPathName.endsWith("." + exts[i])) continue;
                    validExt = true;
                    break;
                }
                if (!validExt) {
                    name = name + "." + exts[0];
                    exportFile = new File(name);
                }
                if (exportFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                    this.exportTableAsTabDelimitedText(table);
                }
            }
        } else {
            return;
        }
        BufferedWriter writer = null;
        GridViewerTableModel dataModel = null;
        boolean filtering = false;
        try {
            int i;
            FileOutputStream out = new FileOutputStream(exportFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            dataModel = (GridViewerTableModel)table.getModel();
            filtering = dataModel.isFiltering();
            dataModel.setFiltering(false);
            ArrayList<String> visColumns = new ArrayList<String>();
            boolean tierNameColumnPresent = false;
            for (int i2 = 0; i2 < dataModel.getColumnCount(); ++i2) {
                String columnName = dataModel.getColumnName(i2);
                if (!table.isColumnVisible(columnName)) continue;
                visColumns.add(columnName);
                if (!columnName.equals("ColumnTierName")) continue;
                tierNameColumnPresent = true;
            }
            String tierName = "";
            if (!tierNameColumnPresent && dataModel.getRowCount() > 0) {
                for (int i3 = 0; i3 < dataModel.getColumnCount(); ++i3) {
                    Object o;
                    if (!visColumns.contains(dataModel.getColumnName(i3)) || !((o = dataModel.getValueAt(0, i3)) instanceof Annotation)) continue;
                    tierName = ((Annotation)o).getTier().getName();
                    break;
                }
            }
            for (i = 1; i < dataModel.getColumnCount(); ++i) {
                if (!visColumns.contains(dataModel.getColumnName(i))) continue;
                String header = (String)table.getColumnModel().getColumn(i).getHeaderValue();
                if (!tierNameColumnPresent && dataModel.getColumnName(i).equals("ColumnAnnotation") && tierName.length() > 0) {
                    header = tierName;
                }
                writer.write(header + "\t");
            }
            writer.write("\n");
            for (i = 0; i < dataModel.getRowCount(); ++i) {
                for (int j = 1; j < dataModel.getColumnCount(); ++j) {
                    if (!visColumns.contains(dataModel.getColumnName(j))) continue;
                    Object o = dataModel.getValueAt(i, j);
                    if (o instanceof Annotation) {
                        writer.write(((Annotation)o).getValue().replace('\n', ' '));
                    } else if (o instanceof AnnotationCore) {
                        writer.write(((AnnotationCore)o).getValue().replace('\n', ' '));
                    } else if (o != null) {
                        writer.write(o.toString());
                    } else {
                        writer.write("");
                    }
                    writer.write("\t");
                }
                writer.write("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(table, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Warning"), 2);
        }
        finally {
            if (dataModel != null) {
                dataModel.setFiltering(filtering);
            }
            try {
                writer.close();
            }
            catch (Exception ee) {}
        }
    }
}

