/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTGEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTextGridEncoder;

public class ExportPraatDialog
extends AbstractExtTierExportDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    private JCheckBox rootTiersCB;
    private JCheckBox selectionCB;
    private JCheckBox correctTimesCB;
    private List tierOrderList = null;

    public ExportPraatDialog(Frame parent, boolean modal, Transcription transcription, Selection selection, List tierOrderList) {
        super(parent, modal, transcription, selection);
        if (selection != null) {
            System.out.println("sb: " + selection.getBeginTime() + " se: " + selection.getEndTime());
        }
        if (tierOrderList != null) {
            this.tierOrderList = tierOrderList;
        }
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
    }

    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            Object useTyp;
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                TierImpl t;
                Object useTyp2;
                boolean rootsOnly = this.rootTiersCB.isSelected();
                this.tierOrderList = rootsOnly ? ((useTyp2 = Preferences.get("ExportPraatDialog.ParentTierOrder", this.transcription)) instanceof ArrayList ? (List)useTyp2 : null) : ((useTyp2 = Preferences.get("ExportPraatDialog.TierOrder", this.transcription)) instanceof ArrayList ? (List)useTyp2 : null);
                if (this.tierOrderList == null) {
                    List tierOrder = ELANCommandFactory.getViewerManager(this.transcription).getTierOrder().getTierOrder();
                    if (tierOrder != null && tierOrder.size() > 0) {
                        this.tierOrderList = new ArrayList();
                        for (int i = 0; i < tierOrder.size(); ++i) {
                            t = (TierImpl)this.transcription.getTierWithId(tierOrder.get(i).toString());
                            if (t == null) continue;
                            this.tierOrderList.add(t);
                        }
                    } else {
                        this.tierOrderList = this.transcription.getTiers();
                    }
                }
                t = null;
                for (int i = 0; i < this.tierOrderList.size(); ++i) {
                    if (this.tierOrderList.get(i) instanceof String) {
                        String tierName = (String)this.tierOrderList.get(i);
                        t = (TierImpl)this.transcription.getTierWithId(tierName);
                    } else if (this.tierOrderList.get(i) instanceof TierImpl) {
                        t = (TierImpl)this.tierOrderList.get(i);
                    }
                    if (t == null) continue;
                    if (rootsOnly) {
                        if (t.getParentTier() != null) continue;
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    if (t.getParentTier() == null) {
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
                }
            }
            if ((useTyp = Preferences.get("ExportPraatDialog.selectedTiers", this.transcription)) instanceof ArrayList) {
                this.loadTierPreferences((ArrayList)useTyp);
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.rootTiersCB = new JCheckBox();
        this.selectionCB = new JCheckBox();
        this.correctTimesCB = new JCheckBox();
        this.rootTiersCB.setSelected(true);
        this.rootTiersCB.addItemListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.tierSelectionPanel.add((Component)this.rootTiersCB, gridBagConstraints);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected boolean startExport() throws IOException {
        Vector mds;
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String[] encodings = new String[]{ElanLocale.getString("Button.Default"), "UTF-8", "UTF-16"};
        File exportFile = this.promptForFile(ElanLocale.getString("ExportPraatDialog.Title"), FileExtension.PRAAT_TEXTGRID_EXT, ElanFileFilter.createFileFilter(18), true, encodings);
        if (exportFile == null) {
            return false;
        }
        long begin = 0L;
        long end = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        boolean exportSelection = false;
        if (this.selectionCB.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
            exportSelection = true;
        }
        long mediaOffset = 0L;
        if (this.correctTimesCB.isSelected() && (mds = this.transcription.getMediaDescriptors()) != null && mds.size() > 0) {
            mediaOffset = ((MediaDescriptor)mds.get((int)0)).timeOrigin;
        }
        PraatTGEncoderInfo encInfo = new PraatTGEncoderInfo(begin, end);
        encInfo.setEncoding(this.encoding);
        encInfo.setOffset(mediaOffset);
        encInfo.setExportSelection(exportSelection);
        PraatTextGridEncoder encoder = new PraatTextGridEncoder();
        encoder.encodeAndSave(this.transcription, encInfo, selectedTiers, exportFile.getAbsolutePath());
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportPraatDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportPraatDialog.Title"));
        this.rootTiersCB.setText(ElanLocale.getString("ExportTradTranscript.Label.RootTiers"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
    }

    private void setPreferredSetting() {
        Object correctObj;
        Object useTyp = Preferences.get("ExportPraatDialog.rootTiersCB", null);
        if (useTyp != null) {
            this.rootTiersCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportPraatDialog.selectionCB", null)) != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
        if ((correctObj = Preferences.get("ExportPraatDialog.correctTimesCB", null)) instanceof Boolean) {
            this.correctTimesCB.setSelected((Boolean)correctObj);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportPraatDialog.rootTiersCB", this.rootTiersCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.selectionCB", this.selectionCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
        boolean orderChanged = false;
        ArrayList<String> newOrderList = new ArrayList<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String tierName = (String)this.model.getValueAt(i, 1);
            if (this.tierOrderList.get(i) instanceof String) {
                if (!tierName.equals((String)this.tierOrderList.get(i))) {
                    orderChanged = true;
                }
            } else if (this.tierOrderList.get(i) instanceof TierImpl && !tierName.equals(((TierImpl)this.tierOrderList.get(i)).getName())) {
                orderChanged = true;
            }
            newOrderList.add(tierName);
        }
        if (orderChanged) {
            if (this.rootTiersCB.isSelected()) {
                Preferences.set("ExportPraatDialog.ParentTierOrder", newOrderList, this.transcription);
            } else {
                Preferences.set("ExportPraatDialog.TierOrder", newOrderList, this.transcription);
            }
        }
    }
}

