/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.transform.TransformerException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.DisplaySettingsPane;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.EAF2SMIL;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportSmilDialog
extends AbstractExtTierExportDialog
implements ListSelectionListener,
ChangeListener {
    private JCheckBox minimalDurCB;
    private JTextField minimalDurTF;
    private JCheckBox correctTimesCB;
    private JCheckBox recalculateTimesCB;
    private JButton fontSettingsButton;
    private HashMap fontSettingHashMap;
    private List tierOrder;

    public ExportSmilDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    protected void makeLayout() {
        super.makeLayout();
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        this.recalculateTimesCB = new JCheckBox();
        this.recalculateTimesCB.setEnabled(false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.recalculateTimesCB, gridBagConstraints);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.minimalDurCB = new JCheckBox();
        this.minimalDurCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurCB, gridBagConstraints);
        this.minimalDurTF = new JTextField(6);
        this.minimalDurTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurTF, gridBagConstraints);
        this.fontSettingsButton = new JButton();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.fontSettingsButton, gridBagConstraints);
        this.fontSettingsButton.addActionListener(this);
        this.restrictCheckBox.addChangeListener(this);
        this.minimalDurCB.addChangeListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected void extractTiers() {
        if (this.model != null) {
            int i;
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                this.tierOrder = this.getTierOrder((List)Preferences.get("ExportSmilDialog.TierOrder", this.transcription));
                for (i = 0; i < this.tierOrder.size(); ++i) {
                    if (i == 0) {
                        this.model.addRow(new Object[]{Boolean.TRUE, (String)this.tierOrder.get(i)});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, (String)this.tierOrder.get(i)});
                }
                Object useTyp = Preferences.get("ExportSmilDialog.selectedTiers", this.transcription);
                if (useTyp instanceof ArrayList) {
                    this.loadTierPreferences((ArrayList)useTyp);
                }
            }
        }
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportSmilDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportSmilDialog.TitleLabel"));
        this.fontSettingsButton.setText(ElanLocale.getString("ExportQtSubtitleDialog.Button.FontSetting"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.minimalDurCB.setText(ElanLocale.getString("ExportDialog.Label.MinimalDur"));
        this.recalculateTimesCB.setText(ElanLocale.getString("ExportDialog.RecalculateTimes"));
    }

    protected boolean startExport() throws IOException {
        Vector mediaDescriptors;
        File exportFile;
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int minimalDur = 0;
        if (this.minimalDurCB.isSelected()) {
            String dur = this.minimalDurTF.getText();
            if (dur == null || dur.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
            try {
                minimalDur = Integer.parseInt(dur);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("Export.TigerDialog.title"), FileExtension.SMIL_EXT, ElanFileFilter.createFileFilter(13), false)) == null) {
            return false;
        }
        long offset = 0L;
        if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
            offset = ((MediaDescriptor)mediaDescriptors.get((int)0)).timeOrigin;
        }
        String[] tierNames = selectedTiers.toArray(new String[0]);
        String mediaURL = "";
        if (((TranscriptionImpl)this.transcription).getMediaDescriptors().size() > 0) {
            mediaURL = ((MediaDescriptor)((TranscriptionImpl)this.transcription).getMediaDescriptors().get((int)0)).mediaURL;
        }
        try {
            if (this.selection != null && this.restrictCheckBox.isSelected()) {
                EAF2SMIL.export2SMIL(this.transcription, exportFile, tierNames, mediaURL, this.selection.getBeginTime(), this.selection.getEndTime(), offset, minimalDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
            } else {
                EAF2SMIL.export2SMIL(new File(((TranscriptionImpl)this.transcription).getPathName()), exportFile, tierNames, mediaURL, offset, minimalDur, this.fontSettingHashMap);
            }
        }
        catch (TransformerException te) {
            throw new IOException("TransformerException: " + te.getMessage());
        }
        return true;
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.minimalDurCB) {
            this.minimalDurTF.setEnabled(this.minimalDurCB.isSelected());
        } else if (e.getSource() == this.restrictCheckBox) {
            this.recalculateTimesCB.setEnabled(this.restrictCheckBox.isSelected());
        }
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (ae.getSource() == this.fontSettingsButton) {
            this.setName("realPlayer");
            this.setNewFontSetting(DisplaySettingsPane.getNewFontSetting(this, ElanLocale.getString("DisplaySettingsPane.Title")));
        }
    }

    private void setNewFontSetting(HashMap newSetting) {
        if (newSetting != null) {
            this.fontSettingHashMap = new HashMap();
            this.fontSettingHashMap = newSetting;
        }
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportSmilDialog.restrictCheckBox", null);
        if (useTyp != null) {
            this.restrictCheckBox.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSmilDialog.minimalDurCB", null)) != null) {
            this.minimalDurCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSmilDialog.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSmilDialog.minimalDurTF", null)) != null) {
            this.minimalDurTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportSmilDialog.recalculateTimesCB", null)) != null) {
            this.recalculateTimesCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportSmilDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportSmilDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
        Preferences.set("ExportSmilDialog.minimalDurCB", this.minimalDurCB.isSelected(), null);
        Preferences.set("ExportSmilDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportSmilDialog.recalculateTimesCB", this.recalculateTimesCB.isSelected(), null);
        if (this.minimalDurTF.getText() != null) {
            Preferences.set("ExportSmilDialog.minimalDurTF", this.minimalDurTF.getText(), null);
        }
        List prefferedTierOrder = this.getCurrentTierOrder();
        for (int i = 0; i < prefferedTierOrder.size(); ++i) {
            if (prefferedTierOrder.get(i) == this.tierOrder.get(i)) continue;
            Preferences.set("ExportSmilDialog.TierOrder", prefferedTierOrder, this.transcription);
            break;
        }
    }
}

