/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.Transcription2SubtitleText;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class ExportSubtitleDialog
extends AbstractExtTierExportDialog
implements ListSelectionListener,
ChangeListener {
    private JCheckBox minimalDurCB;
    private JTextField minimalDurTF;
    private JCheckBox correctTimesCB;
    private JCheckBox recalculateTimesCB;
    private JCheckBox overrideFrameRateCB;
    private JRadioButton ntscDFTimecodeRB;
    private JRadioButton ntscNDFTimecodeRB;
    private JRadioButton palTimecodeRB;
    private List tierOrder;

    public ExportSubtitleDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    protected void extractTiers() {
        if (this.model != null) {
            int i;
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                Object useTyp;
                this.tierOrder = this.getTierOrder((List)Preferences.get("ExportSubtitleDialog.TierOrder", this.transcription));
                for (i = 0; i < this.tierOrder.size(); ++i) {
                    if (i == 0) {
                        this.model.addRow(new Object[]{Boolean.TRUE, (String)this.tierOrder.get(i)});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, (String)this.tierOrder.get(i)});
                }
                if (this.model.getRowCount() > 0) {
                    this.tierTable.setRowSelectionInterval(0, 0);
                }
                if ((useTyp = Preferences.get("ExportSubtitleDialog.selectedTiers", this.transcription)) instanceof ArrayList) {
                    this.loadTierPreferences((ArrayList)useTyp);
                }
            }
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        this.recalculateTimesCB = new JCheckBox();
        this.recalculateTimesCB.setEnabled(true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.recalculateTimesCB, gridBagConstraints);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.minimalDurCB = new JCheckBox();
        this.minimalDurCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurCB, gridBagConstraints);
        this.minimalDurTF = new JTextField(6);
        this.minimalDurTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurTF, gridBagConstraints);
        this.overrideFrameRateCB = new JCheckBox();
        this.overrideFrameRateCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.overrideFrameRateCB, gridBagConstraints);
        JPanel timeCodePanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)timeCodePanel, gridBagConstraints);
        this.palTimecodeRB = new JRadioButton();
        this.palTimecodeRB.setEnabled(false);
        this.palTimecodeRB.setSelected(true);
        this.ntscDFTimecodeRB = new JRadioButton();
        this.ntscDFTimecodeRB.setEnabled(false);
        this.ntscNDFTimecodeRB = new JRadioButton();
        this.ntscNDFTimecodeRB.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.palTimecodeRB);
        group.add(this.ntscDFTimecodeRB);
        group.add(this.ntscNDFTimecodeRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        timeCodePanel.add((Component)this.palTimecodeRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        timeCodePanel.add((Component)this.ntscDFTimecodeRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        timeCodePanel.add((Component)this.ntscNDFTimecodeRB, gridBagConstraints);
        this.minimalDurCB.addChangeListener(this);
        this.restrictCheckBox.addChangeListener(this);
        this.overrideFrameRateCB.addChangeListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected boolean startExport() throws IOException {
        File exportFile;
        Vector mediaDescriptors;
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int minimalDur = 0;
        if (this.minimalDurCB.isSelected()) {
            String dur = this.minimalDurTF.getText();
            if (dur == null || dur.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
            try {
                minimalDur = Integer.parseInt(dur);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
        }
        long offset = 0L;
        if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
            offset = ((MediaDescriptor)mediaDescriptors.get((int)0)).timeOrigin;
        }
        double frameRate = -1.0;
        if (this.overrideFrameRateCB.isSelected()) {
            if (this.palTimecodeRB.isSelected()) {
                frameRate = 25.0;
            } else if (this.ntscDFTimecodeRB.isSelected()) {
                frameRate = 29.97;
            } else if (this.ntscNDFTimecodeRB.isSelected()) {
                frameRate = 30.0;
            }
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.Subtitles.Title"), FileExtension.SUBTITLE_EXT, ElanFileFilter.createFileFilter(21), true)) == null) {
            return false;
        }
        Transcription2SubtitleText exporter = new Transcription2SubtitleText();
        String[] tierNames = selectedTiers.toArray(new String[0]);
        long b = 0L;
        long e = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            b = this.selection.getBeginTime();
            e = this.selection.getEndTime();
        }
        if (exportFile.getName().toLowerCase().endsWith(".stl")) {
            exporter.exportTiersSTL(this.transcription, tierNames, exportFile, this.encoding, b, e, minimalDur, offset, frameRate, this.recalculateTimesCB.isSelected());
        } else {
            exporter.exportTiersSRT(this.transcription, tierNames, exportFile, this.encoding, b, e, minimalDur, offset, this.recalculateTimesCB.isSelected());
        }
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportDialog.Subtitles.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.Subtitles.Title"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.recalculateTimesCB.setText(ElanLocale.getString("ExportDialog.RecalculateTimes"));
        this.minimalDurCB.setText(ElanLocale.getString("ExportDialog.Label.MinimalDur"));
        this.overrideFrameRateCB.setText(ElanLocale.getString("ExportDialog.OverrideTC"));
        this.palTimecodeRB.setText(ElanLocale.getString("ExportDialog.OverrideTC.PAL"));
        this.ntscDFTimecodeRB.setText(ElanLocale.getString("ExportDialog.OverrideTC.NTSCDF"));
        this.ntscNDFTimecodeRB.setText(ElanLocale.getString("ExportDialog.OverrideTC.NTSCNDF"));
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.minimalDurCB) {
            this.minimalDurTF.setEnabled(this.minimalDurCB.isSelected());
        } else if (e.getSource() == this.overrideFrameRateCB) {
            this.ntscDFTimecodeRB.setEnabled(this.overrideFrameRateCB.isSelected());
            this.ntscNDFTimecodeRB.setEnabled(this.overrideFrameRateCB.isSelected());
            this.palTimecodeRB.setEnabled(this.overrideFrameRateCB.isSelected());
        } else if (e.getSource() == this.restrictCheckBox) {
            this.recalculateTimesCB.setEnabled(this.restrictCheckBox.isSelected());
        }
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportSubtitleDialog.restrictCheckBox", null);
        if (useTyp != null) {
            this.restrictCheckBox.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.minimalDurCB", null)) != null) {
            this.minimalDurCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.overrideFrameRateCB", null)) != null) {
            this.overrideFrameRateCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.ntscDFTimecodeRB", null)) != null) {
            this.ntscDFTimecodeRB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.ntscNDFTimecodeRB", null)) != null) {
            this.ntscNDFTimecodeRB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.palTimecodeRB", null)) != null) {
            this.palTimecodeRB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.minimalDurTF", null)) != null) {
            this.minimalDurTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportSubtitleDialog.recalculateTimesCB", null)) != null) {
            this.recalculateTimesCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportSubtitleDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.minimalDurCB", this.minimalDurCB.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.overrideFrameRateCB", this.overrideFrameRateCB.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.ntscDFTimecodeRB", this.ntscDFTimecodeRB.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.ntscNDFTimecodeRB", this.ntscNDFTimecodeRB.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.palTimecodeRB", this.palTimecodeRB.isSelected(), null);
        Preferences.set("ExportSubtitleDialog.recalculateTimesCB", this.recalculateTimesCB.isSelected(), null);
        if (this.minimalDurTF.getText() != null) {
            Preferences.set("ExportSubtitleDialog.minimalDurTF", this.minimalDurTF.getText(), null);
        }
        Preferences.set("ExportSubtitleDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
        List prefferedTierOrder = this.getCurrentTierOrder();
        for (int i = 0; i < prefferedTierOrder.size(); ++i) {
            if (prefferedTierOrder.get(i) == this.tierOrder.get(i)) continue;
            Preferences.set("ExportSubtitleDialog.TierOrder", prefferedTierOrder, this.transcription);
            break;
        }
    }
}

