/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.ExportTabdelimited;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.Transcription2TabDelimitedText;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;

public class ExportTabDialog
extends AbstractExtTierExportDialog
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private JCheckBox btCheckBox;
    private JCheckBox correctTimesCB;
    private JCheckBox suppressNamesCB;
    private JCheckBox colPerTierCB;
    private JCheckBox repeatValuesCB;
    private JCheckBox repeatOnlyWithinCB;
    private JCheckBox durCheckBox;
    private JCheckBox etCheckBox;
    private JCheckBox hhmmssmsCheckBox;
    private JCheckBox msCheckBox;
    private JCheckBox ssmsCheckBox;
    private JCheckBox timecodeCB;
    private JLabel timeCodesLabel;
    private JLabel timeFormatLabel;
    private JRadioButton ntscTimecodeRB;
    private JRadioButton palTimecodeRB;
    private JCheckBox includeFileNameCB;
    private JCheckBox includeFilePathCB;
    private boolean multipleFileExport;
    private Insets insets = new Insets(2, 4, 2, 4);
    private List files;
    private List tierOrder;

    public ExportTabDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.multipleFileExport = false;
        this.makeLayout();
        this.extractTiers();
        this.postInit();
        this.downButton.requestFocus();
    }

    public ExportTabDialog(Frame parent, boolean modal, List files) {
        super(parent, modal, null, null);
        this.files = files;
        this.multipleFileExport = true;
        this.makeLayout();
        this.extractTiersFromFiles();
        this.postInit();
        this.downButton.requestFocus();
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
    }

    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.timecodeCB) {
            this.palTimecodeRB.setEnabled(this.timecodeCB.isSelected());
            this.ntscTimecodeRB.setEnabled(this.timecodeCB.isSelected());
        } else if (ce.getSource() == this.colPerTierCB) {
            this.repeatValuesCB.setEnabled(this.colPerTierCB.isSelected());
            if (!this.colPerTierCB.isSelected()) {
                this.repeatOnlyWithinCB.setEnabled(false);
            }
        } else if (ce.getSource() == this.repeatValuesCB) {
            this.repeatOnlyWithinCB.setEnabled(this.repeatValuesCB.isSelected());
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            int i;
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                this.tierOrder = this.getTierOrder((List)Preferences.get("ExportTabDialog.TierOrder", this.transcription));
                for (i = 0; i < this.tierOrder.size(); ++i) {
                    if (i == 0) {
                        this.model.addRow(new Object[]{Boolean.TRUE, (String)this.tierOrder.get(i)});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, (String)this.tierOrder.get(i)});
                }
                Object useTyp = Preferences.get("ExportTabDialog.selectedTiers", this.transcription);
                if (useTyp != null) {
                    this.loadTierPreferences((ArrayList)useTyp);
                }
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private void extractTiersFromFiles() {
        if (this.files == null || this.files.size() == 0) {
            return;
        }
        if (this.model != null) {
            int i;
            for (int i2 = this.model.getRowCount() - 1; i2 >= 0; --i2) {
                this.model.removeRow(i2);
            }
            ArrayList<String> tierNames = new ArrayList<String>();
            ArrayList pts = null;
            EAFSkeletonParser parser = null;
            for (i = 0; i < this.files.size(); ++i) {
                String path = ((File)this.files.get(i)).getAbsolutePath();
                try {
                    parser = new EAFSkeletonParser(path);
                    parser.parse();
                    pts = parser.getTiers();
                    for (int j = 0; j < pts.size(); ++j) {
                        TierImpl t = (TierImpl)pts.get(j);
                        if (tierNames.contains(t.getName())) continue;
                        tierNames.add(t.getName());
                    }
                    continue;
                }
                catch (ParseException pe) {
                    LOG.warning(pe.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    LOG.warning("Could not load file: " + path);
                }
            }
            for (i = 0; i < tierNames.size(); ++i) {
                this.model.addRow(new Object[]{Boolean.TRUE, tierNames.get(i)});
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.timeCodesLabel = new JLabel();
        this.timeFormatLabel = new JLabel();
        this.btCheckBox = new JCheckBox();
        this.etCheckBox = new JCheckBox();
        this.durCheckBox = new JCheckBox();
        this.hhmmssmsCheckBox = new JCheckBox();
        this.ssmsCheckBox = new JCheckBox();
        this.msCheckBox = new JCheckBox();
        this.timecodeCB = new JCheckBox();
        this.palTimecodeRB = new JRadioButton();
        this.ntscTimecodeRB = new JRadioButton();
        this.includeFileNameCB = new JCheckBox();
        this.includeFilePathCB = new JCheckBox();
        ButtonGroup group = new ButtonGroup();
        this.correctTimesCB = new JCheckBox();
        this.suppressNamesCB = new JCheckBox();
        this.colPerTierCB = new JCheckBox();
        this.repeatValuesCB = new JCheckBox();
        this.colPerTierCB.addChangeListener(this);
        this.repeatValuesCB.setSelected(true);
        this.repeatValuesCB.setEnabled(false);
        this.repeatValuesCB.addChangeListener(this);
        this.repeatOnlyWithinCB = new JCheckBox();
        this.repeatOnlyWithinCB.setSelected(false);
        this.repeatOnlyWithinCB.setEnabled(false);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.suppressNamesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.colPerTierCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 2, 4);
        this.optionsPanel.add((Component)this.repeatValuesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 2, 4);
        this.optionsPanel.add((Component)this.repeatOnlyWithinCB, gridBagConstraints);
        if (!this.multipleFileExport) {
            JPanel fill = new JPanel();
            Dimension fillDim = new Dimension(30, 10);
            fill.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)fill, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeCodesLabel, gridBagConstraints);
            JPanel filler = new JPanel();
            filler.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)filler, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeFormatLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.btCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.hhmmssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.etCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.ssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.durCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.msCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timecodeCB, gridBagConstraints);
            JPanel smptePanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            this.optionsPanel.add((Component)smptePanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.palTimecodeRB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.ntscTimecodeRB, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.includeFileNameCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.includeFilePathCB, gridBagConstraints);
            JPanel fill = new JPanel();
            Dimension fillDim = new Dimension(30, 10);
            fill.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)fill, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeCodesLabel, gridBagConstraints);
            JPanel filler = new JPanel();
            filler.setPreferredSize(fillDim);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)filler, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timeFormatLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.btCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.hhmmssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.etCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.ssmsCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.durCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.msCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.timecodeCB, gridBagConstraints);
            JPanel smptePanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 14;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            this.optionsPanel.add((Component)smptePanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.palTimecodeRB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 22, 2, 4);
            smptePanel.add((Component)this.ntscTimecodeRB, gridBagConstraints);
        }
        group.add(this.palTimecodeRB);
        group.add(this.ntscTimecodeRB);
        this.timecodeCB.addChangeListener(this);
        this.setPreferencesOrDefaultSettings();
        if (this.transcription == null) {
            this.correctTimesCB.setEnabled(false);
            this.restrictCheckBox.setEnabled(false);
        }
        this.updateLocale();
    }

    protected boolean startExport() throws IOException {
        ExportTabdelimited et;
        Vector mds;
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        File exportFile = this.promptForFile(ElanLocale.getString("ExportTabDialog.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), true);
        if (exportFile == null) {
            return false;
        }
        String[] tierNames = selectedTiers.toArray(new String[0]);
        long selectionBT = 0L;
        long selectionET = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            selectionBT = this.selection.getBeginTime();
            selectionET = this.selection.getEndTime();
        }
        long mediaOffset = 0L;
        if (this.correctTimesCB.isSelected() && (mds = this.transcription.getMediaDescriptors()) != null && mds.size() > 0) {
            mediaOffset = ((MediaDescriptor)mds.get((int)0)).timeOrigin;
        }
        if (this.transcription != null) {
            if (this.colPerTierCB.isSelected()) {
                if (!this.repeatValuesCB.isSelected()) {
                    Transcription2TabDelimitedText.exportTiersColumnPerTier(this.transcription, tierNames, exportFile, this.encoding, selectionBT, selectionET, this.btCheckBox.isSelected(), this.etCheckBox.isSelected(), this.durCheckBox.isSelected(), this.hhmmssmsCheckBox.isSelected(), this.ssmsCheckBox.isSelected(), this.msCheckBox.isSelected(), this.timecodeCB.isSelected(), this.palTimecodeRB.isSelected(), mediaOffset);
                } else {
                    et = new ExportTabdelimited();
                    et.includeBeginTime = this.btCheckBox.isSelected();
                    et.includeEndTime = this.etCheckBox.isSelected();
                    et.includeDuration = this.durCheckBox.isSelected();
                    et.includeHHMM = this.hhmmssmsCheckBox.isSelected();
                    et.includeSSMS = this.ssmsCheckBox.isSelected();
                    et.includeMS = this.msCheckBox.isSelected();
                    et.includeSMPTE = this.timecodeCB.isSelected();
                    et.palFormat = this.palTimecodeRB.isSelected();
                    et.mediaOffset = mediaOffset;
                    et.repeatValues = true;
                    et.combineBlocks = !this.repeatOnlyWithinCB.isSelected();
                    et.exportTiersColumnPerTier(this.transcription, tierNames, exportFile, this.encoding, selectionBT, selectionET);
                }
            } else {
                Transcription2TabDelimitedText.exportTiers(this.transcription, tierNames, exportFile, this.encoding, selectionBT, selectionET, this.btCheckBox.isSelected(), this.etCheckBox.isSelected(), this.durCheckBox.isSelected(), this.hhmmssmsCheckBox.isSelected(), this.ssmsCheckBox.isSelected(), this.msCheckBox.isSelected(), this.timecodeCB.isSelected(), this.palTimecodeRB.isSelected(), mediaOffset, !this.suppressNamesCB.isSelected());
            }
        } else if (this.colPerTierCB.isSelected()) {
            if (!this.repeatValuesCB.isSelected()) {
                Transcription2TabDelimitedText.exportTiersColumnPerTier(this.files, tierNames, exportFile, this.encoding, this.btCheckBox.isSelected(), this.etCheckBox.isSelected(), this.durCheckBox.isSelected(), this.hhmmssmsCheckBox.isSelected(), this.ssmsCheckBox.isSelected(), this.msCheckBox.isSelected(), this.timecodeCB.isSelected(), this.palTimecodeRB.isSelected(), this.includeFileNameCB.isSelected(), this.includeFilePathCB.isSelected());
            } else {
                et = new ExportTabdelimited();
                et.includeBeginTime = this.btCheckBox.isSelected();
                et.includeEndTime = this.etCheckBox.isSelected();
                et.includeDuration = this.durCheckBox.isSelected();
                et.includeHHMM = this.hhmmssmsCheckBox.isSelected();
                et.includeSSMS = this.ssmsCheckBox.isSelected();
                et.includeMS = this.msCheckBox.isSelected();
                et.includeSMPTE = this.timecodeCB.isSelected();
                et.palFormat = this.palTimecodeRB.isSelected();
                et.includeFileName = this.includeFileNameCB.isSelected();
                et.includeFilePath = this.includeFilePathCB.isSelected();
                et.mediaOffset = mediaOffset;
                et.repeatValues = true;
                et.combineBlocks = !this.repeatOnlyWithinCB.isSelected();
                et.exportTiersColumnPerTier(this.files, tierNames, exportFile, this.encoding, 0L, Long.MAX_VALUE);
            }
        } else {
            Transcription2TabDelimitedText.exportTiers(this.files, tierNames, exportFile, this.encoding, this.btCheckBox.isSelected(), this.etCheckBox.isSelected(), this.durCheckBox.isSelected(), this.hhmmssmsCheckBox.isSelected(), this.ssmsCheckBox.isSelected(), this.msCheckBox.isSelected(), this.timecodeCB.isSelected(), this.palTimecodeRB.isSelected(), !this.suppressNamesCB.isSelected(), this.includeFileNameCB.isSelected(), this.includeFilePathCB.isSelected());
        }
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTabDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTabDialog.TitleLabel"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.suppressNamesCB.setText(ElanLocale.getString("ExportTabDialog.Label.SuppressNames"));
        this.colPerTierCB.setText(ElanLocale.getString("ExportTabDialog.Label.ColPerTier"));
        this.repeatValuesCB.setText(ElanLocale.getString("ExportTabDialog.Label.RepeatValues"));
        this.repeatOnlyWithinCB.setText(ElanLocale.getString("ExportTabDialog.Label.RepeatWithinBlock"));
        this.includeFileNameCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeFileName"));
        this.includeFilePathCB.setText(ElanLocale.getString("ExportTabDialog.Label.IncludeFilePath"));
        this.timeCodesLabel.setText(ElanLocale.getString("ExportTabDialog.Label.Columns"));
        this.timeFormatLabel.setText(ElanLocale.getString("ExportTabDialog.Label.Formats"));
        this.btCheckBox.setText(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime"));
        this.etCheckBox.setText(ElanLocale.getString("Frame.GridFrame.ColumnEndTime"));
        this.durCheckBox.setText(ElanLocale.getString("Frame.GridFrame.ColumnDuration"));
        this.hhmmssmsCheckBox.setText(ElanLocale.getString("TimeCodeFormat.TimeCode"));
        this.ssmsCheckBox.setText(ElanLocale.getString("TimeCodeFormat.Seconds"));
        this.msCheckBox.setText(ElanLocale.getString("TimeCodeFormat.MilliSec"));
        this.timecodeCB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE"));
        this.ntscTimecodeRB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
        this.palTimecodeRB.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"));
    }

    private void setPreferencesOrDefaultSettings() {
        Object useTyp = Preferences.get("ExportTabDialog.restrictCheckBox", null);
        if (useTyp != null) {
            this.restrictCheckBox.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.suppressNamesCB", null)) != null) {
            this.suppressNamesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.colPerTierCB", null)) != null) {
            this.colPerTierCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.repeatValuesCB", null)) != null) {
            this.repeatValuesCB.setSelected((Boolean)useTyp);
        } else {
            this.repeatValuesCB.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.repeatOnlyWithinCB", null);
        if (useTyp != null) {
            this.repeatOnlyWithinCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.btCheckBox", null)) != null) {
            this.btCheckBox.setSelected((Boolean)useTyp);
        } else {
            this.btCheckBox.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.etCheckBox", null);
        if (useTyp != null) {
            this.etCheckBox.setSelected((Boolean)useTyp);
        } else {
            this.etCheckBox.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.durCheckBox", null);
        if (useTyp != null) {
            this.durCheckBox.setSelected((Boolean)useTyp);
        } else {
            this.durCheckBox.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.hhmmssmsCheckBox", null);
        if (useTyp != null) {
            this.hhmmssmsCheckBox.setSelected((Boolean)useTyp);
        } else {
            this.hhmmssmsCheckBox.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.ssmsCheckBox", null);
        if (useTyp != null) {
            this.ssmsCheckBox.setSelected((Boolean)useTyp);
        } else {
            this.ssmsCheckBox.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.msCheckBox", null);
        if (useTyp != null) {
            this.msCheckBox.setSelected((Boolean)useTyp);
        } else {
            this.msCheckBox.setSelected(false);
        }
        useTyp = Preferences.get("ExportTabDialog.timecodeCB", null);
        if (useTyp != null) {
            this.timecodeCB.setSelected((Boolean)useTyp);
        } else {
            this.timecodeCB.setSelected(false);
        }
        useTyp = Preferences.get("ExportTabDialog.ntscTimecodeRB", null);
        if (useTyp != null) {
            this.ntscTimecodeRB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.palTimecodeRB", null)) != null) {
            this.palTimecodeRB.setSelected((Boolean)useTyp);
        } else {
            this.palTimecodeRB.setSelected(true);
        }
        useTyp = Preferences.get("ExportTabDialog.includeFileNameCB", null);
        if (useTyp != null) {
            this.includeFileNameCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTabDialog.includeFilePathCB", null)) != null) {
            this.includeFilePathCB.setSelected((Boolean)useTyp);
        } else {
            this.includeFilePathCB.setSelected(true);
        }
        if (this.timecodeCB.isSelected()) {
            this.palTimecodeRB.setEnabled(true);
            this.ntscTimecodeRB.setEnabled(true);
        } else {
            this.palTimecodeRB.setEnabled(false);
            this.ntscTimecodeRB.setEnabled(false);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTabDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.suppressNamesCB", this.suppressNamesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.colPerTierCB", this.colPerTierCB.isSelected(), null);
        Preferences.set("ExportTabDialog.repeatValuesCB", this.repeatValuesCB.isSelected(), null);
        Preferences.set("ExportTabDialog.repeatOnlyWithinCB", this.repeatOnlyWithinCB.isSelected(), null);
        Preferences.set("ExportTabDialog.btCheckBox", this.btCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.etCheckBox", this.etCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.durCheckBox", this.durCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.hhmmssmsCheckBox", this.hhmmssmsCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.ssmsCheckBox", this.ssmsCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.msCheckBox", this.msCheckBox.isSelected(), null);
        Preferences.set("ExportTabDialog.timecodeCB", this.timecodeCB.isSelected(), null);
        Preferences.set("ExportTabDialog.ntscTimecodeRB", this.ntscTimecodeRB.isSelected(), null);
        Preferences.set("ExportTabDialog.palTimecodeRB", this.palTimecodeRB.isSelected(), null);
        Preferences.set("ExportTabDialog.includeFileNameCB", this.includeFileNameCB.isSelected(), null);
        Preferences.set("ExportTabDialog.includeFilePathCB", this.includeFilePathCB.isSelected(), null);
        if (!this.multipleFileExport) {
            Preferences.set("ExportTabDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
            List prefferedTierOrder = this.getCurrentTierOrder();
            for (int i = 0; i < prefferedTierOrder.size(); ++i) {
                if (prefferedTierOrder.get(i) == this.tierOrder.get(i)) continue;
                Preferences.set("ExportTabDialog.TierOrder", prefferedTierOrder, this.transcription);
                break;
            }
        }
    }
}

