/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class ExportTradTranscript
extends AbstractExtTierExportDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    private JCheckBox labelsCB;
    private JCheckBox rootTiersCB;
    private JCheckBox selectionCB;
    private JCheckBox timeCodeCB;
    private JCheckBox silenceCB;
    private JTextField minDurSilTF;
    private JLabel minDurSilLabel;
    private JCheckBox wrapLinesCB;
    private JLabel charPerLineLabel;
    private JTextField numCharTF;
    private final String NEW_LINE = "\n";
    private final String SPACE = " ";
    private final String TIME_SEP = " - ";
    private final char NL_CHAR = (char)10;
    private final char SPACE_CHAR = (char)32;
    private final int LABEL_VALUE_MARGIN = 3;
    private final int NUM_CHARS = 80;
    private final int MIN_SILENCE = 20;
    private List tierOrder;

    public ExportTradTranscript(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.wrapLinesCB) {
            if (this.wrapLinesCB.isSelected()) {
                this.numCharTF.setEnabled(true);
                this.numCharTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.numCharTF.getText() != null || this.numCharTF.getText().length() == 0) {
                    this.numCharTF.setText("80");
                }
                this.numCharTF.requestFocus();
            } else {
                this.numCharTF.setEnabled(false);
                this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.silenceCB) {
            if (this.silenceCB.isSelected()) {
                this.minDurSilTF.setEnabled(true);
                this.minDurSilTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.minDurSilTF.getText() == null || this.minDurSilTF.getText().length() == 0) {
                    this.minDurSilTF.setText("20");
                }
                this.minDurSilTF.requestFocus();
            } else {
                this.minDurSilTF.setEnabled(false);
                this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.rootTiersCB) {
            this.extractTiers();
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                boolean rootsOnly = this.rootTiersCB.isSelected();
                if (rootsOnly) {
                    ArrayList<String> currentRootTierOrderList = new ArrayList<String>();
                    List tierOrderList = ELANCommandFactory.getViewerManager(this.transcription).getTierOrder().getTierOrder();
                    for (int i = 0; i < tierOrderList.size(); ++i) {
                        if (((TierImpl)this.transcription.getTierWithId((String)tierOrderList.get(i))).hasParentTier()) continue;
                        currentRootTierOrderList.add((String)tierOrderList.get(i));
                    }
                    Object useTyp = Preferences.get("ExportTradTranscript.ParentTierOrder", this.transcription);
                    if (useTyp instanceof ArrayList) {
                        this.tierOrder = (List)useTyp;
                        int i = 0;
                        while (i < this.tierOrder.size()) {
                            if (!currentRootTierOrderList.contains(this.tierOrder.get(i))) {
                                this.tierOrder.remove(i);
                                continue;
                            }
                            ++i;
                        }
                        if (this.tierOrder.size() != currentRootTierOrderList.size()) {
                            i = 0;
                            while (currentRootTierOrderList.size() != this.tierOrder.size()) {
                                if (!this.tierOrder.contains(currentRootTierOrderList.get(i))) {
                                    this.tierOrder.add(currentRootTierOrderList.get(i));
                                }
                                ++i;
                            }
                        }
                    } else {
                        this.tierOrder = currentRootTierOrderList;
                    }
                } else {
                    this.tierOrder = this.getTierOrder((List)Preferences.get("ExportTradTranscript.TierOrder", this.transcription));
                }
                TierImpl t = null;
                for (int i = 0; i < this.tierOrder.size(); ++i) {
                    if (!(this.tierOrder.get(i) instanceof String)) continue;
                    String tierName = (String)this.tierOrder.get(i);
                    if (rootsOnly) {
                        this.model.addRow(new Object[]{Boolean.TRUE, tierName});
                        continue;
                    }
                    t = (TierImpl)this.transcription.getTierWithId(tierName);
                    if (t.getParentTier() == null) {
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
                }
                Object useTyp = Preferences.get("ExportTradTranscript.selectedTiers", this.transcription);
                if (useTyp instanceof ArrayList) {
                    this.loadTierPreferences((ArrayList)useTyp);
                }
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.rootTiersCB = new JCheckBox();
        this.charPerLineLabel = new JLabel();
        this.wrapLinesCB = new JCheckBox();
        this.numCharTF = new JTextField(4);
        this.timeCodeCB = new JCheckBox();
        this.silenceCB = new JCheckBox();
        this.minDurSilLabel = new JLabel();
        this.minDurSilTF = new JTextField(4);
        this.labelsCB = new JCheckBox();
        this.selectionCB = new JCheckBox();
        this.rootTiersCB.setSelected(true);
        this.rootTiersCB.addItemListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.tierSelectionPanel.add((Component)this.rootTiersCB, gridBagConstraints);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.wrapLinesCB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.wrapLinesCB, gridBagConstraints);
        JPanel fill = new JPanel();
        Dimension fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)fill, gridBagConstraints);
        this.numCharTF.setEnabled(false);
        this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.numCharTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.charPerLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.labelsCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.timeCodeCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.labelsCB, gridBagConstraints);
        this.silenceCB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.silenceCB, gridBagConstraints);
        fill = new JPanel();
        fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)fill, gridBagConstraints);
        this.minDurSilTF.setEnabled(false);
        this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minDurSilTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minDurSilLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    protected boolean startExport() {
        File exportFile;
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int charsPerLine = Integer.MAX_VALUE;
        if (this.wrapLinesCB.isSelected()) {
            String textValue = this.numCharTF.getText().trim();
            try {
                charsPerLine = Integer.parseInt(textValue);
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber"));
                this.numCharTF.selectAll();
                this.numCharTF.requestFocus();
                return false;
            }
        }
        int minSilence = 20;
        if (this.silenceCB.isSelected()) {
            String textValue = this.minDurSilTF.getText().trim();
            try {
                minSilence = Integer.parseInt(textValue);
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber2"));
                this.minDurSilTF.selectAll();
                this.minDurSilTF.requestFocus();
                return false;
            }
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("ExportTradTranscript.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), true)) == null) {
            return false;
        }
        return this.doExport(exportFile, selectedTiers, charsPerLine, minSilence);
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTradTranscript.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTradTranscript.Title"));
        this.rootTiersCB.setText(ElanLocale.getString("ExportTradTranscript.Label.RootTiers"));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.wrapLinesCB.setText(ElanLocale.getString("ExportTradTranscript.Label.WrapLines"));
        this.charPerLineLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.NumberChars"));
        this.timeCodeCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeTimeCode"));
        this.labelsCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeTierLabels"));
        this.silenceCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeSilence"));
        this.minDurSilLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.MinSilenceDuration"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
    }

    private String getMarginString(String name, int numchars) {
        int nameLength = 0;
        if (name != null) {
            nameLength = name.length();
        }
        StringBuffer bf = new StringBuffer(name);
        for (int i = 0; i < numchars - nameLength; ++i) {
            bf.append(" ");
        }
        return bf.toString();
    }

    private String[] breakValue(String val, int maxAnnotationLength) {
        if (val == null) {
            return new String[0];
        }
        if (val.indexOf(" ") < 0 || val.length() < maxAnnotationLength) {
            return new String[]{val};
        }
        ArrayList<String> vals = new ArrayList<String>();
        String sub = null;
        while (val.length() > maxAnnotationLength) {
            sub = val.substring(0, maxAnnotationLength);
            int breakSpace = sub.lastIndexOf(32);
            if (breakSpace < 0) {
                breakSpace = val.indexOf(32);
                if (breakSpace < 0) {
                    vals.add(val);
                    break;
                }
                vals.add(val.substring(0, breakSpace + 1));
                val = val.substring(breakSpace + 1);
            } else {
                vals.add(sub.substring(0, breakSpace + 1));
                val = val.substring(breakSpace + 1);
            }
            if (val.length() > maxAnnotationLength) continue;
            vals.add(val);
            break;
        }
        return vals.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExport(File exportFile, List orderedTiers, int charsPerLine, int minSilence) {
        boolean selectionOnly = this.selectionCB.isSelected();
        boolean wrapLines = this.wrapLinesCB.isSelected();
        boolean includeTimeCodes = this.timeCodeCB.isSelected();
        boolean includeLabels = this.labelsCB.isSelected();
        boolean includeSilence = this.silenceCB.isSelected();
        int labelMargin = 0;
        Hashtable<String, String> marginStrings = null;
        String tcLabel = "TC";
        String emptyLabel = "empty";
        int maxAnnotationLength = charsPerLine;
        if (includeLabels) {
            int count;
            String name;
            int i;
            marginStrings = new Hashtable<String, String>();
            for (i = 0; i < orderedTiers.size(); ++i) {
                name = (String)orderedTiers.get(i);
                if (name.length() <= labelMargin) continue;
                labelMargin = name.length();
            }
            labelMargin += 3;
            for (i = 0; i < orderedTiers.size(); ++i) {
                name = (String)orderedTiers.get(i);
                marginStrings.put(name, this.getMarginString(name, labelMargin));
            }
            if (includeTimeCodes) {
                if (!marginStrings.containsKey(tcLabel)) {
                    marginStrings.put(tcLabel, this.getMarginString(tcLabel, labelMargin));
                } else {
                    for (count = 1; count < 100; ++count) {
                        String tcl = tcLabel + "-" + count;
                        if (marginStrings.containsKey(tcl)) continue;
                        tcLabel = tcl;
                        marginStrings.put(tcLabel, this.getMarginString(tcLabel, labelMargin));
                        break;
                    }
                }
            }
            if (!marginStrings.containsKey(emptyLabel)) {
                marginStrings.put(emptyLabel, this.getMarginString("", labelMargin));
            } else {
                for (count = 1; count < 100; ++count) {
                    String tcl = emptyLabel + "-" + count;
                    if (marginStrings.containsKey(tcl)) continue;
                    emptyLabel = tcl;
                    marginStrings.put(emptyLabel, this.getMarginString("", labelMargin));
                    break;
                }
            }
        }
        if (wrapLines && includeLabels) {
            maxAnnotationLength = charsPerLine - labelMargin;
        }
        long bb = 0L;
        long eb = Long.MAX_VALUE;
        if (selectionOnly && this.selection != null) {
            bb = this.selection.getBeginTime();
            eb = this.selection.getEndTime();
        }
        TreeSet<IndexedExportRecord> records = new TreeSet<IndexedExportRecord>();
        block17: for (int i = 0; i < orderedTiers.size(); ++i) {
            String tierName = (String)orderedTiers.get(i);
            TierImpl t = (TierImpl)this.transcription.getTierWithId(tierName);
            if (t == null) continue;
            Vector v = t.getAnnotations();
            for (int j = 0; j < v.size(); ++j) {
                Annotation ann = (Annotation)v.get(j);
                if (TimeRelation.overlaps(ann, bb, eb)) {
                    records.add(new IndexedExportRecord(ann, i));
                }
                if (ann.getBeginTimeBoundary() > eb) continue block17;
            }
        }
        if (includeSilence) {
            IndexedExportRecord rec1 = null;
            IndexedExportRecord rec22 = null;
            for (IndexedExportRecord rec22 : records) {
                long dur;
                if (rec1 != null && (dur = rec22.getBeginTime() - rec1.getEndTime()) >= (long)minSilence) {
                    rec1.setSilenceAfter(this.formatSilenceString(dur));
                }
                rec1 = rec22;
            }
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(exportFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, this.encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            for (IndexedExportRecord record : records) {
                String val = record.getValue().replace('\n', ' ');
                if (includeLabels) {
                    writer.write((String)marginStrings.get(record.getTierName()));
                }
                if (!wrapLines) {
                    writer.write(val);
                } else if (val.length() <= maxAnnotationLength) {
                    writer.write(val);
                } else {
                    String[] valLines = this.breakValue(val, maxAnnotationLength);
                    for (int i = 0; i < valLines.length; ++i) {
                        if (i != 0 && includeLabels) {
                            writer.write((String)marginStrings.get(emptyLabel));
                        }
                        writer.write(valLines[i]);
                        if (i == valLines.length - 1) continue;
                        writer.write("\n");
                    }
                }
                writer.write("\n");
                if (includeTimeCodes) {
                    if (includeLabels) {
                        writer.write((String)marginStrings.get(tcLabel));
                    }
                    writer.write(TimeFormatter.toString(record.getBeginTime()));
                    writer.write(" - ");
                    writer.write(TimeFormatter.toString(record.getEndTime()));
                    writer.write("\n");
                    if (includeSilence && record.getSilenceAfter() != null) {
                        if (includeLabels) {
                            writer.write((String)marginStrings.get(emptyLabel));
                        }
                        writer.write("(" + record.getSilenceAfter() + ")");
                        writer.write("\n");
                    }
                    writer.write("\n");
                    continue;
                }
                if (!includeSilence) continue;
                if (record.getSilenceAfter() != null) {
                    if (includeLabels) {
                        writer.write((String)marginStrings.get(emptyLabel));
                    }
                    writer.write("(" + record.getSilenceAfter() + ")");
                    writer.write("\n");
                }
                writer.write("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Warning"), 2);
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ee) {}
        }
        return true;
    }

    private String formatSilenceString(long dur) {
        if (dur <= 0L) {
            return null;
        }
        return String.valueOf((float)Math.round(dur / 10L) / 100.0f);
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportTradTranscript.rootTiersCB", null);
        if (useTyp != null) {
            this.rootTiersCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.selectionCB", null)) != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.timeCodeCB", null)) != null) {
            this.timeCodeCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.silenceCB", null)) != null) {
            this.silenceCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.wrapLinesCB", null)) != null) {
            this.wrapLinesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.labelsCB", null)) != null) {
            this.labelsCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.minDurSilTF", null)) != null) {
            this.minDurSilTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.numCharTF", null)) != null) {
            this.numCharTF.setText(useTyp.toString());
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTradTranscript.rootTiersCB", this.rootTiersCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.selectionCB", this.selectionCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.timeCodeCB", this.timeCodeCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.silenceCB", this.silenceCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.wrapLinesCB", this.wrapLinesCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.labelsCB", this.labelsCB.isSelected(), null);
        if (this.minDurSilTF.getText() != null) {
            Preferences.set("ExportTradTranscript.minDurSilTF", this.minDurSilTF.getText(), null);
        }
        if (this.numCharTF.getText() != null) {
            Preferences.set("ExportTradTranscript.minimalDurTF", this.numCharTF.getText(), null);
        }
        Preferences.set("ExportTradTranscript.selectedTiers", this.getSelectedTiers(), this.transcription);
        List prefferedTierOrder = this.getCurrentTierOrder();
        for (int i = 0; i < prefferedTierOrder.size(); ++i) {
            if (prefferedTierOrder.get(i) == this.tierOrder.get(i)) continue;
            if (this.rootTiersCB.isSelected()) {
                Preferences.set("ExportTradTranscript.ParentTierOrder", prefferedTierOrder, this.transcription);
                break;
            }
            Preferences.set("ExportTradTranscript.TierOrder", prefferedTierOrder, this.transcription);
            break;
        }
    }

    private class IndexedExportRecord
    extends AnnotationDataRecord
    implements Comparable {
        private int index;
        private String silAfter;

        IndexedExportRecord(Annotation annotation, int index) {
            super(annotation);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setSilenceAfter(String value) {
            this.silAfter = value;
        }

        public String getSilenceAfter() {
            return this.silAfter;
        }

        public int compareTo(Object o) throws ClassCastException {
            if (!(o instanceof IndexedExportRecord)) {
                throw new ClassCastException("Object is not an IndexedExportRecord");
            }
            IndexedExportRecord other = (IndexedExportRecord)o;
            if (this.getBeginTime() < other.getBeginTime()) {
                return -1;
            }
            if (this.getBeginTime() > other.getBeginTime()) {
                return 1;
            }
            if (this.index < other.getIndex()) {
                return -1;
            }
            if (this.index > other.getIndex()) {
                return 1;
            }
            return 0;
        }
    }
}

