/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.Transcription2WordList;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;

public class ExportWordListDialog
extends AbstractExtTierExportDialog
implements ChangeListener {
    private List files;
    private Map<String, String> tierTypeMap = new LinkedHashMap<String, String>();
    private List<String> tierNames = new ArrayList<String>();
    private List<String> typeNames = new ArrayList<String>();
    private JRadioButton tierRB;
    private JRadioButton typeRB;
    private JRadioButton customDelimRB;
    private JLabel tokenDelimLabel;
    private JRadioButton defaultDelimRB;
    private JTextField customDelimField;
    private ButtonGroup delimButtonGroup;
    private JCheckBox countTokensCB;
    public static int WORDS = 0;
    public static int ANNOTATIONS = 1;
    private int mode = WORDS;
    private boolean multipleFileExport = false;
    private List tierOrder;

    public ExportWordListDialog(Frame parent, boolean modal, Transcription transcription) {
        super(parent, modal, transcription, null);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public ExportWordListDialog(Frame parent, boolean modal, List files) {
        this(parent, modal, files, WORDS);
    }

    public ExportWordListDialog(Frame parent, boolean modal, List files, int mode) {
        super(parent, modal, null, null);
        this.files = files;
        if (mode == ANNOTATIONS || mode == WORDS) {
            this.mode = mode;
        }
        this.makeLayout();
        this.extractTiersFromFiles();
        this.postInit();
    }

    protected List getSelectedTiers() {
        if (this.typeRB.isSelected()) {
            ArrayList<String> selTierNames = new ArrayList<String>();
            if (this.model != null) {
                int includeCol = this.model.findColumn("export");
                int nameCol = this.model.findColumn("tier");
                ArrayList<String> selectedTypes = new ArrayList<String>();
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
                    if (!include.booleanValue()) continue;
                    selectedTypes.add((String)this.model.getValueAt(i, nameCol));
                }
                for (int i = 0; i < this.tierNames.size(); ++i) {
                    String nt = this.tierNames.get(i);
                    boolean select = selectedTypes.contains(this.tierTypeMap.get(nt));
                    if (!select) continue;
                    selTierNames.add(nt);
                }
            }
            return selTierNames;
        }
        return super.getSelectedTiers();
    }

    protected void extractTiers() {
        this.multipleFileExport = false;
        if (this.model != null) {
            Object useTyp;
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                int i;
                this.tierOrder = this.getTierOrder((List)Preferences.get("ExportWordListDialog.TierOrder", this.transcription));
                Vector<TierImpl> v = new Vector<TierImpl>();
                TierImpl t = null;
                for (i = 0; i < this.tierOrder.size(); ++i) {
                    t = (TierImpl)this.transcription.getTierWithId((String)this.tierOrder.get(i));
                    if (t == null) continue;
                    v.add(t);
                }
                for (i = 0; i < v.size(); ++i) {
                    t = (TierImpl)v.get(i);
                    this.tierNames.add(t.getName());
                    if (!this.typeNames.contains(t.getLinguisticType().getLinguisticTypeName())) {
                        this.typeNames.add(t.getLinguisticType().getLinguisticTypeName());
                    }
                    this.tierTypeMap.put(t.getName(), t.getLinguisticType().getLinguisticTypeName());
                    this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                }
            }
            if ((useTyp = Preferences.get("ExportWordListDialog.selectedTiers", this.transcription)) instanceof ArrayList) {
                this.loadTierPreferences((ArrayList)useTyp);
            }
            if (this.typeRB.isSelected()) {
                this.updateTable();
            }
        }
    }

    private void extractTiersFromFiles() {
        this.multipleFileExport = true;
        if (this.files == null || this.files.size() == 0) {
            return;
        }
        if (this.model != null) {
            int i;
            for (int i2 = this.model.getRowCount() - 1; i2 >= 0; --i2) {
                this.model.removeRow(i2);
            }
            ArrayList pts = null;
            EAFSkeletonParser parser = null;
            for (i = 0; i < this.files.size(); ++i) {
                String path = ((File)this.files.get(i)).getAbsolutePath();
                try {
                    parser = new EAFSkeletonParser(path);
                    parser.parse();
                    pts = parser.getTiers();
                    for (int j = 0; j < pts.size(); ++j) {
                        TierImpl t = (TierImpl)pts.get(j);
                        if (!this.tierNames.contains(t.getName())) {
                            this.tierNames.add(t.getName());
                        }
                        if (!this.tierTypeMap.containsKey(t.getName())) {
                            this.tierTypeMap.put(t.getName(), t.getLinguisticType().getLinguisticTypeName());
                        }
                        if (this.typeNames.contains(t.getLinguisticType().getLinguisticTypeName())) continue;
                        this.typeNames.add(t.getLinguisticType().getLinguisticTypeName());
                    }
                    continue;
                }
                catch (ParseException pe) {
                    LOG.warning(pe.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    LOG.warning("Could not load file: " + path);
                }
            }
            for (i = 0; i < this.tierNames.size(); ++i) {
                this.model.addRow(new Object[]{Boolean.TRUE, this.tierNames.get(i)});
            }
            if (this.typeRB.isSelected()) {
                this.updateTable();
            }
        }
    }

    private void updateTable() {
        block7: {
            boolean select;
            int i;
            if (this.model == null) break block7;
            int includeCol = this.model.findColumn("export");
            int nameCol = this.model.findColumn("tier");
            ArrayList<String> selectedTiersOrTypes = new ArrayList<String>();
            for (i = 0; i < this.model.getRowCount(); ++i) {
                Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
                if (!include.booleanValue()) continue;
                selectedTiersOrTypes.add((String)this.model.getValueAt(i, nameCol));
            }
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.tierRB.isSelected()) {
                for (int i2 = 0; i2 < this.tierNames.size(); ++i2) {
                    String nt = this.tierNames.get(i2);
                    select = selectedTiersOrTypes.contains(this.tierTypeMap.get(nt));
                    this.model.addRow(new Object[]{new Boolean(select), nt});
                }
            } else {
                String ntype;
                int i3;
                ArrayList<String> selTypes = new ArrayList<String>(10);
                for (i3 = 0; i3 < selectedTiersOrTypes.size(); ++i3) {
                    ntype = this.tierTypeMap.get(selectedTiersOrTypes.get(i3));
                    if (selTypes.contains(ntype)) continue;
                    selTypes.add(ntype);
                }
                for (i3 = 0; i3 < this.typeNames.size(); ++i3) {
                    ntype = this.typeNames.get(i3);
                    select = selTypes.contains(ntype);
                    this.model.addRow(new Object[]{new Boolean(select), this.typeNames.get(i3)});
                }
            }
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        JPanel tierButtonPanel = new JPanel(new GridBagLayout());
        this.tierRB = new JRadioButton(ElanLocale.getString("ExportDialog.Label.TiersByName"));
        this.tierRB.setSelected(true);
        this.typeRB = new JRadioButton(ElanLocale.getString("ExportDialog.Label.TiersOfType"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.tierRB);
        bg.add(this.typeRB);
        this.tierRB.addActionListener(this);
        this.typeRB.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        tierButtonPanel.add((Component)this.tierRB, gbc);
        gbc.gridx = 1;
        tierButtonPanel.add((Component)this.typeRB, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        tierButtonPanel.add((Component)new JPanel(), gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = this.insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.tierSelectionPanel.add((Component)tierButtonPanel, gbc);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.countTokensCB = new JCheckBox();
        if (this.mode == WORDS) {
            this.delimButtonGroup = new ButtonGroup();
            this.tokenDelimLabel = new JLabel();
            this.defaultDelimRB = new JRadioButton();
            this.customDelimRB = new JRadioButton();
            this.customDelimField = new JTextField();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.tokenDelimLabel, gridBagConstraints);
            this.defaultDelimRB.setSelected(true);
            this.defaultDelimRB.addChangeListener(this);
            this.delimButtonGroup.add(this.defaultDelimRB);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.defaultDelimRB, gridBagConstraints);
            this.customDelimRB.addChangeListener(this);
            this.delimButtonGroup.add(this.customDelimRB);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.customDelimRB, gridBagConstraints);
            this.customDelimField.setEnabled(false);
            this.customDelimField.setColumns(6);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.customDelimField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 6, 4, 6);
            this.optionsPanel.add((Component)this.countTokensCB, gridBagConstraints);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.countTokensCB, gridBagConstraints);
        }
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected void updateLocale() {
        super.updateLocale();
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.WordList.Title"));
        if (this.mode == WORDS) {
            this.titleLabel.setText(ElanLocale.getString("ExportDialog.WordList.Title"));
            this.tokenDelimLabel.setText(ElanLocale.getString("TokenizeDialog.Label.TokenDelimiter"));
            this.defaultDelimRB.setText(ElanLocale.getString("Button.Default") + "( . , ! ? \" ' )");
            this.customDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Custom"));
        } else if (this.mode == ANNOTATIONS) {
            this.titleLabel.setText(ElanLocale.getString("ExportDialog.AnnotationList.Title"));
        }
        this.countTokensCB.setText(ElanLocale.getString("ExportDialog.WordList.CountOccur"));
    }

    protected boolean startExport() throws IOException {
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        File exportFile = null;
        if (this.mode == WORDS) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.WordList.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), true);
        } else if (this.mode == ANNOTATIONS) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.AnnotationList.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), true);
        }
        if (exportFile == null) {
            return false;
        }
        String delimiters = null;
        if (this.mode == WORDS && this.customDelimRB.isSelected()) {
            delimiters = this.customDelimField.getText();
        }
        boolean countOccurrences = this.countTokensCB.isSelected();
        Transcription2WordList twl = new Transcription2WordList();
        try {
            if (this.transcription != null) {
                twl.exportWords(this.transcription, (List<String>)selectedTiers, exportFile, this.encoding, delimiters, countOccurrences);
            } else if (this.mode == ANNOTATIONS) {
                twl.exportWords(this.files, (List<String>)selectedTiers, exportFile, this.encoding, new String(""), countOccurrences);
            } else if (this.mode == WORDS) {
                twl.exportWords(this.files, (List<String>)selectedTiers, exportFile, this.encoding, delimiters, countOccurrences);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Error"), 2);
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.tierRB) {
            this.updateTable();
        } else if (ae.getSource() == this.typeRB) {
            this.updateTable();
        } else {
            super.actionPerformed(ae);
        }
    }

    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.defaultDelimRB || ce.getSource() == this.customDelimField) {
            if (this.defaultDelimRB.isSelected()) {
                this.customDelimField.setEnabled(false);
            } else {
                this.customDelimField.setEnabled(true);
                this.customDelimField.requestFocus();
            }
        }
    }

    private void setPreferredSetting() {
        if (this.mode == WORDS) {
            Object useTyp = Preferences.get("ExportWordListDialog.tierRB", null);
            if (useTyp != null) {
                this.tierRB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportWordListDialog.typeRB", null)) != null) {
                this.typeRB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportWordListDialog.customDelimRB", null)) != null) {
                this.customDelimRB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportWordListDialog.defaultDelimRB", null)) != null) {
                this.defaultDelimRB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportWordListDialog.countTokensCB", null)) != null) {
                this.countTokensCB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportWordListDialog.customDelimField", null)) != null) {
                this.customDelimField.setText(useTyp.toString());
            }
        } else {
            Object useTyp = Preferences.get("ExportAnnotationListDialog.tierRB", null);
            if (useTyp != null) {
                this.tierRB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportAnnotationListDialog.typeRB", null)) != null) {
                this.typeRB.setSelected((Boolean)useTyp);
            }
            if ((useTyp = Preferences.get("ExportAnnotationListDialog.countTokensCB", null)) != null) {
                this.countTokensCB.setSelected((Boolean)useTyp);
            }
        }
    }

    private void savePreferences() {
        if (this.mode == WORDS) {
            Preferences.set("ExportWordListDialog.tierRB", this.tierRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.typeRB", this.typeRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.customDelimRB", this.customDelimRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.defaultDelimRB", this.defaultDelimRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.countTokensCB", this.countTokensCB.isSelected(), null);
            if (this.customDelimField.getText() != null) {
                Preferences.set("ExportWordListDialog.customDelimField", this.customDelimField.getText(), null);
            }
            if (!this.multipleFileExport) {
                Preferences.set("ExportWordListDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
                List prefferedTierOrder = this.getCurrentTierOrder();
                for (int i = 0; i < prefferedTierOrder.size(); ++i) {
                    if (prefferedTierOrder.get(i) == this.tierOrder.get(i)) continue;
                    Preferences.set("ExportWordListDialog.TierOrder", prefferedTierOrder, this.transcription);
                    break;
                }
            }
        } else {
            Preferences.set("ExportAnnotationListDialog.tierRB", this.tierRB.isSelected(), null);
            Preferences.set("ExportAnnotationListDialog.typeRB", this.typeRB.isSelected(), null);
            Preferences.set("ExportAnnotationListDialog.countTokensCB", this.countTokensCB.isSelected(), null);
        }
    }
}

