/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.util.TableSubHeaderObject;

public class ShortCutPrinter
implements Printable,
Pageable {
    private JTable table;
    private int numPages = 1;
    private int firstColWidth = 0;
    private PageFormat pf;
    private float scale = 0.9f;

    public ShortCutPrinter(JTable shortCutTable) {
        this.table = shortCutTable;
    }

    public void startPrint() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        this.pf = printJob.pageDialog(printJob.defaultPage());
        this.calculateNumPages();
        printJob.setPrintable(this, this.pf);
        printJob.setPageable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.table, ElanLocale.getString("InterlinearizerOptionsDlg.Error.Print") + " \n" + "(" + ex.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        int[] rowExt = this.calculateRowExtremes(pageIndex);
        if (this.firstColWidth == 0) {
            this.firstColWidth = this.calcFirstColWidth(graphics);
        }
        this.renderPage(graphics, rowExt);
        return 0;
    }

    public int getNumberOfPages() {
        return this.numPages;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " < 0");
        }
        if (pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " > " + (this.getNumberOfPages() - 1));
        }
        return this.pf;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " < 0");
        }
        if (pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " > " + (this.getNumberOfPages() - 1));
        }
        return this;
    }

    private void calculateNumPages() {
        if (this.table == null || this.pf == null) {
            return;
        }
        int imgH = (int)this.pf.getImageableHeight();
        int curY = 0;
        curY += (int)(this.scale * (float)this.table.getTableHeader().getHeight());
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if ((curY += (int)(this.scale * (float)this.table.getRowHeight(i))) <= imgH) continue;
            ++this.numPages;
            if (this.table.getValueAt(--i, 0) instanceof TableSubHeaderObject) {
                --i;
            }
            curY = 0;
        }
    }

    private int[] calculateRowExtremes(int page) {
        if (this.table == null || this.pf == null) {
            return null;
        }
        int[] extr = new int[]{0, 0};
        int imgH = (int)this.pf.getImageableHeight();
        int curY = 0;
        int curP = 0;
        curY += (int)(this.scale * (float)this.table.getTableHeader().getHeight());
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if ((curY += (int)(this.scale * (float)this.table.getRowHeight(i))) > imgH) {
                ++curP;
                if (this.table.getValueAt(--i, 0) instanceof TableSubHeaderObject) {
                    --i;
                }
                if (curP == page) {
                    extr[0] = i;
                } else if (curP > page) {
                    extr[1] = i - 1;
                    return extr;
                }
                curY = 0;
            }
            if (i != this.table.getRowCount() - 1) continue;
            extr[1] = i;
        }
        return extr;
    }

    private int calcFirstColWidth(Graphics graphics) {
        if (this.table == null) {
            return 200;
        }
        int cw = 0;
        int rowW = 0;
        Graphics2D g2d = (Graphics2D)graphics;
        String val = (String)this.table.getTableHeader().getColumnModel().getColumn(0).getHeaderValue();
        cw = (int)(this.scale * (float)g2d.getFontMetrics(this.table.getTableHeader().getFont()).stringWidth(val));
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Object rv = this.table.getValueAt(i, 0);
            if (!(rv instanceof String)) continue;
            val = (String)rv;
            rowW = (int)(this.scale * (float)g2d.getFontMetrics(this.table.getFont()).stringWidth(val));
            if (rowW <= cw) continue;
            cw = rowW;
        }
        return cw + 40;
    }

    private void renderPage(Graphics graphics, int[] rowExt) {
        if (this.table == null || this.pf == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setStroke(new BasicStroke(0.6f));
        int ix = (int)this.pf.getImageableX();
        int iy = (int)this.pf.getImageableY();
        int iw = (int)this.pf.getImageableWidth();
        int curY = 0;
        Font normF = this.table.getFont().deriveFont(0, (int)(this.scale * (float)this.table.getFont().getSize()));
        Font boldF = this.table.getFont().deriveFont(1, (int)(this.scale * (float)(this.table.getFont().getSize() + 2)));
        if (rowExt[0] == 0) {
            int tw = 0;
            String val = (String)this.table.getTableHeader().getColumnModel().getColumn(0).getHeaderValue();
            tw = (int)(this.scale * (float)g2d.getFontMetrics(this.table.getTableHeader().getFont()).stringWidth(val));
            int tx = ix + (this.firstColWidth - tw) / 2;
            curY = iy + (int)(this.scale * (float)this.table.getTableHeader().getHeight());
            g2d.setFont(normF);
            g2d.drawString(val, tx, curY - g2d.getFontMetrics().getDescent());
            val = (String)this.table.getTableHeader().getColumnModel().getColumn(1).getHeaderValue();
            tw = (int)(this.scale * (float)g2d.getFontMetrics(this.table.getTableHeader().getFont()).stringWidth(val));
            tx = ix + this.firstColWidth + (iw - this.firstColWidth - tw) / 2;
            g2d.drawString(val, tx, curY - g2d.getFontMetrics().getDescent());
            g2d.drawLine(ix, curY, ix + iw, curY);
        } else {
            curY += iy;
        }
        boolean gray = true;
        Color bg = new Color(236, 236, 236);
        int th = 0;
        for (int i = rowExt[0]; i <= rowExt[1] && i < this.table.getRowCount(); ++i) {
            Object rv = this.table.getValueAt(i, 0);
            th = (int)(this.scale * (float)this.table.getRowHeight(i));
            curY += th;
            if (rv instanceof String) {
                if (gray) {
                    g2d.setColor(bg);
                    g2d.fillRect(ix, curY - th, iw, th);
                }
                gray = !gray;
                g2d.setColor(Color.BLACK);
                g2d.drawLine(ix, curY - th, ix + iw, curY - th);
                g2d.setFont(normF);
                g2d.drawString((String)rv, ix + 4, curY - g2d.getFontMetrics().getDescent());
                rv = this.table.getValueAt(i, 1);
                g2d.drawString((String)rv, ix + this.firstColWidth, curY - g2d.getFontMetrics().getDescent());
                continue;
            }
            if (!(rv instanceof TableSubHeaderObject)) continue;
            if (i != 0) {
                g2d.drawLine(ix, curY - th, ix + iw, curY - th);
            }
            g2d.setFont(boldF);
            TableSubHeaderObject tsho = (TableSubHeaderObject)rv;
            g2d.drawString(tsho.toString(), ix + 4, curY - g2d.getFontMetrics().getDescent() - 2);
            gray = true;
        }
    }
}

