/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.AnnotationTableListSelectionListener;
import mpi.eudico.client.annotator.grid.GridRenderer;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.grid.GridViewerPopupMenu;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public abstract class AbstractGridViewer
extends AbstractViewer {
    protected GridViewerPopupMenu popup;
    private JScrollPane scrollPane;
    protected AnnotationTable table;
    protected GridViewerTableModel dataModel;
    private int lastRowIndex = -1;
    boolean isCreatingAnnotation = false;
    protected static final Logger LOG = Logger.getLogger(GridViewer.class.getName());

    public AbstractGridViewer(AnnotationTable table) {
        this.table = table;
        this.dataModel = (GridViewerTableModel)table.getModel();
        this.initTable();
        this.placeTable();
        this.popup = new GridViewerPopupMenu(table);
        this.updateLocale();
    }

    protected void initTable() {
        this.table.setDefaultRenderer(Object.class, this.createTableCellRenderer());
        this.setTableListener();
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                    AbstractGridViewer.this.popup.show(AbstractGridViewer.this.table, e.getPoint().x, e.getPoint().y);
                }
            }
        });
        this.table.setFont(Constants.DEFAULTFONT);
        this.table.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
    }

    protected TableCellRenderer createTableCellRenderer() {
        return new GridRenderer(this, this.dataModel);
    }

    private void placeTable() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.scrollPane, "Center");
    }

    public Dimension getMinimumSize() {
        return this.table.getPreferredScrollableViewportSize();
    }

    public Dimension getPreferredSize() {
        return this.table.getPreferredScrollableViewportSize();
    }

    public void updateSelection() {
        this.repaint();
    }

    public void updateLocale() {
        this.table.updateLocale();
        if (this.popup != null) {
            this.popup.updateLocale();
        }
        this.repaint();
    }

    protected void setTableListener() {
        this.table.getSelectionModel().addListSelectionListener(new AnnotationTableListSelectionListener(this, this.table));
    }

    private void correctLastRowIndex() {
        long mediatime;
        int annSize = this.dataModel.getRowCount();
        if (annSize == 0) {
            this.lastRowIndex = 0;
        }
        if ((mediatime = this.getMediaTime()) == 0L) {
            this.lastRowIndex = 0;
            return;
        }
        if (mediatime >= this.getMediaDuration()) {
            this.lastRowIndex = annSize - 1;
            return;
        }
        int annotationColumn = this.dataModel.findColumn("ColumnAnnotation");
        AnnotationCore aa = null;
        for (int i = 0; i < annSize; ++i) {
            aa = (AnnotationCore)this.dataModel.getValueAt(i, annotationColumn);
            if (mediatime < aa.getBeginTimeBoundary() || mediatime >= aa.getEndTimeBoundary()) continue;
            this.lastRowIndex = i;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollIfNeeded() {
        if (this.lastRowIndex != -1) {
            if (this.lastRowIndex >= this.table.getRowCount()) {
                this.lastRowIndex = this.table.getRowCount() - 1;
            }
            AnnotationTable annotationTable = this.table;
            synchronized (annotationTable) {
                Rectangle viewportRectangle = this.scrollPane.getViewport().getViewRect();
                Rectangle tableRectangle = this.table.getCellRect(this.lastRowIndex, 0, true);
                if (!viewportRectangle.contains(tableRectangle)) {
                    tableRectangle.height = viewportRectangle.height - tableRectangle.height;
                    this.table.scrollRectToVisible(tableRectangle);
                }
            }
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        this.doUpdate();
        this.table.repaint();
    }

    protected void doUpdate() {
        this.correctLastRowIndex();
        this.scrollIfNeeded();
        this.table.adjustAnnotationColumns();
    }

    public void setBackground(Color color) {
        this.scrollPane.getViewport().setBackground(color);
        super.setBackground(color);
    }

    public int getFontSize() {
        return this.table.getFontSize();
    }

    public void setFontSize(int size) {
        if (this.popup != null) {
            this.popup.setFontSize(size);
        }
    }
}

