/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class AnnotationTableCellRenderer
implements TableCellRenderer {
    protected static final Border marginBorder = BorderFactory.createEmptyBorder(0, 1, 0, 3);
    protected final JLabel label = new JLabel(){

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    };

    public AnnotationTableCellRenderer() {
        this.label.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        AnnotationTableCellRenderer.setComponentLayout(this.label, table, isSelected);
        AnnotationTableCellRenderer.setAlignment(this.label, table.getColumnName(column));
        String renderedText = AnnotationTableCellRenderer.getRenderedText(value);
        this.label.setText(renderedText);
        if (!"".equals(renderedText)) {
            this.label.setToolTipText(renderedText);
        }
        return this.label;
    }

    protected static void setAlignment(JLabel label, String columnName) {
        if ("ColumnCount".equals(columnName) || "ColumnLeftContext".equals(columnName) || "ColumnBeginTime".equals(columnName) || "ColumnEndTime".equals(columnName) || "ColumnDuration".equals(columnName)) {
            label.setHorizontalAlignment(4);
        } else {
            label.setHorizontalAlignment(2);
        }
    }

    protected static void setComponentLayout(JComponent component, JTable table, boolean isSelected) {
        component.setFont(table.getFont());
        component.setBorder(marginBorder);
        component.setBackground(isSelected ? Constants.SELECTIONCOLOR : table.getBackground());
    }

    protected static String getRenderedText(Object value) {
        return value instanceof AnnotationCore ? ((AnnotationCore)value).getValue() : (value instanceof String ? (String)value : "");
    }
}

