/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.gui.EditCVPanel;
import mpi.eudico.util.ControlledVocabulary;

public abstract class AbstractEditCVDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final int DEFAULT_MINIMUM_HEIGHT = 500;
    private static final int DEFAULT_MINIMUM_WIDTH = 550;
    protected EditCVPanel cvEditorPanel;
    protected JButton addCVButton;
    protected JButton changeCVButton;
    protected JButton closeDialogButton;
    protected JButton deleteCVButton;
    protected JComboBox cvComboBox;
    protected JLabel currentCVLabel;
    protected JLabel cvDescLabel;
    protected JLabel cvNameLabel;
    protected JLabel titleLabel;
    protected JPanel cvButtonPanel;
    protected JPanel cvPanel;
    protected JTextArea cvDescArea;
    protected JTextField cvNameTextField;
    protected String cvContainsEntriesMessage = "contains entries.";
    protected String cvInvalidNameMessage = "Invalid name.";
    protected String cvNameExistsMessage = "Name exists already.";
    protected String deleteQuestion = "delete anyway?";
    protected String oldCVDesc;
    protected String oldCVName;
    protected int minimumHeight;
    protected int minimumWidth;
    private final boolean multipleCVs;

    public AbstractEditCVDialog(Frame parent, boolean modal, boolean multipleCVs) {
        this(parent, modal, multipleCVs, new EditCVPanel());
    }

    public AbstractEditCVDialog(Frame parent, boolean modal, boolean multipleCVs, EditCVPanel cvEditorPanel) {
        super(parent, modal);
        this.cvEditorPanel = cvEditorPanel;
        this.multipleCVs = multipleCVs;
        this.minimumHeight = 500;
        this.minimumWidth = 550;
        this.makeLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.closeDialogButton) {
            this.closeDialog();
        } else if (source == this.addCVButton) {
            this.addCV();
        } else if (source == this.changeCVButton) {
            this.changeCV();
        } else if (source == this.deleteCVButton) {
            this.deleteCV();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.cvComboBox) {
            if (ie.getStateChange() == 1) {
                this.cvEditorPanel.setControlledVocabulary((ControlledVocabulary)this.cvComboBox.getSelectedItem());
            }
            this.updateCVButtons();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        AbstractEditCVDialog dialog = new AbstractEditCVDialog((Frame)frame, false, false){

            protected List getCVList() {
                return new ArrayList();
            }
        };
        dialog.updateComboBox();
        dialog.pack();
        dialog.setVisible(true);
    }

    protected abstract List getCVList();

    protected void setPosition() {
        this.pack();
        this.setSize(Math.max(this.getSize().width, 550), Math.max(this.getSize().height, 500));
        this.setLocationRelativeTo(this.getParent());
    }

    protected void addCV() {
        String name = this.cvNameTextField.getText();
        if ((name = name.trim()).length() == 0) {
            this.showWarningDialog(this.cvInvalidNameMessage);
            return;
        }
        if (this.cvExists(name)) {
            this.showWarningDialog(this.cvNameExistsMessage);
            return;
        }
        this.addCV(name);
    }

    protected void addCV(String name) {
        ControlledVocabulary cv = new ControlledVocabulary(name, "");
        this.cvComboBox.addItem(cv);
        this.cvEditorPanel.setControlledVocabulary(cv);
    }

    protected void changeCV() {
        ControlledVocabulary cv = (ControlledVocabulary)this.cvComboBox.getSelectedItem();
        if (cv == null) {
            return;
        }
        String name = this.cvNameTextField.getText();
        String desc = this.cvDescArea.getText();
        if (name != null && (name = name.trim()).length() < 1) {
            this.showWarningDialog(this.cvInvalidNameMessage);
            this.cvNameTextField.setText(this.oldCVName);
            return;
        }
        if (this.oldCVName != null && !this.oldCVName.equals(name)) {
            if (this.cvExists(name)) {
                this.showWarningDialog(this.cvNameExistsMessage);
                return;
            }
            this.changeCV(cv, name, desc);
        } else if (this.oldCVDesc == null && desc != null && desc.length() > 0 || this.oldCVDesc != null && (desc == null || desc.length() == 0) || !this.oldCVDesc.equals(desc)) {
            this.changeCV(cv, null, desc);
        }
    }

    protected void changeCV(ControlledVocabulary cv, String name, String description) {
        cv.setDescription(description);
        if (name != null) {
            cv.setName(name);
            this.cvEditorPanel.setControlledVocabulary(cv);
        }
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected boolean cvExists(String name) {
        boolean nameExists = false;
        for (int i = 0; i < this.cvComboBox.getItemCount(); ++i) {
            if (!((ControlledVocabulary)this.cvComboBox.getItemAt(i)).getName().equals(name)) continue;
            nameExists = true;
            break;
        }
        return nameExists;
    }

    protected void deleteCV() {
        String mes;
        ControlledVocabulary conVoc = (ControlledVocabulary)this.cvComboBox.getSelectedItem();
        if (conVoc.getEntries().length > 0 && !this.showConfirmDialog(mes = this.cvContainsEntriesMessage + " " + this.deleteQuestion)) {
            return;
        }
        this.deleteCV(conVoc);
    }

    protected void deleteCV(ControlledVocabulary cv) {
        this.cvComboBox.removeItem(cv);
        if (this.cvComboBox.getItemCount() > 0) {
            this.cvComboBox.setSelectedIndex(0);
        } else {
            this.cvEditorPanel.setControlledVocabulary(null);
        }
    }

    protected void makeLayout() {
        this.cvPanel = new JPanel();
        this.currentCVLabel = new JLabel();
        this.cvComboBox = new JComboBox();
        this.cvNameLabel = new JLabel();
        this.cvNameTextField = new JTextField();
        this.cvDescLabel = new JLabel();
        this.cvDescArea = new JTextArea();
        this.cvButtonPanel = new JPanel();
        this.addCVButton = new JButton();
        this.changeCVButton = new JButton();
        this.changeCVButton.setEnabled(false);
        this.deleteCVButton = new JButton();
        this.deleteCVButton.setEnabled(false);
        JPanel closeButtonPanel = new JPanel();
        this.closeDialogButton = new JButton();
        JPanel titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AbstractEditCVDialog.this.closeDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)titlePanel, gridBagConstraints);
        this.cvPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.cvPanel.add((Component)this.currentCVLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.cvPanel.add((Component)this.cvComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.cvPanel.add((Component)this.cvNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.cvPanel.add((Component)this.cvNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.cvPanel.add((Component)this.cvDescLabel, gridBagConstraints);
        this.cvDescArea.setLineWrap(true);
        this.cvDescArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.cvPanel.add((Component)new JScrollPane(this.cvDescArea), gridBagConstraints);
        this.cvButtonPanel.setLayout(new GridLayout(0, 1, 6, 6));
        this.addCVButton.addActionListener(this);
        this.cvButtonPanel.add(this.addCVButton);
        this.changeCVButton.addActionListener(this);
        this.cvButtonPanel.add(this.changeCVButton);
        this.deleteCVButton.addActionListener(this);
        this.cvButtonPanel.add(this.deleteCVButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = insets;
        this.cvPanel.add((Component)this.cvButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        if (this.multipleCVs) {
            this.getContentPane().add((Component)this.cvPanel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.cvEditorPanel, gridBagConstraints);
        closeButtonPanel.setLayout(new GridLayout(1, 1, 0, 2));
        this.closeDialogButton.addActionListener(this);
        closeButtonPanel.add(this.closeDialogButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)closeButtonPanel, gridBagConstraints);
        InputMap iMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap aMap = ((JComponent)this.getContentPane()).getActionMap();
        if (iMap != null && aMap != null) {
            String esc = "Esc";
            String enter = "Enter";
            iMap.put(KeyStroke.getKeyStroke(27, 0), "Esc");
            iMap.put(KeyStroke.getKeyStroke(10, 0), "Enter");
            aMap.put("Esc", new EscapeAction());
            aMap.put("Enter", new EnterAction());
        }
    }

    protected boolean showConfirmDialog(String message) {
        int confirm = JOptionPane.showConfirmDialog(this, message, "Warning", 0);
        return confirm == 0;
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning", 2);
    }

    protected void updateCVButtons() {
        ControlledVocabulary cv = (ControlledVocabulary)this.cvComboBox.getSelectedItem();
        this.changeCVButton.setEnabled(cv != null);
        this.deleteCVButton.setEnabled(cv != null);
        this.cvNameTextField.setText(cv != null ? cv.getName() : "");
        this.cvDescArea.setText(cv != null ? cv.getDescription() : "");
        this.oldCVName = cv != null ? cv.getName() : null;
        this.oldCVDesc = cv != null ? cv.getDescription() : null;
    }

    protected void updateComboBox() {
        this.cvComboBox.removeItemListener(this);
        List v = this.getCVList();
        this.cvComboBox.removeAllItems();
        for (int i = 0; i < v.size(); ++i) {
            this.cvComboBox.addItem(v.get(i));
        }
        if (v.size() > 0) {
            this.cvComboBox.setSelectedIndex(0);
            this.cvEditorPanel.setControlledVocabulary((ControlledVocabulary)this.cvComboBox.getItemAt(0));
        }
        this.updateCVButtons();
        this.cvComboBox.addItemListener(this);
    }

    protected void updateLabels() {
        this.closeDialogButton.setText("Close");
        this.deleteCVButton.setText("Delete");
        this.changeCVButton.setText("Change");
        this.addCVButton.setText("Add");
        this.cvNameLabel.setText("Name");
        this.cvDescLabel.setText("Description");
        this.currentCVLabel.setText("Current");
    }

    protected class EscapeAction
    extends AbstractAction {
        protected EscapeAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            AbstractEditCVDialog.this.closeDialog();
        }
    }

    protected class EnterAction
    extends AbstractAction {
        protected EnterAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            Component com = AbstractEditCVDialog.this.getFocusOwner();
            if (com instanceof JButton) {
                ((JButton)com).doClick();
            }
        }
    }
}

