/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.util.FavoriteColorPanel;
import mpi.eudico.util.CVEntry;

public class CVEntryOptionsDialog
extends JDialog
implements ActionListener,
KeyListener {
    private CVEntry origEntry;
    private CVEntry copyEntry;
    private JPanel colorPreviewPanel;
    private JButton colorButton;
    private JButton resetColorButton;
    private JTextField keyTextField;
    private JButton revertKeyButton;
    private JButton resetKeyButton;
    private JButton changeButton;
    private JButton cancelButton;
    private int newKeyCode = -1;

    public CVEntryOptionsDialog(Dialog owner, boolean modal, CVEntry origEntry) throws HeadlessException {
        this(owner, "", modal, origEntry);
    }

    public CVEntryOptionsDialog(Dialog owner, String title, boolean modal, CVEntry origEntry) throws HeadlessException {
        super(owner, title, modal);
        if (origEntry == null) {
            throw new IllegalArgumentException("The entry is null");
        }
        this.origEntry = origEntry;
        this.copyEntry = new CVEntry(origEntry);
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JPanel prefPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setText(ElanLocale.getString("EditCVDialog.Label.Value") + ": " + this.copyEntry.getValue());
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)titleLabel, gbc);
        prefPanel.setBorder(new TitledBorder(ElanLocale.getString("EditCVDialog.Label.EntryPreferences")));
        prefPanel.setLayout(new GridBagLayout());
        JLabel colorLabel = new JLabel(ElanLocale.getString("EditCVDialog.Label.EntryColor"));
        this.colorPreviewPanel = new JPanel();
        this.colorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.colorPreviewPanel.setBackground(Color.WHITE);
        this.colorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.colorButton.addActionListener(this);
        this.resetColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetColorButton.addActionListener(this);
        this.colorPreviewPanel.setPreferredSize(new Dimension(this.colorButton.getPreferredSize().height, this.colorButton.getPreferredSize().height));
        this.colorPreviewPanel.setMinimumSize(new Dimension(this.colorButton.getPreferredSize().height, this.colorButton.getPreferredSize().height));
        if (this.copyEntry.getPrefColor() != null) {
            this.colorPreviewPanel.setBackground(this.copyEntry.getPrefColor());
        }
        JLabel keyLabel = new JLabel(ElanLocale.getString("EditCVDialog.Label.EntryKey"));
        this.keyTextField = new JTextField(10);
        this.keyTextField.setEditable(true);
        if (this.copyEntry.getShortcutKeyCode() >= 0) {
            this.keyTextField.setText(KeyEvent.getKeyText(this.copyEntry.getShortcutKeyCode()));
        }
        this.keyTextField.addKeyListener(this);
        this.revertKeyButton = new JButton(ElanLocale.getString("EditCVDialog.Label.EntryKeyRevert"));
        this.revertKeyButton.addActionListener(this);
        this.resetKeyButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetKeyButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        prefPanel.add((Component)colorLabel, gbc);
        gbc.gridx = 1;
        prefPanel.add((Component)this.colorPreviewPanel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        prefPanel.add((Component)this.colorButton, gbc);
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetColorButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        prefPanel.add((Component)keyLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        prefPanel.add((Component)this.keyTextField, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        prefPanel.add((Component)this.revertKeyButton, gbc);
        gbc.fill = 0;
        gbc.gridx = 4;
        prefPanel.add((Component)this.resetKeyButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)prefPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.changeButton = new JButton();
        this.changeButton.setText(ElanLocale.getString("Button.Apply"));
        this.changeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.changeButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                CVEntryOptionsDialog.this.copyEntry = null;
                CVEntryOptionsDialog.this.doClose();
            }
        });
    }

    private void postInit() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void selectColor() {
        Color newColor;
        Color oldColor = this.copyEntry.getPrefColor();
        if (oldColor == null) {
            oldColor = Color.WHITE;
        }
        final JColorChooser chooser = new JColorChooser(oldColor);
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        AbstractColorChooserPanel[] panels2 = new AbstractColorChooserPanel[panels.length + 1];
        FavoriteColorPanel fcp = new FavoriteColorPanel();
        panels2[0] = fcp;
        for (int i = 0; i < panels.length; ++i) {
            panels2[i + 1] = panels[i];
        }
        chooser.setChooserPanels(panels2);
        Map oldColors = null;
        Object stored = Preferences.get("FavoriteColors", null);
        if (stored instanceof Map) {
            oldColors = (Map)stored;
            Color[] favColors = fcp.getColors();
            for (String key : oldColors.keySet()) {
                Color val = (Color)oldColors.get(key);
                try {
                    int index = Integer.valueOf(key);
                    if (index >= favColors.length) continue;
                    favColors[index] = val;
                }
                catch (NumberFormatException nfe) {}
            }
        }
        AbstractAction aa = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                this.putValue("Default", chooser.getColor());
            }
        };
        JDialog cd = JColorChooser.createDialog(this, ElanLocale.getString("ColorChooser.Title"), true, chooser, aa, null);
        cd.setVisible(true);
        HashMap<String, Color> colMap = new HashMap<String, Color>();
        Color[] colors = fcp.getColors();
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] == null) continue;
            colMap.put(String.valueOf(i), colors[i]);
        }
        if (colMap.size() > 0 || oldColors != null) {
            Preferences.set("FavoriteColors", colMap, null);
        }
        if ((newColor = (Color)aa.getValue("Default")) != null) {
            this.colorPreviewPanel.setBackground(newColor);
            this.copyEntry.setPrefColor(newColor);
        }
    }

    private void revertKey() {
        if (this.origEntry.getShortcutKeyCode() == -1) {
            this.copyEntry.setShortcutKeyCode(-1);
            this.keyTextField.setText("");
        } else {
            this.copyEntry.setShortcutKeyCode(this.origEntry.getShortcutKeyCode());
            this.keyTextField.setText(KeyEvent.getKeyText(this.origEntry.getShortcutKeyCode()));
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isEntryChanged() {
        if (this.copyEntry.getPrefColor() != null && this.origEntry.getPrefColor() == null) {
            return true;
        }
        if (this.copyEntry.getPrefColor() == null && this.origEntry.getPrefColor() != null) {
            return true;
        }
        if (this.copyEntry.getPrefColor() != null && !this.copyEntry.getPrefColor().equals(this.origEntry.getPrefColor())) {
            return true;
        }
        return this.copyEntry.getShortcutKeyCode() != this.origEntry.getShortcutKeyCode();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeButton) {
            if (!this.isEntryChanged()) {
                this.copyEntry = null;
            }
            this.doClose();
        } else if (e.getSource() == this.cancelButton) {
            this.copyEntry = null;
            this.doClose();
        } else if (e.getSource() == this.colorButton) {
            this.selectColor();
        } else if (e.getSource() == this.resetColorButton) {
            this.colorPreviewPanel.setBackground(Color.WHITE);
            this.copyEntry.setPrefColor(null);
        } else if (e.getSource() == this.revertKeyButton) {
            this.revertKey();
        } else if (e.getSource() == this.resetKeyButton) {
            this.newKeyCode = 0;
            this.copyEntry.setShortcutKeyCode(this.newKeyCode);
            this.keyTextField.setText("");
        }
    }

    public CVEntry getCVEntry() {
        return this.copyEntry;
    }

    public void keyPressed(KeyEvent ke) {
        this.keyTextField.setText("");
        this.newKeyCode = ke.getKeyCode();
    }

    public void keyReleased(KeyEvent ke) {
        if (this.newKeyCode > -1) {
            this.copyEntry.setShortcutKeyCode(this.newKeyCode);
            this.keyTextField.setText(KeyEvent.getKeyText(this.newKeyCode));
        }
    }

    public void keyTyped(KeyEvent ke) {
    }
}

