/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractEditCVDialog;
import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.ElanEditCVPanel;
import mpi.eudico.client.annotator.gui.EscCloseAction;
import mpi.eudico.client.annotator.gui.GetExternalCVURLDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV01Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV01Parser;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class EditCVDialog
extends AbstractEditCVDialog
implements ActionListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(EditCVDialog.class.getName());
    private JButton importButton;
    private JButton externalCVButton;
    private TranscriptionImpl transcription;
    private final int SKIP = 0;
    private final int REPLACE = 1;
    private final int RENAME = 2;
    private final int MERGE = 3;

    public EditCVDialog(Transcription transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true, true, new ElanEditCVPanel());
        this.transcription = (TranscriptionImpl)transcription;
        this.addCloseActions();
        this.updateLabels();
        this.setPosition();
        this.updateComboBox();
        this.cvNameTextField.requestFocus();
        this.postInit();
    }

    protected void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.importButton) {
            this.importCV();
        } else if (source == this.externalCVButton) {
            this.connectExternalCV();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void updateLocale() {
        ((ElanEditCVPanel)this.cvEditorPanel).updateLabels();
        this.updateLabels();
    }

    protected List getCVList() {
        return this.transcription.getControlledVocabularies();
    }

    protected void addCV(String name) {
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddCV");
        Object[] args = new Object[]{name, this.cvDescArea.getText()};
        com.execute(this.transcription, args);
        this.updateComboBox();
        this.cvComboBox.setSelectedIndex(this.cvComboBox.getItemCount() - 1);
    }

    protected void changeCV(ControlledVocabulary cv, String name, String description) {
        Map curCVPref;
        HashMap cvPrefs = (HashMap)Preferences.get("CV.Prefs", this.transcription);
        if (cvPrefs != null && (curCVPref = (Map)cvPrefs.remove(cv.getName())) != null) {
            cvPrefs.put(name, curCVPref);
            Preferences.set("CV.Prefs", cvPrefs, this.transcription, true, false);
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ChangeCV");
        Object[] args = new Object[]{this.oldCVName, description != null ? description : this.oldCVDesc, name != null ? name : this.oldCVName, description};
        com.execute(this.transcription, args);
        this.updateComboBox();
        this.cvComboBox.setSelectedItem(cv);
    }

    protected void deleteCV() {
        String mes;
        ControlledVocabulary conVoc = (ControlledVocabulary)this.cvComboBox.getSelectedItem();
        if (this.transcription.getTiersWithCV(conVoc.getName()).size() > 0 && !this.showConfirmDialog(mes = ElanLocale.getString("EditCVDialog.Message.CVInUse") + "\n" + ElanLocale.getString("EditCVDialog.Message.CVConfirmDelete"))) {
            return;
        }
        this.deleteCV(conVoc);
    }

    protected void deleteCV(ControlledVocabulary cv) {
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.DeleteCV");
        com.execute(this.transcription, new Object[]{cv});
        this.updateComboBox();
        if (this.cvComboBox.getItemCount() == 0) {
            this.cvEditorPanel.setControlledVocabulary(null);
        }
    }

    protected void makeLayout() {
        super.makeLayout();
        this.importButton = new JButton();
        this.importButton.addActionListener(this);
        this.cvButtonPanel.add(this.importButton);
        this.externalCVButton = new JButton();
        this.externalCVButton.addActionListener(this);
        this.cvButtonPanel.add(this.externalCVButton);
    }

    protected boolean showConfirmDialog(String message) {
        int confirm = JOptionPane.showConfirmDialog(this, message, ElanLocale.getString("Message.Warning"), 0);
        return confirm == 0;
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    protected void updateLabels() {
        this.closeDialogButton.setText(ElanLocale.getString("EditCVDialog.Button.Close"));
        this.deleteCVButton.setText(ElanLocale.getString("Button.Delete"));
        this.changeCVButton.setText(ElanLocale.getString("Button.Change"));
        this.addCVButton.setText(ElanLocale.getString("Button.Add"));
        this.importButton.setText(ElanLocale.getString("Button.Import"));
        this.cvDescLabel.setText(ElanLocale.getString("EditCVDialog.Label.CVDescription"));
        this.cvNameLabel.setText(ElanLocale.getString("EditCVDialog.Label.Name"));
        this.cvPanel.setBorder(new TitledBorder(ElanLocale.getString("EditCVDialog.Label.CV")));
        this.currentCVLabel.setText(ElanLocale.getString("EditCVDialog.Label.Current"));
        this.titleLabel.setText(ElanLocale.getString("EditCVDialog.Title"));
        this.setTitle(ElanLocale.getString("EditCVDialog.Title"));
        this.cvNameExistsMessage = ElanLocale.getString("EditCVDialog.Message.CVExists");
        this.cvInvalidNameMessage = ElanLocale.getString("EditCVDialog.Message.CVValidName");
        this.cvContainsEntriesMessage = ElanLocale.getString("EditCVDialog.Message.CVInUse");
        this.deleteQuestion = ElanLocale.getString("EditCVDialog.Message.CVConfirmDelete");
        this.externalCVButton.setText(ElanLocale.getString("Button.externalCV"));
    }

    protected void closeDialog() {
        if (this.cvEditorPanel instanceof ElanEditCVPanel && ((ElanEditCVPanel)this.cvEditorPanel).isPrefsChanged()) {
            HashMap cvPrefs = (HashMap)Preferences.get("CV.Prefs", this.transcription);
            if (cvPrefs == null) {
                cvPrefs = new HashMap();
            }
            String color = "Color";
            String keyCode = "KeyCode";
            for (int i = 0; i < this.transcription.getControlledVocabularies().size(); ++i) {
                HashMap<String, HashMap<String, Color>> curCV = null;
                ControlledVocabulary cv = (ControlledVocabulary)this.transcription.getControlledVocabularies().get(i);
                curCV = (HashMap<String, HashMap<String, Color>>)cvPrefs.get(cv.getName());
                boolean anyPref = false;
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    HashMap<String, Color> curEnt = null;
                    CVEntry cve = entries[j];
                    if (cve.getPrefColor() != null || cve.getShortcutKeyCode() > -1) {
                        anyPref = true;
                        if (curCV == null) {
                            curCV = new HashMap<String, HashMap<String, Color>>();
                            cvPrefs.put(cv.getName(), curCV);
                        }
                        if ((curEnt = (HashMap<String, Color>)curCV.get(cve.getValue())) == null) {
                            curEnt = new HashMap<String, Color>(3);
                            curCV.put(cve.getValue(), curEnt);
                        }
                        if (cve.getPrefColor() != null) {
                            curEnt.put(color, cve.getPrefColor());
                        } else {
                            curEnt.remove(color);
                        }
                        if (cve.getShortcutKeyCode() > -1) {
                            curEnt.put(keyCode, (Color)((Object)Integer.valueOf(cve.getShortcutKeyCode())));
                            continue;
                        }
                        curEnt.remove(keyCode);
                        continue;
                    }
                    if (curCV == null) continue;
                    curCV.remove(cve.getValue());
                }
                if (anyPref || curCV == null) continue;
                cvPrefs.remove(curCV);
            }
            if (cvPrefs.size() == 0) {
                Preferences.set("CV.Prefs", null, this.transcription, true);
            } else {
                Preferences.set("CV.Prefs", cvPrefs, this.transcription, true, false);
            }
        }
        super.closeDialog();
    }

    private File getImportFile() {
        String dir = (String)Preferences.get("LastUsedEAFDir", null);
        if (dir == null && (dir = new File(this.transcription.getName()).getParent()) == null) {
            dir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle(ElanLocale.getString("Button.Import"));
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(3));
        chooser.setFileFilter(ElanFileFilter.createFileFilter(4));
        chooser.setFileFilter(ElanFileFilter.createFileFilter(20));
        JTextArea textAr = new JTextArea(ElanLocale.getString("EditCVDialog.Message.Browse"));
        textAr.setBackground(chooser.getBackground());
        textAr.setWrapStyleWord(true);
        textAr.setLineWrap(true);
        textAr.setEditable(false);
        textAr.setPreferredSize(new Dimension(160, 100));
        textAr.setMargin(new Insets(5, 5, 5, 5));
        chooser.setAccessory(textAr);
        int option = chooser.showOpenDialog(this);
        if (option == 1) {
            return null;
        }
        if (option == 0) {
            File impFile = chooser.getSelectedFile();
            String filePath = impFile.getAbsolutePath();
            if (!impFile.exists() || impFile.isDirectory()) {
                StringBuffer strMessage = new StringBuffer(ElanLocale.getString("Menu.Dialog.Message1"));
                strMessage.append(impFile.getName());
                strMessage.append(ElanLocale.getString("Menu.Dialog.Message2"));
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this, strMessage, strError, 0);
                return null;
            }
            if (!(filePath.toLowerCase().endsWith(".etf") || filePath.toLowerCase().endsWith(".eaf") || filePath.toLowerCase().endsWith(".txt") || filePath.toLowerCase().endsWith(".csv"))) {
                StringBuffer strMessage = new StringBuffer(ElanLocale.getString("Menu.Dialog.Message1"));
                strMessage.append(impFile.getName());
                strMessage.append(ElanLocale.getString("Menu.Dialog.Message3"));
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this, strMessage, strError, 0);
                return null;
            }
            Preferences.set("LastUsedEAFDir", impFile.getParent(), null);
            return impFile;
        }
        return null;
    }

    private void addCV(ControlledVocabulary conVoc) {
        if (conVoc == null) {
            return;
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddCV");
        Object[] args = new Object[]{conVoc};
        com.execute(this.transcription, args);
    }

    private void importCV() {
        Object cvPrefObj;
        File importFile = this.getImportFile();
        if (importFile == null) {
            return;
        }
        ArrayList allCVs = null;
        String fileName = importFile.getAbsolutePath();
        if (fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".csv")) {
            try {
                DelimitedTextReader reader = new DelimitedTextReader(importFile);
                allCVs = this.parseTextFile(importFile, reader.getDelimiter());
            }
            catch (FileNotFoundException e) {
                this.showWarningDialog(e.getMessage() + ":" + importFile.getAbsolutePath());
                LOG.warning(e.getMessage() + ":" + importFile.getAbsolutePath());
            }
            catch (IOException e) {
                this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.ReadError") + importFile.getAbsolutePath());
                LOG.warning("Error while reading the file: " + e.getMessage());
                return;
            }
        } else {
            EAFSkeletonParser skelParser = null;
            try {
                skelParser = new EAFSkeletonParser(importFile.getAbsolutePath());
                skelParser.parse();
                allCVs = skelParser.getControlledVocabularies();
            }
            catch (ParseException pe) {
                this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.ReadError") + importFile.getAbsolutePath());
                LOG.warning("Could not parse the file: " + pe.getMessage());
                return;
            }
        }
        if (allCVs == null || allCVs.size() == 0) {
            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.NoCVFound"));
            return;
        }
        Map preferences = Preferences.loadPreferencesForFile(importFile.getAbsolutePath());
        HashMap importPrefs = null;
        if (preferences != null && (cvPrefObj = preferences.get("CV.Prefs")) instanceof HashMap) {
            importPrefs = (HashMap)cvPrefObj;
        }
        String color = "Color";
        String keyCode = "KeyCode";
        ControlledVocabulary cv = null;
        for (int i = 0; i < allCVs.size(); ++i) {
            HashMap hm;
            cv = (ControlledVocabulary)allCVs.get(i);
            if (cv instanceof ExternalCV) continue;
            if (importPrefs != null && (hm = (HashMap)importPrefs.get(cv.getName())) != null) {
                CVEntry[] entries;
                for (CVEntry cve : entries = cv.getEntries()) {
                    Object k;
                    HashMap entMap = (HashMap)hm.get(cve.getValue());
                    if (entMap == null) continue;
                    Object c = entMap.get(color);
                    if (c instanceof Color) {
                        cve.setPrefColor((Color)c);
                    }
                    if (!((k = entMap.get(keyCode)) instanceof Integer)) continue;
                    cve.setShortcutKeyCode((Integer)k);
                }
            }
            if (this.transcription.getControlledVocabulary(cv.getName()) != null) {
                int option = this.showCVQuestionDialog(cv.getName());
                if (option == 1) {
                    this.replaceCV(cv);
                    continue;
                }
                if (option == 2) {
                    String newName;
                    while (this.transcription.getControlledVocabulary(newName = this.showAskNameDialog(cv.getName())) != null) {
                        this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.CVExists"));
                    }
                    if (newName == null || newName.length() == 0) continue;
                    cv.setName(newName);
                    this.addCV(cv);
                    continue;
                }
                if (option != 3) continue;
                this.mergeCVs(cv);
                continue;
            }
            this.addCV(cv);
        }
        this.updateComboBox();
    }

    private ArrayList parseTextFile(File textFile, String delimiter) throws IOException {
        String fileName = textFile.getName();
        int index = fileName.lastIndexOf(46);
        String name = fileName.substring(0, index);
        int lineNumber = 0;
        ControlledVocabulary newCV = new ControlledVocabulary(name);
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(textFile), "UTF-8");
        Scanner scanner = new Scanner(fileReader);
        while (scanner.hasNextLine()) {
            String aLine = scanner.nextLine();
            Scanner line = new Scanner(aLine);
            String value = null;
            String description = null;
            ++lineNumber;
            line.useDelimiter(delimiter);
            if (!line.hasNext()) continue;
            value = line.next();
            if (lineNumber == 1) {
                if (value.contains("\ufffd")) {
                    value = value.replace("\ufffd", "");
                } else if (value.startsWith("\ufeff")) {
                    value = value.replace("\ufeff", "");
                } else if (value.startsWith("\uefbbbf")) {
                    value = value.replace("\uefbbbf", "");
                }
            }
            description = line.hasNext() ? line.next() : value;
            CVEntry entry = new CVEntry();
            entry.setValue(value.trim());
            entry.setDescription(description.trim());
            newCV.addEntry(entry);
        }
        fileReader.close();
        scanner.close();
        ArrayList<ControlledVocabulary> list = new ArrayList<ControlledVocabulary>();
        list.add(newCV);
        return list;
    }

    private void replaceCV(ControlledVocabulary conVoc) {
        String name = conVoc.getName();
        ControlledVocabulary oldCv = this.transcription.getControlledVocabulary(name);
        if (oldCv != null) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ReplaceCV");
            com.execute(this.transcription, new Object[]{oldCv, conVoc});
        }
    }

    private void mergeCVs(ControlledVocabulary conVoc) {
        String name = conVoc.getName();
        ControlledVocabulary oldCv = this.transcription.getControlledVocabulary(name);
        if (oldCv != null) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.MergeCV");
            com.execute(this.transcription, new Object[]{oldCv, conVoc});
        }
    }

    private String showAskNameDialog(String name) {
        String message = ElanLocale.getString("EditCVDialog.Message.NewName") + "\n\n- " + name;
        String newName = JOptionPane.showInputDialog(this, message, ElanLocale.getString("EditCVDialog.Message.Rename"), 3);
        return newName;
    }

    private int showCVQuestionDialog(String cvName) {
        return this.showCVQuestionDialog(cvName, false);
    }

    private int showCVQuestionDialog(String cvName, Boolean forExternalCV) {
        ArrayList<String> optionsArray = new ArrayList<String>();
        optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Skip"));
        optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Replace"));
        if (!forExternalCV.booleanValue()) {
            optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Rename"));
            optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Merge"));
        }
        Object[] options = new String[optionsArray.size()];
        options = optionsArray.toArray(options);
        String message = ElanLocale.getString("EditCVDialog.Message.CVExists") + "\n\n- " + cvName + "\n";
        JOptionPane pane = new JOptionPane(message, 3, -1, null, options);
        pane.createDialog(this, "").setVisible(true);
        Object selValue = pane.getValue();
        for (int i = 0; i < options.length; ++i) {
            if (selValue != options[i]) continue;
            return i;
        }
        return 0;
    }

    protected void addCloseActions() {
        EscCloseAction escAction = new EscCloseAction(this);
        CtrlWCloseAction wAction = new CtrlWCloseAction(this);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap instanceof ComponentInputMap && actionMap != null) {
            String esc = "esc";
            inputMap.put((KeyStroke)escAction.getValue("AcceleratorKey"), esc);
            actionMap.put(esc, escAction);
            String wcl = "cw";
            inputMap.put((KeyStroke)wAction.getValue("AcceleratorKey"), wcl);
            actionMap.put(wcl, wAction);
        }
    }

    private URL getExternalCVURL() {
        String urlString = new String();
        if (this instanceof JDialog) {
            GetExternalCVURLDialog dialog = new GetExternalCVURLDialog(this);
            dialog.setVisible(true);
            urlString = dialog.getExternalCVURLString();
        }
        if (urlString == null) {
            return null;
        }
        try {
            URL remoteURL = new URL(urlString);
            return remoteURL;
        }
        catch (MalformedURLException me) {
            if (urlString.length() == 0) {
                JOptionPane.showMessageDialog(this, "No url was entered. No CV will be loaded.", "Url format error", 0);
            } else {
                JOptionPane.showMessageDialog(this, "Url has an incorrect format. No CV will be loaded.", "Url format error", 0);
            }
            return null;
        }
    }

    private void connectExternalCV() {
        URL externalCVURL = this.getExternalCVURL();
        if (externalCVURL == null) {
            return;
        }
        ECV01Parser ecvParser = null;
        try {
            ecvParser = new ECV01Parser(externalCVURL.toString());
            ecvParser.parse();
        }
        catch (ParseException pe) {
            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.ReadError") + externalCVURL.toString());
            LOG.warning("Could not parse the file: " + pe.getMessage());
            return;
        }
        ArrayList<ControlledVocabulary> allCVs = ecvParser.getControlledVocabularies();
        if (allCVs.size() == 0) {
            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.NoCVFound"));
            return;
        }
        ArrayList<ExternalCV> extCVs = new ArrayList<ExternalCV>(allCVs.size());
        ExternalReferenceImpl eri = new ExternalReferenceImpl(externalCVURL.toString(), 4);
        ExternalCV cv = null;
        for (int i = 0; i < allCVs.size(); ++i) {
            cv = new ExternalCV(allCVs.get(i));
            if (eri != null) {
                try {
                    cv.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    LOG.severe("Could not set the external reference: " + cnse.getMessage());
                }
            }
            extCVs.add(cv);
            if (this.transcription.getControlledVocabulary(cv.getName()) != null) {
                int option = this.showCVQuestionDialog(cv.getName(), true);
                if (option != 1) continue;
                this.replaceCV(cv);
                continue;
            }
            this.addCV(cv);
        }
        String saveDir = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "CVCACHE";
        try {
            new ECV01Encoder().encodeAndSave(extCVs, saveDir, eri);
        }
        catch (IOException ioe) {
            this.showWarningDialog(ElanLocale.getString("LoadExternalCV.Message.WriteError"));
        }
        this.updateComboBox();
    }
}

