/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.im.ImUtil;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class EditTierDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final int ADD = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    private TierImpl tier = null;
    private TierImpl oldParentTier;
    private TranscriptionImpl transcription;
    private String oldTierName;
    private String oldParentTierName;
    private String oldParticipant;
    private LinguisticType oldLingType;
    private Locale oldLocale;
    private Locale[] langs;
    private final String none = "none";
    private int mode = 1;
    private boolean singleEditMode = false;
    private Vector tiers;
    private final JLabel titleLabel = new JLabel();
    private final JLabel selectTierLabel = new JLabel();
    private final JLabel tierNameLabel = new JLabel();
    private final JLabel participantLabel = new JLabel();
    private final JLabel lingTypeLabel = new JLabel();
    private final JLabel parentLabel = new JLabel();
    private final JLabel languageLabel = new JLabel();
    private final JTextField tierNameTextField = new JTextField(30);
    private final JTextField participantTextField = new JTextField(30);
    private final JComboBox lingTypeChoice = new JComboBox();
    private final JComboBox languageChoice = new JComboBox();
    private final JComboBox parentChoice = new JComboBox();
    private final JComboBox currentTiersComboBox = new JComboBox();
    private final JButton changeButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
    private final Frame frame;

    public EditTierDialog(Frame parentFrame, boolean modal, Transcription theTranscription, int editMode, TierImpl tier) {
        super(parentFrame, modal);
        this.frame = parentFrame;
        this.transcription = (TranscriptionImpl)theTranscription;
        if (editMode == 0 || editMode == 1 || editMode == 2) {
            this.mode = editMode;
        }
        this.extractCurrentTiers();
        this.createDialog();
        this.updateForModeAndLocale();
        if (tier != null) {
            this.tier = tier;
            String name = tier.getName();
            this.singleEditMode = true;
            if (this.currentTiersComboBox != null) {
                this.currentTiersComboBox.setSelectedItem(name);
            }
        }
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.frame);
        if (editMode == 0) {
            this.tierNameTextField.requestFocus();
        }
    }

    private void extractCurrentTiers() {
        this.currentTiersComboBox.removeItemListener(this);
        this.currentTiersComboBox.removeAllItems();
        this.tiers = this.transcription.getTiers();
        if (this.tiers == null) {
            this.tiers = new Vector();
            return;
        }
        for (TierImpl t : this.tiers) {
            this.currentTiersComboBox.addItem(t.getName());
        }
        if (this.currentTiersComboBox.getItemCount() > 0) {
            this.currentTiersComboBox.setSelectedIndex(0);
            this.tier = (TierImpl)this.tiers.get(0);
        }
        this.currentTiersComboBox.addItemListener(this);
    }

    private void reextractTiers() {
        this.extractCurrentTiers();
        if (this.currentTiersComboBox.getItemCount() > 0) {
            this.currentTiersComboBox.setSelectedIndex(0);
        } else {
            this.tierNameTextField.setText("");
            this.participantTextField.setText("");
        }
        if (this.mode == 0) {
            this.tierNameTextField.setText("");
            this.participantTextField.setText("");
        }
    }

    private void updateForModeAndLocale() {
        this.tierNameLabel.setText(ElanLocale.getString("EditTierDialog.Label.TierName"));
        this.participantLabel.setText(ElanLocale.getString("EditTierDialog.Label.Participant"));
        this.lingTypeLabel.setText(ElanLocale.getString("EditTierDialog.Label.LinguisticType"));
        this.parentLabel.setText(ElanLocale.getString("EditTierDialog.Label.Parent"));
        this.languageLabel.setText(ElanLocale.getString("EditTierDialog.Label.Language"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
        switch (this.mode) {
            case 0: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Add"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.CurrentTiers"));
                this.changeButton.setText(ElanLocale.getString("Button.Add"));
                break;
            }
            case 1: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Change"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.ChangeTier"));
                this.changeButton.setText(ElanLocale.getString("Button.Change"));
                this.parentChoice.setEnabled(false);
                break;
            }
            case 2: {
                this.setTitle(ElanLocale.getString("EditTierDialog.Title.Delete"));
                this.selectTierLabel.setText(ElanLocale.getString("EditTierDialog.Label.DeleteTier"));
                this.changeButton.setText(ElanLocale.getString("Button.Delete"));
                this.tierNameTextField.setEditable(false);
                this.participantTextField.setEditable(false);
                this.parentChoice.setEnabled(false);
                this.lingTypeChoice.setEnabled(false);
                this.languageChoice.setEnabled(false);
            }
        }
        this.titleLabel.setText(this.getTitle());
    }

    private void createDialog() {
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.currentTiersComboBox.addItemListener(this);
        this.fillParentComboBox();
        this.fillLingTypeMenu();
        this.langs = ImUtil.getLanguages(this);
        this.updateLanguageChoice();
        this.changeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.changeButton);
        this.buttonPanel.add(this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                EditTierDialog.this.dispose();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.titleLabel, c);
        c.anchor = 17;
        c.gridwidth = 1;
        c.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.selectTierLabel, c);
        this.currentTiersComboBox.setMaximumRowCount(20);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.currentTiersComboBox, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.tierNameLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.tierNameTextField, c);
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.participantLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.participantTextField, c);
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.parentLabel, c);
        this.parentChoice.setMaximumRowCount(20);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.parentChoice, c);
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.lingTypeLabel, c);
        this.lingTypeChoice.setMaximumRowCount(20);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.lingTypeChoice, c);
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.languageLabel, c);
        this.languageChoice.setMaximumRowCount(20);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.languageChoice, c);
        c.anchor = 15;
        c.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, c);
        this.updateUIForTier((String)this.currentTiersComboBox.getSelectedItem());
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.frame);
    }

    private void fillLingTypeMenu() {
        LinguisticType type;
        TierImpl tier;
        this.lingTypeChoice.removeItemListener(this);
        this.lingTypeChoice.removeAllItems();
        TierImpl parentTier = (TierImpl)this.transcription.getTierWithId((String)this.parentChoice.getSelectedItem());
        boolean excludeTimeSubDiv = false;
        Constraint parentConstraint = null;
        if (parentTier != null && (parentConstraint = parentTier.getLinguisticType().getConstraints()) != null && (parentConstraint.getStereoType() == 3 || parentConstraint.getStereoType() == 4)) {
            excludeTimeSubDiv = true;
        }
        Enumeration e = this.transcription.getLinguisticTypes().elements();
        while (e.hasMoreElements()) {
            LinguisticType lt = (LinguisticType)e.nextElement();
            String ltName = lt.getLinguisticTypeName();
            if (excludeTimeSubDiv && lt.getConstraints() != null && (lt.getConstraints().getStereoType() == 0 || lt.getConstraints().getStereoType() == 1) || parentTier == null && lt.getConstraints() != null || parentTier != null && lt.getConstraints() == null) continue;
            this.lingTypeChoice.addItem(ltName);
        }
        String tierName = (String)this.currentTiersComboBox.getSelectedItem();
        if (tierName != null && (tier = (TierImpl)this.transcription.getTierWithId(tierName)) != null && (type = tier.getLinguisticType()) != null) {
            this.lingTypeChoice.setSelectedItem(type.getLinguisticTypeName());
        }
        this.lingTypeChoice.addItemListener(this);
        if (this.lingTypeChoice.getModel().getSize() <= 0) {
            this.changeButton.setEnabled(false);
        } else {
            this.changeButton.setEnabled(true);
        }
    }

    private void fillParentComboBox() {
        this.parentChoice.removeItemListener(this);
        this.parentChoice.removeAllItems();
        this.parentChoice.addItem("none");
        if (this.tier != null && this.mode != 0) {
            Vector candidateParents = this.transcription.getCandidateParentTiers(this.tier);
            Iterator pIter = candidateParents.iterator();
            while (pIter.hasNext()) {
                this.parentChoice.addItem(((Tier)pIter.next()).getName());
            }
            if (this.tier.hasParentTier()) {
                this.parentChoice.setSelectedItem(this.tier.getParentTier().getName());
            }
        } else if (this.mode == 0) {
            for (TierImpl t : this.tiers) {
                this.parentChoice.addItem(t.getName());
            }
            this.parentChoice.setSelectedItem("none");
        }
        this.parentChoice.addItemListener(this);
    }

    private void updateLanguageChoice() {
        this.languageChoice.removeAllItems();
        if (this.langs != null) {
            for (int i = 0; i < this.langs.length; ++i) {
                this.languageChoice.addItem(this.langs[i].getDisplayName());
            }
        }
        if (this.tier != null) {
            Locale l = this.tier.getDefaultLocale();
            if (l != null) {
                this.languageChoice.setSelectedItem(l.getDisplayName());
            } else {
                this.languageChoice.setSelectedIndex(0);
            }
        }
    }

    private void updateUIForTier(String name) {
        if (name != null) {
            this.tier = (TierImpl)this.transcription.getTierWithId(name);
            if (this.tier != null) {
                this.oldParentTier = (TierImpl)this.tier.getParentTier();
                this.oldParentTierName = this.oldParentTier != null ? this.tier.getParentTier().getName() : "none";
                this.oldLingType = this.tier.getLinguisticType();
                this.oldLocale = this.tier.getDefaultLocale();
                this.oldTierName = this.tier.getName();
                this.oldParticipant = this.tier.getParticipant();
                if (this.mode != 0) {
                    this.tierNameTextField.setText(this.oldTierName);
                    this.participantTextField.setText(this.oldParticipant);
                }
            }
            this.fillParentComboBox();
            this.fillLingTypeMenu();
            this.updateLanguageChoice();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.currentTiersComboBox) {
                String name = (String)this.currentTiersComboBox.getSelectedItem();
                this.updateUIForTier(name);
            } else if (e.getSource() == this.lingTypeChoice && this.mode == 1) {
                if (this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                    int oldStereoType;
                    String newTypeName = (String)e.getItem();
                    boolean stereoTypeChanged = false;
                    int newStereoType = this.getStereoTypeForTypeName(newTypeName);
                    if (newStereoType != (oldStereoType = this.getStereoTypeForType(this.oldLingType))) {
                        stereoTypeChanged = true;
                    }
                    if (!this.oldLingType.getLinguisticTypeName().equals(newTypeName) && stereoTypeChanged) {
                        StringBuffer buf = new StringBuffer(ElanLocale.getString("EditTierDialog.Message.RecommendType"));
                        buf.append("\n");
                        buf.append(ElanLocale.getString("EditTierDialog.Message.Corrupt"));
                        JOptionPane.showMessageDialog(this, buf.toString(), ElanLocale.getString("Message.Warning"), 2);
                        this.lingTypeChoice.setSelectedItem(this.oldLingType.getLinguisticTypeName());
                    }
                }
            } else if (e.getSource() == this.parentChoice) {
                if (this.mode == 1 && this.tier != null && this.tier.getNumberOfAnnotations() > 0) {
                    if (!this.oldParentTierName.equals((String)e.getItem())) {
                        StringBuffer buf = new StringBuffer(ElanLocale.getString("EditTierDialog.Message.RecommendParent"));
                        buf.append("\n");
                        buf.append(ElanLocale.getString("EditTierDialog.Message.Corrupt"));
                        JOptionPane.showMessageDialog(this, buf.toString(), ElanLocale.getString("Message.Warning"), 2);
                        this.parentChoice.setSelectedItem(this.oldParentTierName);
                    }
                } else {
                    TierImpl parent;
                    String partiName = this.participantTextField.getText();
                    if ((partiName == null || partiName.trim().length() == 0) && (parent = (TierImpl)this.transcription.getTierWithId((String)e.getItem())) != null) {
                        this.participantTextField.setText(parent.getParticipant());
                    }
                }
                this.fillLingTypeMenu();
            }
        }
    }

    private void doAdd(String tierName, Tier parentTier, String lingType, String participant, Locale locale) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AddNewTier");
        TranscriptionImpl receiver = this.transcription;
        Object[] args = new Object[]{tierName, parentTier, lingType, participant, locale};
        c.execute(receiver, args);
        this.reextractTiers();
        TierImpl tt = (TierImpl)this.transcription.getTierWithId(tierName);
        if (tt != null && tt.getLinguisticType().hasGraphicReferences()) {
            this.checkGraphics(tt);
        }
    }

    private void doChange(String tierName, Tier parentTier, String lingType, String participant, Locale locale) {
        if (this.tier.getAnnotations().size() > 0) {
            if (parentTier != null && this.oldParentTier == null || parentTier == null && this.oldParentTier != null || parentTier != this.oldParentTier) {
                parentTier = this.oldParentTier;
            }
            if (this.getStereoTypeForTypeName(lingType) != this.getStereoTypeForType(this.oldLingType)) {
                lingType = this.oldLingType.getLinguisticTypeName();
            }
        }
        if (!tierName.equals(this.oldTierName) || parentTier != null && this.oldParentTier != null && parentTier != this.oldParentTier || !lingType.equals(this.oldLingType.getLinguisticTypeName()) || !participant.equals(this.oldParticipant) || locale != null && locale != this.oldLocale) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ChangeTier");
            TierImpl receiver = this.tier;
            Object[] args = new Object[]{tierName, parentTier, lingType, participant, locale};
            c.execute(receiver, args);
            if (this.tier.getLinguisticType().hasGraphicReferences() && !lingType.equals(this.oldLingType.getLinguisticTypeName())) {
                this.checkGraphics(this.tier);
            }
            if (this.singleEditMode) {
                this.dispose();
            } else {
                this.reextractTiers();
            }
        }
    }

    private void doDelete() {
        if (this.tier != null) {
            int option;
            Vector depTiers = this.tier.getDependentTiers();
            StringBuffer mesBuf = new StringBuffer();
            mesBuf.append(ElanLocale.getString("EditTierDialog.Message.ConfirmDelete"));
            mesBuf.append("  ");
            mesBuf.append(this.oldTierName);
            mesBuf.append(" ?\n");
            if (depTiers != null && depTiers.size() > 0) {
                mesBuf.append(ElanLocale.getString("EditTierDialog.Message.AlsoDeleted"));
                for (Tier t : depTiers) {
                    mesBuf.append("\n-   ");
                    mesBuf.append(t.getName());
                }
            }
            if ((option = JOptionPane.showConfirmDialog(this, mesBuf.toString(), ElanLocale.getString("Message.Warning"), 0)) == 0) {
                Object[] args = new Object[]{this.tier};
                Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.DeleteTier");
                c.execute(this.transcription, args);
                if (this.singleEditMode) {
                    this.dispose();
                } else {
                    this.reextractTiers();
                }
            }
        }
    }

    private void checkGraphics(TierImpl ti) {
        int numGraphicTiers = 1;
        Vector tiers = this.transcription.getTiers();
        for (TierImpl t : tiers) {
            if (t == ti || !t.getLinguisticType().hasGraphicReferences()) continue;
            ++numGraphicTiers;
        }
        if (numGraphicTiers == 1 && (this.transcription.getSVGFile() == null || this.transcription.getSVGFile().length() == 0)) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Graphics"), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.changeButton) {
            if (this.mode == 2) {
                this.doDelete();
                return;
            }
            String tierName = this.tierNameTextField.getText();
            tierName.replace('\n', ' ');
            tierName.trim();
            if (tierName.length() == 0) {
                this.tierNameTextField.requestFocus();
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.TierName"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            if (this.transcription.getTierWithId(tierName) != null && (this.mode == 0 || this.mode == 1 && !tierName.equals(this.oldTierName))) {
                this.tierNameTextField.requestFocus();
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Exists"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            String participant = this.participantTextField.getText();
            String lingType = (String)this.lingTypeChoice.getSelectedItem();
            Tier parentTier = this.transcription.getTierWithId((String)this.parentChoice.getSelectedItem());
            String localeName = (String)this.languageChoice.getSelectedItem();
            Locale locale = null;
            if (this.langs != null) {
                for (int i = 0; i < this.langs.length; ++i) {
                    if (!this.langs[i].getDisplayName().equals(localeName)) continue;
                    locale = this.langs[i];
                    break;
                }
            }
            if (locale == null) {
                locale = this.oldLocale;
            }
            switch (this.mode) {
                case 0: {
                    this.doAdd(tierName, parentTier, lingType, participant, locale);
                    break;
                }
                case 1: {
                    this.doChange(tierName, parentTier, lingType, participant, locale);
                }
            }
        } else {
            this.dispose();
        }
    }

    private int getStereoTypeForTypeName(String name) {
        LinguisticType type = null;
        Vector types = this.transcription.getLinguisticTypes();
        LinguisticType tempType = null;
        for (int i = 0; i < types.size(); ++i) {
            tempType = (LinguisticType)types.get(i);
            if (!tempType.getLinguisticTypeName().equals(name)) continue;
            type = tempType;
            break;
        }
        return this.getStereoTypeForType(type);
    }

    private int getStereoTypeForType(LinguisticType type) {
        if (type == null || type.getConstraints() == null) {
            return -1;
        }
        return type.getConstraints().getStereoType();
    }
}

