/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.ControlledVocabulary;

public class EditTypeDialog
extends JDialog
implements ActionListener,
ItemListener {
    public static final int ADD = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    private TranscriptionImpl transcription;
    private LinguisticType oldType;
    private Vector types;
    private String oldConstraint;
    public final String none = "None";
    private Frame frame;
    private JLabel titleLabel = new JLabel();
    private JLabel currentTypesLabel = new JLabel();
    private JLabel typeLabel = new JLabel();
    private JLabel alignableLabel = new JLabel();
    private JLabel graphicReferencesLabel = new JLabel();
    private JLabel constraintsLabel = new JLabel();
    private JLabel cvLabel = new JLabel();
    private JTextField typeTextField = new JTextField(30);
    private JButton changeButton = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox timeAlignableCheckbox = new JCheckBox("", false);
    private JCheckBox graphicReferencesCheckbox = new JCheckBox("", false);
    private JComboBox constraints = new JComboBox();
    private JComboBox currentTypes = new JComboBox();
    private JComboBox cvComboBox = new JComboBox();
    private JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
    private int mode = 0;

    public EditTypeDialog(Frame theFrame, boolean modal, Transcription theTranscription, int editMode) {
        super(theFrame, modal);
        this.frame = theFrame;
        this.transcription = (TranscriptionImpl)theTranscription;
        if (editMode == 0 || editMode == 1 || editMode == 2) {
            this.mode = editMode;
        }
        this.extractCurrentTypes();
        this.extractControlledVocabularies();
        this.createDialog();
        this.updateForModeAndLocale();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.frame);
        if (editMode == 0) {
            this.typeTextField.requestFocus();
        }
    }

    private void extractCurrentTypes() {
        this.currentTypes.removeItemListener(this);
        this.currentTypes.removeAllItems();
        this.types = this.transcription.getLinguisticTypes();
        if (this.types == null) {
            this.types = new Vector();
            return;
        }
        LinguisticType lt2 = null;
        for (LinguisticType lt2 : this.types) {
            this.currentTypes.addItem(lt2.getLinguisticTypeName());
        }
        this.currentTypes.addItemListener(this);
    }

    private void reextractTypes() {
        this.extractCurrentTypes();
        if (this.currentTypes.getItemCount() > 0) {
            this.currentTypes.setSelectedIndex(0);
            String name = (String)this.currentTypes.getSelectedItem();
            if (name != null) {
                this.updateUIForType(name);
            }
        } else {
            this.typeTextField.setText("");
        }
        if (this.mode == 0) {
            this.typeTextField.setText("");
        }
    }

    private void extractControlledVocabularies() {
        Vector cv = this.transcription.getControlledVocabularies();
        this.cvComboBox.addItem("None");
        for (int i = 0; i < cv.size(); ++i) {
            this.cvComboBox.addItem(((ControlledVocabulary)cv.get(i)).getName());
        }
    }

    private void updateUIForType(String typeName) {
        if (typeName != null) {
            this.typeTextField.setText(typeName);
            for (LinguisticType lt : this.types) {
                if (lt == null || !lt.getLinguisticTypeName().equals(typeName)) continue;
                this.constraints.removeItemListener(this);
                Constraint oldC = lt.getConstraints();
                if (oldC != null) {
                    String stereoType;
                    this.oldConstraint = stereoType = Constraint.stereoTypes[oldC.getStereoType()];
                    this.constraints.setSelectedItem(stereoType);
                } else {
                    this.oldConstraint = "None";
                    this.constraints.setSelectedItem("None");
                }
                this.timeAlignableCheckbox.setSelected(lt.isTimeAlignable());
                this.graphicReferencesCheckbox.setSelected(lt.hasGraphicReferences());
                if (lt.isUsingControlledVocabulary()) {
                    String cvName = lt.getControlledVocabylaryName();
                    this.cvComboBox.getModel().setSelectedItem(cvName);
                } else {
                    this.cvComboBox.getModel().setSelectedItem("None");
                }
                this.constraints.addItemListener(this);
                break;
            }
        }
    }

    private void createDialog() {
        this.timeAlignableCheckbox.setEnabled(false);
        this.constraints.addItem("None");
        this.timeAlignableCheckbox.setSelected(true);
        String[] publicStereoTypes = Constraint.publicStereoTypes;
        for (int i = 0; i < publicStereoTypes.length; ++i) {
            this.constraints.addItem(publicStereoTypes[i]);
        }
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.constraints.addItemListener(this);
        this.changeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.changeButton);
        this.buttonPanel.add(this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                EditTypeDialog.this.dispose();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 6, 2, 6);
        c.anchor = 11;
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.titleLabel, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.currentTypesLabel, c);
        this.currentTypes.setMaximumRowCount(20);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.currentTypes, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.typeLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.typeTextField, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.constraintsLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.constraints, c);
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.cvLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.cvComboBox, c);
        c.anchor = 17;
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.alignableLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.timeAlignableCheckbox, c);
        c.gridwidth = 1;
        this.getContentPane().add((Component)this.graphicReferencesLabel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this.graphicReferencesCheckbox, c);
        c.gridx = -1;
        c.anchor = 15;
        c.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, c);
    }

    private void updateForModeAndLocale() {
        this.typeLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Type"));
        this.alignableLabel.setText(ElanLocale.getString("EditTypeDialog.Label.TimeAlignable"));
        this.graphicReferencesLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Graphics"));
        this.constraintsLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Stereotype"));
        this.cvLabel.setText(ElanLocale.getString("EditTypeDialog.Label.CV"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
        switch (this.mode) {
            case 0: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Add"));
                this.currentTypesLabel.setText(ElanLocale.getString("EditTypeDialog.CurrentTypes"));
                this.changeButton.setText(ElanLocale.getString("Button.Add"));
                break;
            }
            case 1: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Change"));
                this.currentTypesLabel.setText(ElanLocale.getString("EditTypeDialog.ChangeType"));
                this.changeButton.setText(ElanLocale.getString("Button.Change"));
                if (this.currentTypes.getModel().getSize() > 0) {
                    this.updateUIForType((String)this.currentTypes.getItemAt(0));
                    this.currentTypes.addItemListener(this);
                    break;
                }
                this.changeButton.setEnabled(false);
                break;
            }
            case 2: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Delete"));
                this.currentTypesLabel.setText(ElanLocale.getString("EditTypeDialog.DeleteType"));
                this.changeButton.setText(ElanLocale.getString("Button.Delete"));
                if (this.currentTypes.getModel().getSize() > 0) {
                    this.updateUIForType((String)this.currentTypes.getItemAt(0));
                    this.currentTypes.addItemListener(this);
                } else {
                    this.changeButton.setEnabled(false);
                }
                this.typeTextField.setEditable(false);
                this.constraints.setEnabled(false);
                this.cvComboBox.setEnabled(false);
                this.graphicReferencesCheckbox.setEnabled(false);
            }
        }
        this.titleLabel.setText(this.getTitle());
    }

    private Constraint getConstraintForName(String name) {
        ConstraintImpl c = null;
        if (name.equals(Constraint.stereoTypes[0])) {
            c = new TimeSubdivision();
        } else if (name.equals(Constraint.stereoTypes[3])) {
            c = new SymbolicSubdivision();
        } else if (name.equals(Constraint.stereoTypes[4])) {
            c = new SymbolicAssociation();
        } else if (name.equals(Constraint.stereoTypes[1])) {
            c = new IncludedIn();
        }
        return c;
    }

    private void doAdd(String name) {
        LinguisticType lt2 = null;
        for (LinguisticType lt2 : this.types) {
            if (!lt2.getLinguisticTypeName().equals(name)) continue;
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.Exists");
            this.typeTextField.requestFocus();
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        String cons = (String)this.constraints.getSelectedItem();
        Constraint c = this.getConstraintForName(cons);
        boolean alignable = this.timeAlignableCheckbox.isSelected();
        boolean graphicsRef = this.graphicReferencesCheckbox.isSelected();
        String cvName = (String)this.cvComboBox.getSelectedItem();
        if (cvName.equals("None")) {
            cvName = null;
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.AddNewType");
        Object[] args = new Object[]{name, c, cvName, new Boolean(alignable), new Boolean(graphicsRef)};
        com.execute(this.transcription, args);
        this.reextractTypes();
    }

    private void doChange(String name) {
        String warning;
        int option;
        String oldName = (String)this.currentTypes.getSelectedItem();
        LinguisticType lt = null;
        LinguisticType iterType2 = null;
        for (LinguisticType iterType2 : this.types) {
            if (iterType2.getLinguisticTypeName().equals(oldName)) {
                lt = iterType2;
            }
            if (!iterType2.getLinguisticTypeName().equals(name) || iterType2 == lt) continue;
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.Exists");
            this.typeTextField.requestFocus();
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        if (lt == null) {
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.UnknownError");
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        String oldCV = null;
        if (lt.isUsingControlledVocabulary()) {
            oldCV = lt.getControlledVocabylaryName();
        }
        boolean oldGraphicsRef = lt.hasGraphicReferences();
        String cons = (String)this.constraints.getSelectedItem();
        Constraint c = this.getConstraintForName(cons);
        String cvName = (String)this.cvComboBox.getSelectedItem();
        if (cvName.equals("None")) {
            cvName = null;
        }
        boolean alignable = this.timeAlignableCheckbox.isSelected();
        boolean graphicsRef = this.graphicReferencesCheckbox.isSelected();
        if (name.equals(oldName) && (c == null && lt.getConstraints() == null || c == lt.getConstraints()) && (oldCV == null && cvName == null || oldCV != null && oldCV.equals(cvName)) && lt.isTimeAlignable() == alignable && oldGraphicsRef == graphicsRef) {
            return;
        }
        if (oldGraphicsRef && !graphicsRef && (option = JOptionPane.showConfirmDialog(this, warning = ElanLocale.getString("EditTypeDialog.Message.GraphicsLost") + "\n" + ElanLocale.getString("EditTypeDialog.Message.Confirm"), ElanLocale.getString("Message.Warning"), 0, 3)) != 0) {
            return;
        }
        if (graphicsRef) {
            this.checkGraphics(lt);
        }
        Object[] args = new Object[]{name, c, cvName, new Boolean(alignable), new Boolean(graphicsRef), lt};
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.ChangeType");
        com.execute(this.transcription, args);
        this.reextractTypes();
    }

    private void doDelete() {
        String oldName = (String)this.currentTypes.getSelectedItem();
        LinguisticType lt = null;
        Iterator tIter = this.types.iterator();
        while (tIter.hasNext() && !(lt = (LinguisticType)tIter.next()).getLinguisticTypeName().equals(oldName)) {
        }
        if (lt == null) {
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.UnknownError");
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        Vector clientTiers = this.transcription.getTiersWithLinguisticType(oldName);
        if (clientTiers.size() > 0) {
            StringBuffer errorBuffer = new StringBuffer(ElanLocale.getString("EditTypeDialog.Message.TypeInUse"));
            errorBuffer.append(":\n");
            Iterator clIter = clientTiers.iterator();
            while (clIter.hasNext()) {
                errorBuffer.append("- ");
                errorBuffer.append(((Tier)clIter.next()).getName());
                errorBuffer.append("\n");
            }
            errorBuffer.append(ElanLocale.getString("EditTypeDialog.Message.Reassign"));
            JOptionPane.showMessageDialog(this, errorBuffer.toString(), ElanLocale.getString("Message.Warning"), 0);
            return;
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.DeleteType");
        com.execute(this.transcription, new Object[]{lt});
        this.reextractTypes();
    }

    private void checkGraphics(LinguisticType type) {
        Vector tiersOfType = this.transcription.getTiersWithLinguisticType(type.getLinguisticTypeName());
        boolean alreadyThere = false;
        Vector allTiers = this.transcription.getTiers();
        for (TierImpl tier : allTiers) {
            LinguisticType otherType = tier.getLinguisticType();
            if (otherType == type || !otherType.hasGraphicReferences()) continue;
            alreadyThere = true;
            break;
        }
        if (!alreadyThere && tiersOfType.size() > 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Graphics"), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.changeButton) {
            if (this.mode == 2) {
                this.doDelete();
            } else {
                String typeName = this.typeTextField.getText();
                typeName.replace('\n', ' ');
                typeName.trim();
                if (typeName.length() == 0) {
                    String errorMessage = ElanLocale.getString("EditTypeDialog.Message.TypeName");
                    this.typeTextField.requestFocus();
                    JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
                    return;
                }
                switch (this.mode) {
                    case 0: {
                        this.doAdd(typeName);
                        break;
                    }
                    case 1: {
                        this.doChange(typeName);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        } else {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.currentTypes && e.getStateChange() == 1) {
            String name = (String)this.currentTypes.getSelectedItem();
            if (name != null) {
                this.updateUIForType(name);
            }
        } else if (e.getSource() == this.constraints && e.getStateChange() == 1) {
            String typeName;
            Vector tiers;
            String constraint = (String)this.constraints.getSelectedItem();
            if (constraint == "None" || constraint == "Time Subdivision") {
                this.timeAlignableCheckbox.setSelected(true);
                this.graphicReferencesCheckbox.setEnabled(true);
            } else if (constraint == "Symbolic Subdivision" || constraint == "Symbolic Association") {
                this.timeAlignableCheckbox.setSelected(false);
                this.graphicReferencesCheckbox.setSelected(false);
                this.graphicReferencesCheckbox.setEnabled(false);
            }
            if (this.mode == 1 && this.oldConstraint != constraint && (tiers = this.transcription.getTiersWithLinguisticType(typeName = (String)this.currentTypes.getSelectedItem())).size() > 0) {
                StringBuffer mesBuf = new StringBuffer(ElanLocale.getString("EditTypeDialog.Message.TypeInUse"));
                mesBuf.append("\n");
                mesBuf.append(ElanLocale.getString("EditTypeDialog.Message.Corrupt"));
                JOptionPane.showMessageDialog(null, mesBuf.toString(), ElanLocale.getString("Message.Warning"), 2);
                this.updateUIForType(typeName);
            }
        }
    }
}

