/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import mpi.dcr.DCSmall;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.dcr.ELANDCRDialog;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.lexicon.LexiconQueryBundleDialog;
import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.util.ControlledVocabulary;

public class EditTypeDialog2
extends ClosableDialog
implements ActionListener,
ItemListener,
ChangeListener,
ListSelectionListener {
    public static final int ADD = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    public static final int IMPORT = 3;
    public final String none = "None";
    private TranscriptionImpl transcription;
    private Vector types;
    private String oldConstraint;
    private JLabel titleLabel;
    private JPanel typePanel;
    private JTable typeTable;
    private LinguisticTypeTableModel model;
    private JTabbedPane tabPane;
    private JPanel editPanel;
    private JLabel currentTypesLabel;
    private JLabel typeLabel;
    private JLabel timeAlignableLabel;
    private JLabel graphicReferencesLabel;
    private JLabel constraintsLabel;
    private JLabel cvLabel;
    private JTextField typeTextField;
    private JCheckBox timeAlignableCheckbox;
    private JCheckBox graphicReferencesCheckbox;
    private JComboBox constraintsComboBox;
    private JComboBox currentTypesComboBox;
    private JComboBox cvComboBox;
    protected JPanel dcrPanel;
    protected JLabel dcrLabel;
    protected JTextField dcrField;
    protected JTextField dcIdField;
    protected JButton dcrButton;
    private JLabel lexiconLabel;
    private JPanel lexiconPanel;
    private JTextField lexiconLinkField;
    private JTextField lexiconFieldField;
    private JButton lexiconButton;
    private LexiconQueryBundle2 oldLexiconQueryBundle;
    private LexiconQueryBundle2 newLexiconQueryBundle;
    private JPanel importPanel;
    private JLabel importSourceLabel;
    private JTextField importSourceTF;
    private JButton importSourceButton;
    private JPanel buttonPanel;
    private JButton changeButton;
    private JButton cancelButton;
    private int mode = 0;

    public EditTypeDialog2(Frame theFrame, boolean modal, Transcription theTranscription, int editMode) {
        super(theFrame, modal);
        this.transcription = (TranscriptionImpl)theTranscription;
        if (editMode >= 0 && editMode <= 3) {
            this.mode = editMode;
        }
        this.initComponents();
        this.extractCurrentTypes();
        this.extractControlledVocabularies();
        this.updateUIForType((String)this.currentTypesComboBox.getSelectedItem());
        this.updateLocale();
        this.updateForMode();
        this.postInit();
        if (this.mode == 0) {
            this.typeTextField.requestFocus();
        } else if (this.mode == 3) {
            this.importSourceButton.requestFocus();
        } else {
            this.currentTypesComboBox.requestFocus();
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.currentTypesLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.timeAlignableLabel = new JLabel();
        this.graphicReferencesLabel = new JLabel();
        this.constraintsLabel = new JLabel();
        this.cvLabel = new JLabel();
        this.typeTextField = new JTextField(30);
        this.changeButton = new JButton();
        this.cancelButton = new JButton();
        this.timeAlignableCheckbox = new JCheckBox("", true);
        this.timeAlignableCheckbox.setEnabled(false);
        this.graphicReferencesCheckbox = new JCheckBox("", false);
        this.constraintsComboBox = new JComboBox();
        this.currentTypesComboBox = new JComboBox();
        this.currentTypesComboBox.setMaximumRowCount(20);
        this.cvComboBox = new JComboBox();
        this.lexiconLabel = new JLabel();
        this.lexiconPanel = new JPanel(new GridBagLayout());
        this.lexiconLinkField = new JTextField();
        this.lexiconLinkField.setEditable(false);
        this.lexiconLinkField.setEnabled(false);
        this.lexiconFieldField = new JTextField();
        this.lexiconFieldField.setEditable(false);
        this.lexiconFieldField.setEnabled(false);
        this.lexiconButton = new JButton();
        this.lexiconButton.addActionListener(this);
        this.dcrPanel = new JPanel(new GridBagLayout());
        this.dcrLabel = new JLabel();
        this.dcrField = new JTextField();
        this.dcIdField = new JTextField();
        this.dcIdField.setEditable(false);
        this.dcrField.setEditable(false);
        this.dcrField.setEnabled(false);
        this.dcIdField.setEnabled(false);
        this.dcrButton = new JButton();
        this.dcrButton.addActionListener(this);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.constraintsComboBox.addItem("None");
        String[] publicStereoTypes = Constraint.publicStereoTypes;
        for (int i = 0; i < publicStereoTypes.length; ++i) {
            this.constraintsComboBox.addItem(publicStereoTypes[i]);
        }
        this.constraintsComboBox.addItemListener(this);
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new GridBagLayout());
        ImageIcon tickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Tick16.gif"));
        ImageIcon untickIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Untick16.gif"));
        CheckBoxTableCellRenderer cbRenderer = new CheckBoxTableCellRenderer();
        cbRenderer.setIcon(untickIcon);
        cbRenderer.setSelectedIcon(tickIcon);
        cbRenderer.setHorizontalAlignment(0);
        String[] columns = new String[]{"Type", "Stereotype", "CV", "DCR", "TimeAlignable", "Graphics"};
        this.model = new LinguisticTypeTableModel(this.transcription.getLinguisticTypes(), columns);
        this.typeTable = new JTable(this.model);
        this.typeTable.setSelectionMode(0);
        this.typeTable.getSelectionModel().addListSelectionListener(this);
        for (int i = 0; i < this.typeTable.getColumnCount(); ++i) {
            if (this.typeTable.getModel().getColumnClass(i) != String.class) {
                this.typeTable.getColumn(this.typeTable.getModel().getColumnName(i)).setPreferredWidth(35);
            }
            if (this.typeTable.getModel().getColumnClass(i) != Boolean.class) continue;
            this.typeTable.getColumn(this.typeTable.getModel().getColumnName(i)).setCellRenderer(cbRenderer);
        }
        JScrollPane typeScrollPane = new JScrollPane(this.typeTable);
        Dimension size = new Dimension(300, 120);
        typeScrollPane.setMinimumSize(size);
        typeScrollPane.setPreferredSize(size);
        this.tabPane = new JTabbedPane();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.typePanel.add((Component)typeScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.typePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.tabPane, gbc);
        this.editPanel = new JPanel(new GridBagLayout());
        GridBagConstraints lgbc = new GridBagConstraints();
        lgbc.anchor = 18;
        lgbc.insets = insets;
        this.editPanel.add((Component)this.currentTypesLabel, lgbc);
        GridBagConstraints rgbc = new GridBagConstraints();
        rgbc.gridx = 1;
        rgbc.fill = 2;
        rgbc.anchor = 18;
        rgbc.insets = insets;
        rgbc.weightx = 1.0;
        this.editPanel.add((Component)this.currentTypesComboBox, rgbc);
        lgbc.gridy = 1;
        this.editPanel.add((Component)this.typeLabel, lgbc);
        rgbc.gridy = 1;
        this.editPanel.add((Component)this.typeTextField, rgbc);
        lgbc.gridy = 2;
        this.editPanel.add((Component)this.constraintsLabel, lgbc);
        rgbc.gridy = 2;
        this.editPanel.add((Component)this.constraintsComboBox, rgbc);
        lgbc.gridy = 3;
        this.editPanel.add((Component)this.cvLabel, lgbc);
        rgbc.gridy = 3;
        this.editPanel.add((Component)this.cvComboBox, rgbc);
        lgbc.gridy = 4;
        this.editPanel.add((Component)this.lexiconLabel, lgbc);
        GridBagConstraints lexgbc = new GridBagConstraints();
        lexgbc.fill = 2;
        lexgbc.anchor = 18;
        lexgbc.weightx = 1.0;
        lexgbc.insets = new Insets(4, 0, 0, 6);
        this.lexiconPanel.add((Component)this.lexiconLinkField, lexgbc);
        lexgbc.gridx = 1;
        lexgbc.weightx = 0.5;
        this.lexiconPanel.add((Component)this.lexiconFieldField, lexgbc);
        lexgbc.fill = 0;
        lexgbc.weightx = 0.0;
        lexgbc.gridx = 2;
        lexgbc.insets = new Insets(0, 6, 0, 0);
        this.lexiconPanel.add((Component)this.lexiconButton, lexgbc);
        rgbc.gridy = 4;
        this.editPanel.add((Component)this.lexiconPanel, rgbc);
        lgbc.gridy = 5;
        this.editPanel.add((Component)this.dcrLabel, lgbc);
        GridBagConstraints dcgbc = new GridBagConstraints();
        dcgbc.fill = 2;
        dcgbc.anchor = 18;
        dcgbc.weightx = 1.0;
        dcgbc.insets = new Insets(4, 0, 0, 6);
        this.dcrPanel.add((Component)this.dcrField, dcgbc);
        dcgbc.gridx = 1;
        dcgbc.weightx = 0.5;
        this.dcrPanel.add((Component)this.dcIdField, dcgbc);
        dcgbc.gridx = 2;
        dcgbc.fill = 0;
        dcgbc.weightx = 0.0;
        dcgbc.insets = new Insets(0, 6, 0, 0);
        this.dcrPanel.add((Component)this.dcrButton, dcgbc);
        rgbc.gridy = 5;
        this.editPanel.add((Component)this.dcrPanel, rgbc);
        lgbc.gridy = 6;
        this.editPanel.add((Component)this.timeAlignableLabel, lgbc);
        rgbc.gridy = 6;
        this.editPanel.add((Component)this.timeAlignableCheckbox, rgbc);
        lgbc.gridy = 7;
        this.editPanel.add((Component)this.graphicReferencesLabel, lgbc);
        rgbc.gridy = 7;
        this.editPanel.add((Component)this.graphicReferencesCheckbox, rgbc);
        this.importPanel = new JPanel(new GridBagLayout());
        this.importSourceLabel = new JLabel();
        this.importSourceTF = new JTextField();
        this.importSourceTF.setEditable(false);
        this.importSourceButton = new JButton();
        this.importSourceButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.importPanel.add((Component)this.importSourceLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.importPanel.add((Component)this.importSourceTF, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = insets;
        this.importPanel.add((Component)this.importSourceButton, gbc);
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Import"), this.importPanel);
        if (this.mode < 3) {
            this.tabPane.setComponentAt(this.mode, this.editPanel);
        } else {
            this.tabPane.setComponentAt(0, this.editPanel);
        }
        this.tabPane.setSelectedIndex(this.mode);
        this.tabPane.addChangeListener(this);
        this.changeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.changeButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
    }

    private void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateLocale() {
        this.typeLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Type"));
        this.typePanel.setBorder(new TitledBorder(ElanLocale.getString("EditTypeDialog.CurrentTypes")));
        this.timeAlignableLabel.setText(ElanLocale.getString("EditTypeDialog.Label.TimeAlignable"));
        this.graphicReferencesLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Graphics"));
        this.constraintsLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Stereotype"));
        this.cvLabel.setText(ElanLocale.getString("EditTypeDialog.Label.CV"));
        this.dcrLabel.setText(ElanLocale.getString("DCR.Label.ISOCategory"));
        this.dcrButton.setText(ElanLocale.getString("Button.Browse"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
        this.importSourceLabel.setText("<html>" + ElanLocale.getString("EditTypeDialog.Label.ImportSource") + "</html>");
        this.importSourceButton.setText(ElanLocale.getString("Button.Browse"));
        this.lexiconLabel.setText(ElanLocale.getString("EditTypeDialog.Label.Lexicon"));
        this.lexiconButton.setText(ElanLocale.getString("EditTypeDialog.Button.Lexicon"));
    }

    private void updateForMode() {
        switch (this.mode) {
            case 0: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Add"));
                this.currentTypesLabel.setText("");
                this.currentTypesComboBox.setEnabled(false);
                this.typeTextField.setEnabled(true);
                this.typeTextField.setEditable(true);
                this.typeTextField.setText("");
                this.constraintsComboBox.setEnabled(true);
                this.constraintsComboBox.setSelectedItem("None");
                this.timeAlignableCheckbox.setSelected(true);
                this.graphicReferencesCheckbox.setSelected(false);
                this.cvComboBox.setEnabled(true);
                this.cvComboBox.setSelectedItem("None");
                this.changeButton.setText(ElanLocale.getString("Button.Add"));
                this.changeButton.setEnabled(true);
                this.dcrButton.setEnabled(true);
                this.lexiconButton.setEnabled(true);
                break;
            }
            case 1: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Change"));
                this.currentTypesLabel.setText(ElanLocale.getString("EditTypeDialog.ChangeType"));
                this.changeButton.setText(ElanLocale.getString("Button.Change"));
                this.currentTypesComboBox.setEnabled(true);
                this.typeTextField.setEnabled(true);
                this.typeTextField.setEditable(true);
                this.constraintsComboBox.setEnabled(true);
                this.cvComboBox.setEnabled(true);
                if (this.currentTypesComboBox.getModel().getSize() > 0) {
                    this.updateUIForType((String)this.currentTypesComboBox.getItemAt(0));
                    this.currentTypesComboBox.addItemListener(this);
                } else {
                    this.changeButton.setEnabled(false);
                }
                this.dcrButton.setEnabled(true);
                this.lexiconButton.setEnabled(true);
                break;
            }
            case 2: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Delete"));
                this.currentTypesLabel.setText(ElanLocale.getString("EditTypeDialog.DeleteType"));
                this.changeButton.setText(ElanLocale.getString("Button.Delete"));
                this.currentTypesComboBox.setEnabled(true);
                this.typeTextField.setEnabled(false);
                this.typeTextField.setEditable(false);
                this.constraintsComboBox.setEnabled(false);
                this.cvComboBox.setEnabled(false);
                if (this.currentTypesComboBox.getModel().getSize() > 0) {
                    this.updateUIForType((String)this.currentTypesComboBox.getItemAt(0));
                    this.currentTypesComboBox.addItemListener(this);
                } else {
                    this.changeButton.setEnabled(false);
                }
                this.typeTextField.setEditable(false);
                this.constraintsComboBox.setEnabled(false);
                this.cvComboBox.setEnabled(false);
                this.graphicReferencesCheckbox.setEnabled(false);
                this.dcrButton.setEnabled(false);
                this.lexiconButton.setEnabled(false);
                break;
            }
            case 3: {
                this.setTitle(ElanLocale.getString("EditTypeDialog.Title.Import"));
                this.changeButton.setText(ElanLocale.getString("Button.Import"));
            }
        }
        this.titleLabel.setText(this.getTitle());
    }

    private void extractCurrentTypes() {
        this.currentTypesComboBox.removeItemListener(this);
        this.currentTypesComboBox.removeAllItems();
        this.types = this.transcription.getLinguisticTypes();
        if (this.types == null) {
            this.types = new Vector();
            return;
        }
        LinguisticType lt2 = null;
        for (LinguisticType lt2 : this.types) {
            this.currentTypesComboBox.addItem(lt2.getLinguisticTypeName());
        }
        this.currentTypesComboBox.addItemListener(this);
    }

    private void reextractTypes() {
        this.extractCurrentTypes();
        if (this.currentTypesComboBox.getItemCount() > 0) {
            this.currentTypesComboBox.setSelectedIndex(0);
            String name = (String)this.currentTypesComboBox.getSelectedItem();
            if (name != null) {
                this.updateUIForType(name);
            }
        } else {
            this.typeTextField.setText("");
            this.dcIdField.setText("");
            this.dcrField.setText("");
        }
        if (this.mode == 0) {
            this.typeTextField.setText("");
            this.dcIdField.setText("");
            this.dcrField.setText("");
        }
        if (this.model != null) {
            this.typeTable.getSelectionModel().removeListSelectionListener(this);
            this.model.removeAllRows();
            for (LinguisticType lt : this.types) {
                this.model.addRow(lt);
            }
            this.typeTable.getSelectionModel().addListSelectionListener(this);
        }
    }

    private void extractControlledVocabularies() {
        Vector cv = this.transcription.getControlledVocabularies();
        this.cvComboBox.addItem("None");
        for (int i = 0; i < cv.size(); ++i) {
            this.cvComboBox.addItem(((ControlledVocabulary)cv.get(i)).getName());
        }
    }

    private void updateUIForType(String typeName) {
        if (typeName != null) {
            this.typeTextField.setText(typeName);
            for (LinguisticType lt : this.types) {
                if (lt == null || !lt.getLinguisticTypeName().equals(typeName)) continue;
                if (this.currentTypesComboBox.getSelectedItem() != typeName) {
                    this.currentTypesComboBox.setSelectedItem(typeName);
                }
                this.constraintsComboBox.removeItemListener(this);
                Constraint oldC = lt.getConstraints();
                if (oldC != null) {
                    String stereoType;
                    this.oldConstraint = stereoType = Constraint.stereoTypes[oldC.getStereoType()];
                    this.constraintsComboBox.setSelectedItem(stereoType);
                } else {
                    this.oldConstraint = "None";
                    this.constraintsComboBox.setSelectedItem("None");
                }
                this.timeAlignableCheckbox.setSelected(lt.isTimeAlignable());
                this.graphicReferencesCheckbox.setSelected(lt.hasGraphicReferences());
                if (lt.isUsingControlledVocabulary()) {
                    String cvName = lt.getControlledVocabylaryName();
                    this.cvComboBox.getModel().setSelectedItem(cvName);
                } else {
                    this.cvComboBox.getModel().setSelectedItem("None");
                }
                if (lt.getDataCategory() != null) {
                    this.dcIdField.setText(lt.getDataCategory());
                    DCSmall small = ELANLocalDCRConnector.getInstance().getDCSmall(lt.getDataCategory());
                    if (small != null && small.getIdentifier() != null) {
                        this.dcrField.setText(small.getIdentifier());
                    } else {
                        this.dcrField.setText("");
                    }
                } else {
                    this.dcIdField.setText("");
                    this.dcrField.setText("");
                }
                if (lt.isUsingLexiconQueryBundle()) {
                    LexiconQueryBundle2 queryBundle = lt.getLexiconQueryBundle();
                    String linkName = queryBundle.getLinkName();
                    String fieldName = queryBundle.getFldId().getName();
                    this.lexiconLinkField.setText(linkName);
                    this.lexiconFieldField.setText(fieldName);
                    this.oldLexiconQueryBundle = queryBundle;
                } else {
                    this.lexiconLinkField.setText("");
                    this.lexiconFieldField.setText("");
                    this.oldLexiconQueryBundle = null;
                }
                this.newLexiconQueryBundle = this.oldLexiconQueryBundle;
                if (this.mode == 1) {
                    Vector tiers = this.transcription.getTiersWithLinguisticType(typeName);
                    if (tiers.size() > 0) {
                        this.constraintsComboBox.setEnabled(false);
                    } else {
                        this.constraintsComboBox.setEnabled(true);
                    }
                    if (lt.isTimeAlignable()) {
                        this.graphicReferencesCheckbox.setEnabled(true);
                    } else {
                        this.graphicReferencesCheckbox.setEnabled(false);
                    }
                }
                this.constraintsComboBox.addItemListener(this);
                if (this.model != null) {
                    this.typeTable.getSelectionModel().removeListSelectionListener(this);
                    int col = this.model.findColumn("Type");
                    for (int i = 0; i < this.model.getRowCount(); ++i) {
                        if (!typeName.equals(this.model.getValueAt(i, col))) continue;
                        this.typeTable.getSelectionModel().setLeadSelectionIndex(i);
                        this.typeTable.scrollRectToVisible(this.typeTable.getCellRect(i, col, true));
                        break;
                    }
                    this.typeTable.getSelectionModel().addListSelectionListener(this);
                }
                break;
            }
        } else {
            this.oldConstraint = "None";
            this.constraintsComboBox.setSelectedItem("None");
            this.cvComboBox.getModel().setSelectedItem("None");
            this.timeAlignableCheckbox.setSelected(true);
            this.graphicReferencesCheckbox.setSelected(false);
            this.dcIdField.setText("");
            this.dcrField.setText("");
        }
    }

    private Constraint getConstraintForName(String name) {
        ConstraintImpl c = null;
        if (name.equals(Constraint.stereoTypes[0])) {
            c = new TimeSubdivision();
        } else if (name.equals(Constraint.stereoTypes[3])) {
            c = new SymbolicSubdivision();
        } else if (name.equals(Constraint.stereoTypes[4])) {
            c = new SymbolicAssociation();
        } else if (name.equals(Constraint.stereoTypes[1])) {
            c = new IncludedIn();
        }
        return c;
    }

    private void checkGraphics(LinguisticType type) {
        Vector tiersOfType = this.transcription.getTiersWithLinguisticType(type.getLinguisticTypeName());
        boolean alreadyThere = false;
        Vector allTiers = this.transcription.getTiers();
        for (TierImpl tier : allTiers) {
            LinguisticType otherType = tier.getLinguisticType();
            if (otherType == type || !otherType.hasGraphicReferences()) continue;
            alreadyThere = true;
            break;
        }
        if (!alreadyThere && tiersOfType.size() > 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Graphics"), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    private void doAdd(String name) {
        LinguisticType lt2 = null;
        for (LinguisticType lt2 : this.types) {
            if (!lt2.getLinguisticTypeName().equals(name)) continue;
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.Exists");
            this.typeTextField.requestFocus();
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        String cons = (String)this.constraintsComboBox.getSelectedItem();
        Constraint c = this.getConstraintForName(cons);
        boolean alignable = this.timeAlignableCheckbox.isSelected();
        boolean graphicsRef = this.graphicReferencesCheckbox.isSelected();
        String cvName = (String)this.cvComboBox.getSelectedItem();
        String dcId = this.dcIdField.getText();
        if (dcId != null && dcId.length() == 0) {
            dcId = null;
        }
        if (cvName.equals("None")) {
            cvName = null;
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.AddNewType");
        Object[] args = new Object[]{name, c, cvName, new Boolean(alignable), new Boolean(graphicsRef), dcId, this.newLexiconQueryBundle};
        com.execute(this.transcription, args);
        this.reextractTypes();
        if (this.currentTypesComboBox.getItemCount() > 0) {
            this.currentTypesComboBox.setSelectedIndex(this.currentTypesComboBox.getItemCount() - 1);
        }
    }

    private void doChange(String name) {
        String warning;
        int option;
        String oldName = (String)this.currentTypesComboBox.getSelectedItem();
        LinguisticType lt = null;
        LinguisticType iterType2 = null;
        for (LinguisticType iterType2 : this.types) {
            if (iterType2.getLinguisticTypeName().equals(oldName)) {
                lt = iterType2;
            }
            if (!iterType2.getLinguisticTypeName().equals(name) || iterType2 == lt) continue;
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.Exists");
            this.typeTextField.requestFocus();
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        if (lt == null) {
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.UnknownError");
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        String oldCV = null;
        if (lt.isUsingControlledVocabulary()) {
            oldCV = lt.getControlledVocabylaryName();
        }
        boolean oldGraphicsRef = lt.hasGraphicReferences();
        String cons = (String)this.constraintsComboBox.getSelectedItem();
        Constraint c = this.getConstraintForName(cons);
        String cvName = (String)this.cvComboBox.getSelectedItem();
        if (cvName.equals("None")) {
            cvName = null;
        }
        boolean alignable = this.timeAlignableCheckbox.isSelected();
        boolean graphicsRef = this.graphicReferencesCheckbox.isSelected();
        String oldDcId = lt.getDataCategory();
        String dcId = this.dcIdField.getText();
        if (name.equals(oldName) && (c == null && lt.getConstraints() == null || c != null && c.equals(lt.getConstraints())) && (oldCV == null && cvName == null || oldCV != null && oldCV.equals(cvName)) && lt.isTimeAlignable() == alignable && oldGraphicsRef == graphicsRef && (oldDcId == null && dcId == null || oldDcId != null && oldDcId.equals(dcId)) && this.oldLexiconQueryBundle == this.newLexiconQueryBundle) {
            return;
        }
        if (oldGraphicsRef && !graphicsRef && (option = JOptionPane.showConfirmDialog(this, warning = ElanLocale.getString("EditTypeDialog.Message.GraphicsLost") + "\n" + ElanLocale.getString("EditTypeDialog.Message.Confirm"), ElanLocale.getString("Message.Warning"), 0, 3)) != 0) {
            return;
        }
        if (graphicsRef) {
            this.checkGraphics(lt);
        }
        Object[] args = new Object[]{name, c, cvName, new Boolean(alignable), new Boolean(graphicsRef), lt, dcId, this.newLexiconQueryBundle};
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.ChangeType");
        com.execute(this.transcription, args);
        int curRow = this.currentTypesComboBox.getSelectedIndex();
        this.reextractTypes();
        if (curRow > -1) {
            this.currentTypesComboBox.setSelectedIndex(curRow);
        }
    }

    private void doDelete() {
        String oldName = (String)this.currentTypesComboBox.getSelectedItem();
        LinguisticType lt = null;
        Iterator tIter = this.types.iterator();
        while (tIter.hasNext() && !(lt = (LinguisticType)tIter.next()).getLinguisticTypeName().equals(oldName)) {
        }
        if (lt == null) {
            String errorMessage = ElanLocale.getString("EditTypeDialog.Message.UnknownError");
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        Vector clientTiers = this.transcription.getTiersWithLinguisticType(oldName);
        if (clientTiers.size() > 0) {
            StringBuffer errorBuffer = new StringBuffer(ElanLocale.getString("EditTypeDialog.Message.TypeInUse"));
            errorBuffer.append(":\n");
            Iterator clIter = clientTiers.iterator();
            while (clIter.hasNext()) {
                errorBuffer.append("- ");
                errorBuffer.append(((Tier)clIter.next()).getName());
                errorBuffer.append("\n");
            }
            errorBuffer.append(ElanLocale.getString("EditTypeDialog.Message.Reassign"));
            JOptionPane.showMessageDialog(this, errorBuffer.toString(), ElanLocale.getString("Message.Warning"), 0);
            return;
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.DeleteType");
        com.execute(this.transcription, new Object[]{lt});
        this.reextractTypes();
    }

    private void doImport() {
        String fileName = this.importSourceTF.getText();
        if (!this.isValidFile(fileName)) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.SelectValid"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.ImportTypes");
        c.execute(this.transcription, new Object[]{fileName});
        this.reextractTypes();
        this.updateUIForType(null);
    }

    private void promptForImportFile() {
        String eafDir = (String)Preferences.get("LastUsedEAFDir", null);
        if (eafDir == null) {
            eafDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Select");
        chooser.setCurrentDirectory(new File(eafDir));
        chooser.setDialogTitle(ElanLocale.getString("EditTierDialog.Title.Select"));
        File eafFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(3);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(ElanFileFilter.createFileFilter(4));
        if (chooser.showOpenDialog(this) == 0) {
            String name;
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedEAFDir", curDir.getAbsolutePath(), null);
            }
            if ((eafFile = chooser.getSelectedFile()) != null && this.isValidFile(name = eafFile.getAbsolutePath())) {
                this.importSourceTF.setText(name);
            }
        }
    }

    private boolean isValidFile(String fileName) {
        int i;
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            return false;
        }
        String lowerPathName = fileName.toLowerCase();
        String[] exts = FileExtension.EAF_EXT;
        for (i = 0; i < exts.length; ++i) {
            if (!lowerPathName.endsWith("." + exts[i])) continue;
            return true;
        }
        exts = FileExtension.TEMPLATE_EXT;
        for (i = 0; i < exts.length; ++i) {
            if (!lowerPathName.endsWith("." + exts[i])) continue;
            return true;
        }
        return false;
    }

    private void selectDataCategory() {
        Object valueObj;
        List vals;
        ELANDCRDialog dialog = new ELANDCRDialog((Dialog)this, true, 1);
        dialog.pack();
        dialog.setVisible(true);
        Object selValue = dialog.getValue();
        if (selValue instanceof List && (vals = (List)selValue).size() > 0 && (valueObj = vals.get(0)) instanceof DCSmall) {
            DCSmall dcs = (DCSmall)valueObj;
            this.dcrField.setText(dcs.getIdentifier());
            this.dcIdField.setText(dcs.getId());
        }
    }

    private void selectLexiconService() {
        String typeName = (String)this.currentTypesComboBox.getSelectedItem();
        for (LinguisticType lt : this.types) {
            if (lt == null || !lt.getLinguisticTypeName().equals(typeName)) continue;
            if (this.newLexiconQueryBundle != null) {
                LexiconLink link = this.newLexiconQueryBundle.getLink();
                LexiconQueryBundleDialog bundleDialog = new LexiconQueryBundleDialog((Dialog)this, true, this.transcription, this.newLexiconQueryBundle);
                bundleDialog.pack();
                bundleDialog.setVisible(true);
                if (bundleDialog.isCanceled()) break;
                this.newLexiconQueryBundle = bundleDialog.getBundle();
                break;
            }
            LexiconQueryBundleDialog bundleDialog = new LexiconQueryBundleDialog((Dialog)this, true, this.transcription);
            bundleDialog.pack();
            bundleDialog.setVisible(true);
            if (bundleDialog.isCanceled()) break;
            this.newLexiconQueryBundle = bundleDialog.getBundle();
            break;
        }
        if (this.newLexiconQueryBundle != null) {
            this.lexiconLinkField.setText(this.newLexiconQueryBundle.getLinkName());
            this.lexiconFieldField.setText(this.newLexiconQueryBundle.getFldId().getName());
        } else {
            this.lexiconLinkField.setText("");
            this.lexiconFieldField.setText("");
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.changeButton) {
            if (this.mode == 2) {
                this.doDelete();
            } else if (this.mode == 3) {
                this.doImport();
            } else {
                String typeName = this.typeTextField.getText();
                typeName.replace('\n', ' ');
                typeName.trim();
                if (typeName.length() == 0) {
                    String errorMessage = ElanLocale.getString("EditTypeDialog.Message.TypeName");
                    this.typeTextField.requestFocus();
                    JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
                    return;
                }
                switch (this.mode) {
                    case 0: {
                        this.doAdd(typeName);
                        break;
                    }
                    case 1: {
                        this.doChange(typeName);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        } else if (event.getSource() == this.importSourceButton) {
            this.promptForImportFile();
        } else if (event.getSource() == this.dcrButton) {
            this.selectDataCategory();
        } else if (event.getSource() == this.lexiconButton) {
            this.selectLexiconService();
        } else {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.currentTypesComboBox && e.getStateChange() == 1) {
            String name = (String)this.currentTypesComboBox.getSelectedItem();
            if (name != null) {
                this.updateUIForType(name);
            }
        } else if (e.getSource() == this.constraintsComboBox && e.getStateChange() == 1) {
            String typeName;
            Vector tiers;
            String constraint = (String)this.constraintsComboBox.getSelectedItem();
            if (constraint == "Symbolic Subdivision" || constraint == "Symbolic Association") {
                this.timeAlignableCheckbox.setSelected(false);
                this.graphicReferencesCheckbox.setSelected(false);
                this.graphicReferencesCheckbox.setEnabled(false);
            } else {
                this.timeAlignableCheckbox.setSelected(true);
                this.graphicReferencesCheckbox.setEnabled(true);
            }
            if (this.mode == 1 && this.oldConstraint != constraint && (tiers = this.transcription.getTiersWithLinguisticType(typeName = (String)this.currentTypesComboBox.getSelectedItem())).size() > 0) {
                StringBuffer mesBuf = new StringBuffer(ElanLocale.getString("EditTypeDialog.Message.TypeInUse"));
                mesBuf.append("\n");
                mesBuf.append(ElanLocale.getString("EditTypeDialog.Message.Corrupt"));
                JOptionPane.showMessageDialog(this, mesBuf.toString(), ElanLocale.getString("Message.Warning"), 2);
                this.updateUIForType(typeName);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.tabPane.removeChangeListener(this);
        this.mode = this.tabPane.getSelectedIndex();
        this.tabPane.removeAll();
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Import"), this.importPanel);
        if (this.mode < 3) {
            this.tabPane.setComponentAt(this.tabPane.getSelectedIndex(), this.editPanel);
        } else {
            this.tabPane.setComponentAt(1, this.editPanel);
        }
        this.tabPane.setSelectedIndex(this.mode);
        this.updateForMode();
        this.tabPane.revalidate();
        this.tabPane.addChangeListener(this);
        if ((this.mode == 1 || this.mode == 2) && this.currentTypesComboBox.getItemCount() > 0) {
            String name = (String)this.currentTypesComboBox.getSelectedItem();
            this.updateUIForType(name);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.mode == 0) {
            return;
        }
        int row = this.typeTable.getSelectedRow();
        if (row > -1) {
            int column = this.model.findColumn("Type");
            this.updateUIForType((String)this.model.getValueAt(row, column));
        }
    }
}

