/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.MultiFileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportTiersDialog
extends ClosableDialog
implements ListSelectionListener,
ClientLogger {
    private JFrame parent;
    private ArrayList<TranscriptionImpl> transImplList;
    private File[] eafFiles;
    private int progressValue;
    private boolean filesOpened;
    private boolean exportingStarted;
    private ButtonGroup exportButtonGroup;
    private ButtonGroup dependentTiersBtnGroup;
    private ButtonGroup saveTierBtnGroup;
    private ButtonGroup fileNameBtnGroup;
    private ButtonGroup suffixBtnGroup;
    private JLabel descriptionLabel;
    private JLabel progressBarLabel;
    private JLabel numberOfFilesLabel;
    private JTable tierTable;
    private JTable linguisticTypeTable;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JButton exportButton;
    private JButton cancelButton;
    private JButton browseBtn;
    private JCheckBox dontExportFilesWithoutTiersCB;
    private JLabel dependentTiersLabel;
    private JLabel directoryOptionsLabel;
    private JLabel exportLabel;
    private JLabel resultingFilenameLabel;
    private JLabel otherOptionLabel;
    private JRadioButton exportTiersRB;
    private JRadioButton exportLingTypesRB;
    private JRadioButton includeParentTiersRB;
    private JRadioButton neglectDependentTiersRB;
    private JRadioButton originalDirRB;
    private JRadioButton togetherInSameDirRB;
    private JRadioButton newDirectoryRB;
    private JRadioButton originalFileNameRB;
    private JRadioButton addSuffixRB;
    private JRadioButton originalFileNameWithSuffixRB;
    private JRadioButton useBaseNameWithSuffixRB;
    private JScrollPane tierListScrollPane;
    private JScrollPane linguisticTypeScrollPane;
    private JTabbedPane tabbedPane;
    private JTextField sameDirectoryTextField;
    private JTextField localDirectoryTextField;
    private JTextField suffixNameTextField;
    private JTextField baseNameTextField;
    private JProgressBar progressBar;
    private JPanel tierListPanel;
    private JPanel tierListDetailsPanel;
    private JPanel selectButtonPanel;
    private JPanel optionPanel;
    private JPanel exportButtonsPanel;
    private JPanel exportPanel;
    private JPanel dependentTiersOptionPanel;
    private JPanel fileNameOptionsPanel;
    private JPanel directoryOptionsPanel;
    private JPanel otherOptionsPanel;
    private String browseDirText;

    public ExportTiersDialog(JFrame parentFrame, List<File> files) {
        super(parentFrame);
        this.parent = parentFrame;
        this.filesOpened = false;
        this.exportingStarted = false;
        if (files == null) {
            return;
        }
        boolean inited = this.initFilesArray(files);
        if (!inited) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        this.initComponents();
        this.layoutComponents();
        this.loadEAFs();
        this.updateLocale();
        this.setVisible(true);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(16.0f));
        this.tierListPanel = new JPanel();
        this.tierTable = new JTable(new TierTableModel());
        this.tierTable.setSelectionMode(0);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierListScrollPane = new JScrollPane(this.tierTable);
        this.tierListScrollPane.setPreferredSize(new Dimension(180, 100));
        this.tierListScrollPane.setColumnHeaderView(null);
        this.tierListDetailsPanel = new JPanel();
        this.numberOfFilesLabel = new JLabel();
        this.selectButtonPanel = new JPanel();
        this.selectAllButton = new JButton();
        this.selectNoneButton = new JButton();
        this.linguisticTypeTable = new JTable(new TierTableModel());
        this.linguisticTypeTable.setSelectionMode(0);
        this.linguisticTypeTable.getSelectionModel().addListSelectionListener(this);
        this.linguisticTypeTable.setShowVerticalLines(false);
        this.linguisticTypeTable.setTableHeader(null);
        this.linguisticTypeScrollPane = new JScrollPane(this.linguisticTypeTable);
        this.linguisticTypeScrollPane.setPreferredSize(new Dimension(180, 100));
        this.linguisticTypeScrollPane.setColumnHeaderView(null);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("", this.tierListScrollPane);
        this.tabbedPane.addTab("", this.linguisticTypeScrollPane);
        this.optionPanel = new JPanel();
        this.exportPanel = new JPanel();
        this.exportTiersRB = new JRadioButton("", true);
        this.exportLingTypesRB = new JRadioButton();
        this.exportButtonGroup = new ButtonGroup();
        this.exportButtonGroup.add(this.exportTiersRB);
        this.exportButtonGroup.add(this.exportLingTypesRB);
        this.dependentTiersOptionPanel = new JPanel();
        this.dependentTiersLabel = new JLabel();
        this.includeParentTiersRB = new JRadioButton("", true);
        this.neglectDependentTiersRB = new JRadioButton();
        this.dependentTiersBtnGroup = new ButtonGroup();
        this.dependentTiersBtnGroup.add(this.includeParentTiersRB);
        this.dependentTiersBtnGroup.add(this.neglectDependentTiersRB);
        this.fileNameOptionsPanel = new JPanel();
        this.resultingFilenameLabel = new JLabel();
        this.originalFileNameRB = new JRadioButton("", true);
        this.addSuffixRB = new JRadioButton();
        this.fileNameBtnGroup = new ButtonGroup();
        this.fileNameBtnGroup.add(this.originalFileNameRB);
        this.fileNameBtnGroup.add(this.addSuffixRB);
        this.suffixBtnGroup = new ButtonGroup();
        this.originalFileNameWithSuffixRB = new JRadioButton("", true);
        this.originalFileNameWithSuffixRB.setEnabled(false);
        this.suffixNameTextField = new JTextField();
        this.suffixNameTextField.setEnabled(false);
        this.useBaseNameWithSuffixRB = new JRadioButton();
        this.useBaseNameWithSuffixRB.setEnabled(false);
        this.baseNameTextField = new JTextField();
        this.baseNameTextField.setEnabled(false);
        this.suffixBtnGroup.add(this.originalFileNameWithSuffixRB);
        this.suffixBtnGroup.add(this.useBaseNameWithSuffixRB);
        this.directoryOptionsPanel = new JPanel();
        this.directoryOptionsLabel = new JLabel();
        this.originalDirRB = new JRadioButton("", true);
        this.newDirectoryRB = new JRadioButton();
        this.togetherInSameDirRB = new JRadioButton();
        this.saveTierBtnGroup = new ButtonGroup();
        this.saveTierBtnGroup.add(this.originalDirRB);
        this.saveTierBtnGroup.add(this.togetherInSameDirRB);
        this.saveTierBtnGroup.add(this.newDirectoryRB);
        this.localDirectoryTextField = new JTextField();
        this.localDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField = new JTextField();
        this.sameDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField.setEditable(false);
        this.browseBtn = new JButton();
        this.browseBtn.setEnabled(false);
        this.otherOptionsPanel = new JPanel();
        this.otherOptionLabel = new JLabel();
        this.dontExportFilesWithoutTiersCB = new JCheckBox();
        this.progressBar = new JProgressBar(0, this.eafFiles.length);
        this.progressBar.setValue(this.progressValue);
        this.progressBar.setStringPainted(true);
        this.progressValue = 0;
        this.exportButtonsPanel = new JPanel();
        this.exportButton = new JButton();
        this.exportButton.setEnabled(false);
        this.cancelButton = new JButton();
        RadioButtonHandler radioBtnListener = new RadioButtonHandler();
        ButtonHandler buttonListener = new ButtonHandler();
        TextFieldHandler keyListener = new TextFieldHandler();
        this.originalDirRB.addActionListener(radioBtnListener);
        this.newDirectoryRB.addActionListener(radioBtnListener);
        this.togetherInSameDirRB.addActionListener(radioBtnListener);
        this.originalFileNameRB.addActionListener(radioBtnListener);
        this.addSuffixRB.addActionListener(radioBtnListener);
        this.originalFileNameWithSuffixRB.addActionListener(radioBtnListener);
        this.useBaseNameWithSuffixRB.addActionListener(radioBtnListener);
        this.browseBtn.addActionListener(buttonListener);
        this.exportButton.addActionListener(buttonListener);
        this.cancelButton.addActionListener(buttonListener);
        this.selectAllButton.addActionListener(buttonListener);
        this.selectNoneButton.addActionListener(buttonListener);
        this.suffixNameTextField.addKeyListener(keyListener);
        this.baseNameTextField.addKeyListener(keyListener);
        this.localDirectoryTextField.addKeyListener(keyListener);
    }

    private void layoutComponents() {
        Insets noTabInset = new Insets(0, 5, 3, 4);
        Insets singleTabInset = new Insets(0, 15, 3, 0);
        Insets doubleTabInset = new Insets(0, 35, 3, 0);
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setPreferredSize(new Dimension(this.descriptionLabel.getWidth(), 25));
        this.tierListPanel.setLayout(new BorderLayout());
        this.tierListDetailsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.insets = noTabInset;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.tierListDetailsPanel.add((Component)this.exportPanel, gbc);
        gbc.gridy = 1;
        gbc.anchor = 10;
        this.tierListDetailsPanel.add((Component)this.numberOfFilesLabel, gbc);
        gbc.gridy = 2;
        gbc.anchor = 10;
        this.tierListDetailsPanel.add((Component)this.selectButtonPanel, gbc);
        this.selectButtonPanel.setLayout(new FlowLayout(0));
        this.selectButtonPanel.add(this.selectAllButton);
        this.selectButtonPanel.add(this.selectNoneButton);
        this.tierListPanel.add((Component)this.tabbedPane, "Center");
        this.tierListPanel.add((Component)this.tierListDetailsPanel, "South");
        this.exportPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = noTabInset;
        this.exportPanel.add((Component)this.exportTiersRB, gbc);
        gbc.gridy = 1;
        gbc.insets = noTabInset;
        this.exportPanel.add((Component)this.exportLingTypesRB, gbc);
        this.dependentTiersOptionPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = noTabInset;
        this.dependentTiersOptionPanel.add((Component)this.dependentTiersLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = singleTabInset;
        this.dependentTiersOptionPanel.add((Component)this.includeParentTiersRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = singleTabInset;
        this.dependentTiersOptionPanel.add((Component)this.neglectDependentTiersRB, gbc);
        this.fileNameOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = noTabInset;
        this.fileNameOptionsPanel.add((Component)this.resultingFilenameLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.insets = singleTabInset;
        this.fileNameOptionsPanel.add((Component)this.originalFileNameRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = singleTabInset;
        this.fileNameOptionsPanel.add((Component)this.addSuffixRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = doubleTabInset;
        this.fileNameOptionsPanel.add((Component)this.originalFileNameWithSuffixRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = noTabInset;
        gbc.weightx = 1.0;
        this.fileNameOptionsPanel.add((Component)this.suffixNameTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = doubleTabInset;
        this.fileNameOptionsPanel.add((Component)this.useBaseNameWithSuffixRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = noTabInset;
        gbc.weightx = 1.0;
        this.fileNameOptionsPanel.add((Component)this.baseNameTextField, gbc);
        this.directoryOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = noTabInset;
        this.directoryOptionsPanel.add((Component)this.directoryOptionsLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = singleTabInset;
        this.directoryOptionsPanel.add((Component)this.originalDirRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.insets = singleTabInset;
        this.directoryOptionsPanel.add((Component)this.newDirectoryRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.insets = noTabInset;
        this.directoryOptionsPanel.add((Component)this.localDirectoryTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.insets = singleTabInset;
        this.directoryOptionsPanel.add((Component)this.togetherInSameDirRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = noTabInset;
        this.sameDirectoryTextField.setMinimumSize(new Dimension(194, this.sameDirectoryTextField.getMinimumSize().height));
        this.directoryOptionsPanel.add((Component)this.sameDirectoryTextField, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.insets = noTabInset;
        this.directoryOptionsPanel.add((Component)this.browseBtn, gbc);
        this.otherOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = noTabInset;
        this.otherOptionsPanel.add((Component)this.otherOptionLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = singleTabInset;
        this.otherOptionsPanel.add((Component)this.dontExportFilesWithoutTiersCB, gbc);
        this.exportButtonsPanel.setLayout(new FlowLayout(2));
        this.exportButton.setSize(this.cancelButton.getSize());
        this.exportButtonsPanel.add(this.exportButton);
        this.exportButtonsPanel.add(this.cancelButton);
        this.optionPanel.setLayout(new BoxLayout(this.optionPanel, 1));
        this.optionPanel.setAlignmentX(0.0f);
        this.optionPanel.add(this.dependentTiersOptionPanel);
        this.optionPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        this.optionPanel.add(this.fileNameOptionsPanel);
        this.optionPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        this.optionPanel.add(this.directoryOptionsPanel);
        this.optionPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        this.optionPanel.add(this.otherOptionsPanel);
        JPanel container = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 19;
        container.add((Component)this.descriptionLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 19;
        container.add((Component)this.tierListPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.fill = 1;
        container.add((Component)this.optionPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.fill = 2;
        gbc.anchor = 25;
        container.add((Component)this.progressBar, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 20;
        container.add((Component)this.exportButtonsPanel, gbc);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 8, 3, 7);
        gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0);
        this.getContentPane().add((Component)container, gbc);
    }

    private void updateTierList(ArrayList<String> tierNames, ArrayList<String> linguisticTypes) {
        this.tierTable.setModel(new TierTableModel(tierNames));
        if (this.tierTable.getColumnCount() == 2) {
            this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        }
        this.linguisticTypeTable.setModel(new TierTableModel(linguisticTypes));
        if (this.linguisticTypeTable.getColumnCount() == 2) {
            this.linguisticTypeTable.getColumnModel().getColumn(0).setMaxWidth(30);
        }
        this.filesOpened = true;
        this.updateExportButtonEnabled();
    }

    private void updateExportButtonEnabled() {
        if (!this.filesOpened) {
            this.exportButton.setEnabled(false);
            return;
        }
        boolean b = true;
        if (this.togetherInSameDirRB.isSelected() && this.sameDirectoryTextField.getText().equals(this.browseDirText)) {
            b = false;
        }
        if (this.newDirectoryRB.isSelected() && this.localDirectoryTextField.getText().length() <= 0) {
            b = false;
        }
        if (this.addSuffixRB.isSelected()) {
            if (this.originalFileNameWithSuffixRB.isSelected() && this.suffixNameTextField.getText().length() <= 0) {
                b = false;
            } else if (this.useBaseNameWithSuffixRB.isSelected() && this.baseNameTextField.getText().length() <= 0) {
                b = false;
            }
        }
        this.exportButton.setEnabled(b && !this.exportingStarted);
    }

    private void removeDuplicates(List list) {
        HashSet set = new HashSet();
        ArrayList newList = new ArrayList();
        for (Object element : list) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        list.clear();
        list.addAll(newList);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("ExportTiersDialog.Title"));
        this.descriptionLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.Description"));
        this.tierListPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.List.Title")));
        this.optionPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.OptionPanel.Title")));
        this.exportPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.Title.ExportOptions")));
        this.neglectDependentTiersRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.NeglectDependentTiers"));
        this.includeParentTiersRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.IncludeParentTiersRB"));
        this.exportButton.setText(ElanLocale.getString("ExportTiersDialog.Button.Export"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.selectAllButton.setText(ElanLocale.getString("Button.SelectAll"));
        this.selectNoneButton.setText(ElanLocale.getString("Button.SelectNone"));
        this.originalFileNameRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalFileName"));
        this.originalFileNameWithSuffixRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalFileNameWithSuffix"));
        this.useBaseNameWithSuffixRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.NewBaseNameWithSuffix"));
        this.numberOfFilesLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.NumberOfFiles") + " " + this.eafFiles.length);
        this.originalDirRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalDirectory"));
        this.newDirectoryRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.NewDirectory"));
        this.togetherInSameDirRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.TogetherInSameDirectory"));
        this.browseBtn.setText(ElanLocale.getString("ExportTiersDialog.Button.Browse"));
        this.baseNameTextField.setText(ElanLocale.getString("ExportTiersDialog.TextField.DefaultBaseName"));
        this.suffixNameTextField.setText(ElanLocale.getString("ExportTiersDialog.TextField.DefaultSuffixName"));
        this.localDirectoryTextField.setText(ElanLocale.getString("ExportTiersDialog.TextField.DefaultLocalDirectoryName"));
        this.browseDirText = ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField");
        this.sameDirectoryTextField.setText(this.browseDirText);
        this.dependentTiersLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.DependentTierOptions"));
        this.directoryOptionsLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.SaveTiersOptions"));
        this.resultingFilenameLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.FileNameOptions"));
        this.otherOptionLabel.setText(ElanLocale.getString("ExportTiersDialog.Label.OtherOptions"));
        this.tabbedPane.setTitleAt(0, ElanLocale.getString("ExportTiersDialog.Tab1"));
        this.tabbedPane.setTitleAt(1, ElanLocale.getString("ExportTiersDialog.Tab2"));
        this.exportTiersRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.ExportTiers"));
        this.exportLingTypesRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.ExportLingTypes"));
        this.dontExportFilesWithoutTiersCB.setText(ElanLocale.getString("ExportTiersDialog.CheckBox.ExportFilesWithoutTiers"));
        this.addSuffixRB.setText(ElanLocale.getString("ExportTiersDialog.RadioButton.addSuffix"));
    }

    private boolean initFilesArray(List<File> files) {
        int answer;
        boolean allFilesExist = true;
        int numExist = 0;
        for (File f : files) {
            if (f == null) continue;
            if (f.exists()) {
                ++numExist;
                continue;
            }
            allFilesExist = false;
        }
        if (!allFilesExist && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("ExportTiersDialog.Message.NotAllFilesExist"), ElanLocale.getString("ExportTiersDialog.Message.NotAllFilesExistTitle"), 0)) != 0) {
            return false;
        }
        this.eafFiles = new File[numExist];
        int index = 0;
        for (File f : files) {
            if (f == null || !f.exists()) continue;
            this.eafFiles[index] = f;
            ++index;
        }
        return true;
    }

    private boolean showMultiFileChooser() {
        String dirPath = (String)Preferences.get("LastUsedEAFDir", null);
        if (dirPath == null) {
            dirPath = System.getProperty("user.dir");
        }
        MultiFileChooser multiFileChooser = new MultiFileChooser();
        multiFileChooser.setCurrentDirectory(new File(dirPath));
        multiFileChooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"));
        multiFileChooser.setFileFilter(ElanFileFilter.createFileFilter(3));
        int returnValue = multiFileChooser.showDialog(this, "OK");
        if (returnValue == 0) {
            int answer;
            Object[] objects = multiFileChooser.getFiles();
            this.eafFiles = new File[objects.length];
            boolean allFilesExist = true;
            for (int i = 0; i < objects.length; ++i) {
                File file = (File)objects[i];
                if (file.exists()) {
                    this.eafFiles[i] = file;
                    continue;
                }
                allFilesExist = false;
            }
            if (!allFilesExist && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("ExportTiersDialog.Message.NotAllFilesExist"), ElanLocale.getString("ExportTiersDialog.Message.NotAllFilesExistTitle"), 0)) != 0) {
                return false;
            }
            Preferences.set("LastUsedEAFDir", new File(this.eafFiles[this.eafFiles.length - 1].getAbsolutePath()).getParent(), null);
            return true;
        }
        this.setVisible(false);
        this.dispose();
        return false;
    }

    private String showDirectoryChooser() {
        String dirPath = (String)Preferences.get("LastUsedEAFDir", null);
        if (dirPath == null) {
            dirPath = System.getProperty("user.dir");
        }
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setCurrentDirectory(new File(dirPath));
        dirChooser.setFileSelectionMode(1);
        dirChooser.setDialogTitle(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"));
        int returnVal = dirChooser.showDialog(this, "OK");
        if (returnVal == 0) {
            File selectedDir = dirChooser.getSelectedFile();
            if (!selectedDir.exists()) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTiersDialog.Message.DirectoryDoesntExist"), ElanLocale.getString("ExportTiersDialog.Message.DirectoryDoesntExistTitle"), 0);
                return this.showDirectoryChooser();
            }
            Preferences.set("LastUsedEAFDir", new File(this.eafFiles[this.eafFiles.length - 1].getAbsolutePath()).getParent(), null);
            return selectedDir.getAbsolutePath();
        }
        return null;
    }

    private void loadEAFs() {
        OpenFilesThread t = new OpenFilesThread();
        t.start();
    }

    private void saveFiles(List<String> tiersToSave) {
        SaveFileThread t = new SaveFileThread(tiersToSave);
        t.start();
    }

    private boolean exists(String string, ArrayList<String> stringList) {
        return stringList.indexOf(string) >= 0;
    }

    private JTable getActiveTable() {
        boolean TIER_TAB = false;
        boolean LINGUISTIC_TYPE_TAB = true;
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                return this.tierTable;
            }
            case 1: {
                return this.linguisticTypeTable;
            }
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (e.getValueIsAdjusting()) {
            int selectedRow = lsm.getMinSelectionIndex();
            JTable activeTable = this.getActiveTable();
            if (selectedRow >= 0) {
                activeTable.setValueAt((Boolean)activeTable.getValueAt(selectedRow, 0) == false, selectedRow, 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TierTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] rowData;

        public TierTableModel(List<String> tierNameList) {
            this.columnNames = new String[2];
            this.rowData = new Object[tierNameList.size()][2];
            for (int i = 0; i < tierNameList.size(); ++i) {
                this.rowData[i][0] = false;
                this.rowData[i][1] = new String(tierNameList.get(i));
            }
        }

        public TierTableModel(String[] labels) {
            this.columnNames = new String[]{"Information"};
            this.rowData = new String[labels.length][1];
            for (int i = 0; i < labels.length; ++i) {
                this.rowData[i][0] = labels[i];
            }
        }

        public TierTableModel() {
            this.columnNames = new String[1];
            this.rowData = new Object[1][1];
            this.rowData[0][0] = ElanLocale.getString("ExportTiersDialog.TableModel.DefaultMessage");
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public void setValueAt(Object object, int row, int column) {
            if (column == 0) {
                this.rowData[row][column] = object;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col <= 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rowData[rowIndex][columnIndex];
        }

        public List<String> getSelectedTiers() {
            ArrayList<String> tierNameList = new ArrayList<String>();
            if (this.columnNames.length == 2) {
                for (int i = 0; i < this.rowData.length; ++i) {
                    if (!((Boolean)this.rowData[i][0]).booleanValue()) continue;
                    tierNameList.add((String)this.rowData[i][1]);
                }
            }
            return tierNameList;
        }
    }

    private class OpenFilesThread
    extends Thread {
        private OpenFilesThread() {
        }

        public void run() {
            String txt = String.format(ElanLocale.getString("ExportTiersDialog.Message.LoadingTiers"), Float.valueOf(0.0f), "%");
            ExportTiersDialog.this.tierTable.setModel(new TierTableModel(new String[]{txt, ElanLocale.getString("ExportTiersDialog.Message.Loading")}));
            txt = String.format(ElanLocale.getString("ExportTiersDialog.Message.LoadingLinguisticTypes"), Float.valueOf(0.0f), "%");
            ExportTiersDialog.this.linguisticTypeTable.setModel(new TierTableModel(new String[]{txt, ElanLocale.getString("ExportTiersDialog.Message.Loading")}));
            ExportTiersDialog.this.transImplList = new ArrayList();
            ArrayList<String> tierNames = new ArrayList<String>();
            ArrayList<String> linguisticTypes = new ArrayList<String>();
            for (int i = 0; i < ExportTiersDialog.this.eafFiles.length; ++i) {
                if (ExportTiersDialog.this.eafFiles[i] == null) continue;
                ExportTiersDialog.this.transImplList.add(new TranscriptionImpl(ExportTiersDialog.this.eafFiles[i].getAbsolutePath()));
                Vector listOfTiers = ((TranscriptionImpl)ExportTiersDialog.this.transImplList.get(i)).getTiers();
                for (int j = 0; j < listOfTiers.size(); ++j) {
                    tierNames.add(((TierImpl)listOfTiers.get(j)).getName());
                    linguisticTypes.add(((TierImpl)listOfTiers.get(j)).getLinguisticType().getLinguisticTypeName());
                }
                if (i % 10 != 0) continue;
                txt = String.format(ElanLocale.getString("ExportTiersDialog.Message.LoadingTiers"), Float.valueOf(100.0f * (float)i / (float)ExportTiersDialog.this.eafFiles.length), "%");
                ExportTiersDialog.this.tierTable.setValueAt(txt, 0, 0);
                txt = String.format(ElanLocale.getString("ExportTiersDialog.Message.LoadingLinguisticTypes"), Float.valueOf(100.0f * (float)i / (float)ExportTiersDialog.this.eafFiles.length), "%");
                ExportTiersDialog.this.linguisticTypeTable.setValueAt(txt, 0, 0);
                ExportTiersDialog.this.tierTable.repaint();
                ExportTiersDialog.this.linguisticTypeTable.repaint();
            }
            Collections.sort(tierNames);
            Collections.sort(linguisticTypes);
            ExportTiersDialog.this.removeDuplicates(tierNames);
            ExportTiersDialog.this.removeDuplicates(linguisticTypes);
            ExportTiersDialog.this.updateTierList(tierNames, linguisticTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SaveFileThread
    extends Thread {
        private ArrayList<String> tiersToSave;
        private final int YES = 1;
        private final int NO = 2;
        private final int YES_TO_ALL = 0;
        private final int NO_TO_ALL = 3;
        private final boolean originalDirRB;
        private final boolean newDirectoryRB;
        private final boolean togetherInSameDirRB;
        private final boolean originalFileNameRB;
        private final boolean originalFileNameWithSuffixRB;
        private final boolean useBaseNameWithSuffixRB;
        private final boolean neglectDependentTiersRB;
        private final boolean dontExportFilesWithoutTiersCB;
        private final boolean exportTiersRB;
        private final boolean exportLingTypesRB;
        private final String baseNameTextField;
        private final String suffixNameTextField;
        private final String localDirectoryTextField;
        private final String sameDirectoryTextField;

        public SaveFileThread(List<String> tiersToSave) {
            this.tiersToSave = (ArrayList)tiersToSave;
            this.originalDirRB = ExportTiersDialog.this.originalDirRB.isSelected();
            this.newDirectoryRB = ExportTiersDialog.this.newDirectoryRB.isSelected();
            this.togetherInSameDirRB = ExportTiersDialog.this.togetherInSameDirRB.isSelected();
            this.originalFileNameRB = ExportTiersDialog.this.originalFileNameRB.isSelected();
            this.originalFileNameWithSuffixRB = ExportTiersDialog.this.originalFileNameWithSuffixRB.isSelected();
            this.useBaseNameWithSuffixRB = ExportTiersDialog.this.useBaseNameWithSuffixRB.isSelected();
            this.neglectDependentTiersRB = ExportTiersDialog.this.neglectDependentTiersRB.isSelected();
            this.dontExportFilesWithoutTiersCB = ExportTiersDialog.this.dontExportFilesWithoutTiersCB.isSelected();
            this.exportTiersRB = ExportTiersDialog.this.exportTiersRB.isSelected();
            this.exportLingTypesRB = ExportTiersDialog.this.exportLingTypesRB.isSelected();
            this.localDirectoryTextField = ExportTiersDialog.this.localDirectoryTextField.getText();
            this.sameDirectoryTextField = ExportTiersDialog.this.sameDirectoryTextField.getText();
            this.baseNameTextField = ExportTiersDialog.this.baseNameTextField.getText();
            this.suffixNameTextField = ExportTiersDialog.this.suffixNameTextField.getText();
        }

        private String getDirectoryToSave(File file) {
            String originalDirectory = file.getPath().substring(0, file.getPath().length() - file.getName().length());
            if (this.originalDirRB) {
                return originalDirectory;
            }
            if (this.newDirectoryRB) {
                return originalDirectory + this.localDirectoryTextField;
            }
            if (this.togetherInSameDirRB) {
                return this.sameDirectoryTextField;
            }
            return null;
        }

        private String getFileName(TranscriptionImpl transImpl, int nr) {
            if (this.originalFileNameRB) {
                return transImpl.getName();
            }
            if (this.originalFileNameWithSuffixRB) {
                String fileName = transImpl.getName();
                int index = fileName.lastIndexOf(46);
                return fileName.substring(0, index) + this.suffixNameTextField + fileName.substring(index);
            }
            if (this.useBaseNameWithSuffixRB) {
                String fileName = transImpl.getName();
                int index = fileName.lastIndexOf(46);
                return this.baseNameTextField + (nr + 1) + fileName.substring(index);
            }
            return null;
        }

        private boolean createDirectory(String directoryPath) {
            boolean directoryExists = true;
            File directory = new File(directoryPath);
            if (!directory.exists()) {
                directoryExists = new File(directoryPath).mkdir();
            }
            return directoryExists;
        }

        private void setRelativePaths(String pathName, TranscriptionImpl tr) {
            String relUrl;
            Vector linkedFiles = tr.getLinkedFileDescriptors();
            String fullEAFURL = FileUtility.pathToURLString(pathName);
            Vector mediaDescriptors = tr.getMediaDescriptors();
            for (int i = 0; i < mediaDescriptors.size(); ++i) {
                MediaDescriptor md = (MediaDescriptor)mediaDescriptors.elementAt(i);
                relUrl = FileUtility.getRelativePath(fullEAFURL, md.mediaURL);
                md.relativeMediaURL = "file:/" + relUrl;
            }
            if (linkedFiles.size() > 0) {
                for (int i = 0; i < linkedFiles.size(); ++i) {
                    LinkedFileDescriptor lfd = (LinkedFileDescriptor)linkedFiles.get(i);
                    relUrl = FileUtility.getRelativePath(fullEAFURL, lfd.linkURL);
                    lfd.relativeLinkURL = "file:/" + relUrl;
                }
            }
        }

        private void removeTiersFromTranscription(TranscriptionImpl transImpl) {
            Vector tiers = new Vector(transImpl.getTiers());
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = (TierImpl)tiers.get(i);
                if (ExportTiersDialog.this.exists(tier.getName(), this.tiersToSave)) continue;
                Vector dependentTiers = tier.getDependentTiers();
                if (this.neglectDependentTiersRB) {
                    for (int n = 0; n < dependentTiers.size(); ++n) {
                        transImpl.removeTier((TierImpl)dependentTiers.get(n));
                    }
                    transImpl.removeTier(tier);
                    continue;
                }
                boolean removeParentTier = true;
                for (int n = 0; n < dependentTiers.size(); ++n) {
                    if (!ExportTiersDialog.this.exists(((TierImpl)dependentTiers.get(n)).getName(), this.tiersToSave)) continue;
                    removeParentTier = false;
                    break;
                }
                if (!removeParentTier) continue;
                transImpl.removeTier(tier);
            }
        }

        private void removeTiersBasedOnLinguisticTypes(TranscriptionImpl transImpl) {
            Vector tiers = new Vector(transImpl.getTiers());
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl tier = (TierImpl)tiers.get(i);
                if (ExportTiersDialog.this.exists(tier.getLinguisticType().getLinguisticTypeName(), this.tiersToSave)) continue;
                Vector dependentTiers = tier.getDependentTiers();
                if (this.neglectDependentTiersRB) {
                    for (int n = 0; n < dependentTiers.size(); ++n) {
                        transImpl.removeTier((TierImpl)dependentTiers.get(n));
                    }
                    transImpl.removeTier(tier);
                    continue;
                }
                boolean removeParentTier = true;
                for (int n = 0; n < dependentTiers.size(); ++n) {
                    if (!ExportTiersDialog.this.exists(((TierImpl)dependentTiers.get(n)).getLinguisticType().getLinguisticTypeName(), this.tiersToSave)) continue;
                    removeParentTier = false;
                    break;
                }
                if (!removeParentTier) continue;
                transImpl.removeTier(tier);
            }
        }

        @Override
        public void run() {
            int failedExports = 0;
            int refusedExports = 0;
            int emptyFiles = 0;
            boolean saveForever = false;
            boolean skipForever = false;
            for (int f = 0; f < ExportTiersDialog.this.transImplList.size(); ++f) {
                TranscriptionImpl transImpl = (TranscriptionImpl)ExportTiersDialog.this.transImplList.get(f);
                if (this.exportTiersRB) {
                    this.removeTiersFromTranscription(transImpl);
                } else if (this.exportLingTypesRB) {
                    this.removeTiersBasedOnLinguisticTypes(transImpl);
                } else {
                    ClientLogger.LOG.warning("Warning: No export option chosen. Export won't have any effect");
                    return;
                }
                String path = this.getDirectoryToSave(ExportTiersDialog.this.eafFiles[f]);
                String fileName = this.getFileName(transImpl, f);
                if (path.charAt(path.length() - 1) != File.separatorChar) {
                    path = path + File.separatorChar;
                }
                String directoryToSave = path + fileName;
                try {
                    boolean directoryExists = this.createDirectory(path);
                    boolean saveThisFile = true;
                    boolean fileExists = new File(directoryToSave).exists();
                    if (fileExists && skipForever) {
                        saveThisFile = false;
                    }
                    if (!skipForever && !saveForever && fileExists) {
                        Object[] possibleValues = new Object[]{"Yes To All", "Yes", "No", "No To All"};
                        int choice = JOptionPane.showOptionDialog(null, ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description1") + " " + ExportTiersDialog.this.eafFiles[f].getName() + " " + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description2") + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description3") + "\t " + ExportTiersDialog.this.eafFiles[f].getAbsolutePath() + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description4") + "\n", ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Title"), -1, 2, null, possibleValues, possibleValues[2]);
                        switch (choice) {
                            case 1: {
                                saveThisFile = true;
                                break;
                            }
                            case 0: {
                                saveForever = true;
                                break;
                            }
                            case 3: {
                                skipForever = true;
                                saveThisFile = false;
                                break;
                            }
                            default: {
                                saveThisFile = false;
                            }
                        }
                    }
                    this.setRelativePaths(directoryToSave, transImpl);
                    if (directoryExists) {
                        if (saveForever || saveThisFile) {
                            if (!this.dontExportFilesWithoutTiersCB) {
                                ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(transImpl, null, new Vector(), directoryToSave, 0);
                            } else if (transImpl.getTiers().size() > 0) {
                                ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(transImpl, null, new Vector(), directoryToSave, 0);
                            } else {
                                ++emptyFiles;
                            }
                        } else {
                            ++refusedExports;
                        }
                    } else {
                        ++failedExports;
                    }
                }
                catch (IOException e) {
                    ClientLogger.LOG.warning("Can not write transcription to file with directory/filename: " + ExportTiersDialog.this.eafFiles[f].getAbsolutePath() + "/" + ExportTiersDialog.this.eafFiles[f].getName());
                    ++failedExports;
                }
                ExportTiersDialog.this.progressValue++;
                ExportTiersDialog.this.progressBar.setValue(ExportTiersDialog.this.progressValue);
                ExportTiersDialog.this.progressBar.setString(Math.round((float)(100 * (f + 1)) / (float)ExportTiersDialog.this.eafFiles.length) + "%");
            }
            ExportTiersDialog.this.progressBar.setString(ElanLocale.getString("ExportTiersDialog.ProgressBar.ExportingDone"));
            String msg = ExportTiersDialog.this.eafFiles.length - failedExports - refusedExports - emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.OutOf") + " " + ExportTiersDialog.this.eafFiles.length + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg1");
            if (emptyFiles + refusedExports + failedExports > 0) {
                msg = emptyFiles == 1 ? msg + "\n\n" + emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg2single") : msg + "\n\n" + emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg2");
                msg = refusedExports == 1 ? msg + "\n" + refusedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg3single") : msg + "\n" + refusedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg3");
                msg = failedExports == 1 ? msg + "\n" + failedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg4single") : msg + "\n" + failedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg4");
            }
            if (failedExports > 0) {
                JOptionPane.showMessageDialog(ExportTiersDialog.this, msg, ElanLocale.getString("ExportTiersDialog.Message.ExportingDoneTitle"), 2);
            } else {
                JOptionPane.showMessageDialog(ExportTiersDialog.this, msg, ElanLocale.getString("ExportTiersDialog.Message.ExportingDoneTitle"), 1);
            }
            ExportTiersDialog.this.setVisible(false);
            ExportTiersDialog.this.dispose();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton sender = (JButton)e.getSource();
            if (sender == ExportTiersDialog.this.cancelButton) {
                ExportTiersDialog.this.setVisible(false);
                ExportTiersDialog.this.dispose();
                return;
            }
            if (sender == ExportTiersDialog.this.browseBtn) {
                String directoryStr = ExportTiersDialog.this.showDirectoryChooser();
                if (directoryStr != null) {
                    ExportTiersDialog.this.sameDirectoryTextField.setText(directoryStr);
                    ExportTiersDialog.this.updateExportButtonEnabled();
                }
                return;
            }
            if (sender == ExportTiersDialog.this.exportButton) {
                ExportTiersDialog.this.progressValue = 0;
                ExportTiersDialog.this.progressBar.setValue(ExportTiersDialog.this.progressValue);
                if (ExportTiersDialog.this.exportTiersRB.isSelected()) {
                    ExportTiersDialog.this.saveFiles(((TierTableModel)ExportTiersDialog.this.tierTable.getModel()).getSelectedTiers());
                } else if (ExportTiersDialog.this.exportLingTypesRB.isSelected()) {
                    ExportTiersDialog.this.saveFiles(((TierTableModel)ExportTiersDialog.this.linguisticTypeTable.getModel()).getSelectedTiers());
                }
                ExportTiersDialog.this.exportingStarted = true;
                ExportTiersDialog.this.updateExportButtonEnabled();
                return;
            }
            if (sender == ExportTiersDialog.this.selectAllButton || sender == ExportTiersDialog.this.selectNoneButton) {
                Boolean newValue = sender == ExportTiersDialog.this.selectAllButton;
                JTable activeTable = ExportTiersDialog.this.getActiveTable();
                if (activeTable.getColumnCount() > 0 && activeTable.getColumnClass(0) == newValue.getClass()) {
                    for (int row = 0; row < activeTable.getRowCount(); ++row) {
                        activeTable.setValueAt(newValue, row, 0);
                    }
                }
                activeTable.repaint();
                return;
            }
        }
    }

    private class TextFieldHandler
    implements KeyListener {
        private TextFieldHandler() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            ExportTiersDialog.this.updateExportButtonEnabled();
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            ExportTiersDialog.this.sameDirectoryTextField.setEnabled(ExportTiersDialog.this.togetherInSameDirRB.isSelected());
            ExportTiersDialog.this.browseBtn.setEnabled(ExportTiersDialog.this.togetherInSameDirRB.isSelected());
            ExportTiersDialog.this.localDirectoryTextField.setEnabled(ExportTiersDialog.this.newDirectoryRB.isSelected());
            ExportTiersDialog.this.baseNameTextField.setEnabled(ExportTiersDialog.this.addSuffixRB.isSelected() && ExportTiersDialog.this.useBaseNameWithSuffixRB.isSelected());
            ExportTiersDialog.this.suffixNameTextField.setEnabled(ExportTiersDialog.this.addSuffixRB.isSelected() && ExportTiersDialog.this.originalFileNameWithSuffixRB.isSelected());
            ExportTiersDialog.this.useBaseNameWithSuffixRB.setEnabled(ExportTiersDialog.this.addSuffixRB.isSelected());
            ExportTiersDialog.this.originalFileNameWithSuffixRB.setEnabled(ExportTiersDialog.this.addSuffixRB.isSelected());
            ExportTiersDialog.this.updateExportButtonEnabled();
        }
    }
}

