/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.ElanFileFilter;

public class GetExternalCVURLDialog
extends JDialog
implements ActionListener {
    private String externalCVURLString;
    private JButton okButton;
    private JButton cancelButton;
    private JButton browseButton;
    private JTextField urlTextField;

    public GetExternalCVURLDialog(Dialog owner) {
        super(owner, ElanLocale.getString("ConnectExternalCVDialog.title.value"), true);
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JPanel linkPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setText(ElanLocale.getString("ConnectExternalCVDialog.label.value"));
        titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)titleLabel, gbc);
        linkPanel.setLayout(new GridBagLayout());
        JLabel urlLabel = new JLabel(ElanLocale.getString("ConnectExternalCVDialog.entry.label.value"));
        this.browseButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.browseButton.addActionListener(this);
        this.urlTextField = new JTextField(30);
        this.urlTextField.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        linkPanel.add((Component)urlLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        linkPanel.add((Component)this.urlTextField, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        linkPanel.add((Component)this.browseButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)linkPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton();
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                GetExternalCVURLDialog.this.doClose();
            }
        });
    }

    private void postInit() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        Object source = actionEvent.getSource();
        if (source == this.okButton) {
            this.externalCVURLString = this.urlTextField.getText();
            this.doClose();
        } else if (source == this.cancelButton) {
            this.externalCVURLString = null;
            this.doClose();
        } else if (source == this.browseButton && (file = this.getExternalCVFile()) != null) {
            this.urlTextField.setText(file.toURI().toString());
        }
    }

    public String getExternalCVURLString() {
        return this.externalCVURLString;
    }

    private File getExternalCVFile() {
        String dir = (String)Preferences.get("LastUsedEAFDir", null);
        if (dir == null) {
            dir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle(ElanLocale.getString("Button.Import"));
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ElanFileFilter.createFileFilter(25));
        int option = chooser.showOpenDialog(this);
        if (option == 1) {
            return null;
        }
        if (option == 0) {
            File extCVFile = chooser.getSelectedFile();
            String filePath = extCVFile.getAbsolutePath();
            if (!extCVFile.exists() || extCVFile.isDirectory()) {
                StringBuffer strMessage = new StringBuffer(ElanLocale.getString("Menu.Dialog.Message1"));
                strMessage.append(extCVFile.getName());
                strMessage.append(ElanLocale.getString("Menu.Dialog.Message2"));
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this, strMessage, strError, 0);
                return null;
            }
            if (!filePath.toLowerCase().endsWith(".ecv")) {
                StringBuffer strMessage = new StringBuffer(ElanLocale.getString("Menu.Dialog.Message1"));
                strMessage.append(extCVFile.getName());
                strMessage.append(ElanLocale.getString("Menu.Dialog.Message3"));
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this, strMessage, strError, 0);
                return null;
            }
            Preferences.set("LastUsedEAFDir", extCVFile.getParent(), null);
            return extCVFile;
        }
        return null;
    }
}

