/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import mpi.eudico.client.annotator.commands.global.WebMA;

public class HTMLViewer
implements HyperlinkListener {
    private final String urlString;
    private URL url;
    private String title;
    private boolean modal;
    private final JEditorPane htmlPane;

    public HTMLViewer(String urlString, boolean modal, String title) throws IOException {
        this.urlString = urlString;
        this.url = HTMLViewer.class.getResource(urlString);
        if (this.url == null) {
            try {
                this.url = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                throw new IOException("Cannot load file: " + mue.getMessage());
            }
        }
        this.title = title;
        this.modal = modal;
        this.htmlPane = new JEditorPane(this.url);
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
    }

    public JDialog createHTMLDialog(Frame parent) {
        JDialog dialog = new JDialog(parent, this.title, this.modal);
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        dialog.getContentPane().add(scrollPane);
        return dialog;
    }

    public JDialog createHTMLDialog(Dialog parent) {
        JDialog dialog = new JDialog(parent, this.title, this.modal);
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        dialog.getContentPane().add(scrollPane);
        return dialog;
    }

    public JFrame createHTMLFrame() {
        JFrame frame = new JFrame(this.title);
        JScrollPane scrollPane = new JScrollPane(this.htmlPane);
        frame.setAlwaysOnTop(this.modal);
        frame.getContentPane().add(scrollPane);
        return frame;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e.getURL().sameFile(this.url)) {
                try {
                    this.htmlPane.scrollToReference(e.getURL().getRef());
                }
                catch (Throwable t) {}
            } else {
                WebMA webma = new WebMA("", null, e.getURL().toExternalForm());
                webma.actionPerformed(null);
            }
        }
    }
}

