/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.ComboBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;

public class ImportCSVDialog
extends ClosableDialog
implements ClientLogger,
ActionListener,
ChangeListener {
    private File csvFile;
    private Object value;
    private String[] colTypes;
    private DefaultTableModel selectModel;
    private String detectedDel;
    private int detectedNumCols;
    private JPanel examplePanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox delimiterCB;
    private JCheckBox firstRowCB;
    private JCheckBox defaultDurCB;
    private JComboBox delimiterCombo;
    private JSpinner firstRowSpinner;
    private JLabel selectionLabel;
    private JTable sampleTable;
    private SelectionTable selectionTable;
    private JTextField durationTF;
    private final String INTERVAL_PREF = "ShoeboxChatBlockDuration";

    public ImportCSVDialog(Frame owner, File csvFile) throws HeadlessException {
        super(owner, true);
        this.csvFile = csvFile;
        this.initComponents();
        this.initTables();
    }

    private void initTables() {
        try {
            int i;
            DelimitedTextReader reader = new DelimitedTextReader(this.csvFile);
            this.detectedDel = reader.detectDelimiter();
            this.detectedNumCols = reader.detectNumColumns();
            List<String[]> rows = reader.getSamples(6);
            DefaultTableModel csvModel = new DefaultTableModel(rows.size(), this.detectedNumCols + 1);
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                int j;
                String[] row = rows.get(i2);
                csvModel.setValueAt(new Integer(i2 + 1), i2, 0);
                for (j = 0; j < row.length && j < this.detectedNumCols; ++j) {
                    csvModel.setValueAt(row[j], i2, j + 1);
                }
                if (row.length >= this.detectedNumCols) continue;
                for (j = 0; j < this.detectedNumCols - row.length; ++j) {
                    csvModel.setValueAt("", i2, row.length + j + 1);
                }
            }
            Object[] headers = new String[this.detectedNumCols + 1];
            headers[0] = ElanLocale.getString("Frame.GridFrame.ColumnCount");
            for (i = 0; i < this.detectedNumCols; ++i) {
                headers[i + 1] = String.valueOf(i + 1);
            }
            csvModel.setColumnIdentifiers(headers);
            this.sampleTable.setModel(csvModel);
            this.sampleTable.getTableHeader().setReorderingAllowed(false);
            this.sampleTable.getColumnModel().getColumn(0).sizeWidthToFit();
            this.selectModel = new DefaultTableModel(2, this.detectedNumCols);
            headers = new String[this.detectedNumCols];
            for (i = 0; i < this.detectedNumCols; ++i) {
                headers[i] = String.valueOf(i + 1);
            }
            this.selectModel.setColumnIdentifiers(headers);
            for (i = 0; i < this.detectedNumCols; ++i) {
                this.selectModel.setValueAt(Boolean.TRUE, 0, i);
                this.selectModel.setValueAt(this.colTypes[0], 1, i);
            }
            this.selectionTable.setModel(this.selectModel);
            this.selectionTable.getTableHeader().setReorderingAllowed(false);
            this.selectionTable.setRowSelectionAllowed(false);
            this.delimiterCombo.setSelectedItem(this.detectedDel);
        }
        catch (FileNotFoundException fnfe) {
            LOG.warning("File not found: " + this.csvFile.getName());
        }
        catch (IOException ioe) {
            LOG.warning("Read error: " + ioe.getMessage());
        }
    }

    private void initComponents() {
        this.colTypes = new String[6];
        this.colTypes[0] = ElanLocale.getString("Button.Select");
        this.colTypes[1] = ElanLocale.getString("Frame.GridFrame.ColumnAnnotation");
        this.colTypes[2] = ElanLocale.getString("Frame.GridFrame.ColumnTierName");
        this.colTypes[3] = ElanLocale.getString("Frame.GridFrame.ColumnBeginTime");
        this.colTypes[4] = ElanLocale.getString("Frame.GridFrame.ColumnEndTime");
        this.colTypes[5] = ElanLocale.getString("Frame.GridFrame.ColumnDuration");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ImportCSVDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.examplePanel = new JPanel(new GridBagLayout());
        this.sampleTable = new JTable();
        JScrollPane tableScrollPane = new JScrollPane(this.sampleTable);
        Dimension size = new Dimension(500, 120);
        tableScrollPane.setMinimumSize(size);
        tableScrollPane.setPreferredSize(size);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.examplePanel.add((Component)tableScrollPane, gbc);
        this.getContentPane().add((Component)this.examplePanel, gbc);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.selectionLabel = new JLabel();
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.selectionLabel, gbc);
        this.selectionTable = new SelectionTable();
        JScrollPane tableScrollPane2 = new JScrollPane(this.selectionTable);
        size = new Dimension(500, 80);
        tableScrollPane2.setMinimumSize(size);
        tableScrollPane2.setPreferredSize(size);
        gbc.fill = 1;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        this.optionsPanel.add((Component)tableScrollPane2, gbc);
        this.firstRowCB = new JCheckBox();
        this.firstRowCB.addChangeListener(this);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)this.firstRowCB, gbc);
        this.firstRowSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.firstRowSpinner.setEnabled(false);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.firstRowSpinner, gbc);
        this.delimiterCB = new JCheckBox();
        this.delimiterCB.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.optionsPanel.add((Component)this.delimiterCB, gbc);
        this.delimiterCombo = new JComboBox<String>(new String[]{ElanLocale.getString("ImportDialog.CSV.Label.Delimiter.Tab"), ";", ":", ","});
        this.delimiterCombo.setEnabled(false);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.delimiterCombo, gbc);
        this.defaultDurCB = new JCheckBox();
        this.defaultDurCB.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.optionsPanel.add((Component)this.defaultDurCB, gbc);
        this.durationTF = new JTextField(6);
        if (Preferences.get("ShoeboxChatBlockDuration", null) != null) {
            Integer val = (Integer)Preferences.get("ShoeboxChatBlockDuration", null);
            this.durationTF.setText("" + val);
        } else {
            this.durationTF.setText("1000");
        }
        this.durationTF.setEnabled(false);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.durationTF, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("Button.Import") + ": " + this.csvFile.getName());
        this.examplePanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.CSV.Label.Sample")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.Label.Options")));
        this.selectionLabel.setText(ElanLocale.getString("ImportDialog.CSV.Label.Select"));
        this.firstRowCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.FirstRow"));
        this.delimiterCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.Delimiter"));
        this.defaultDurCB.setText(ElanLocale.getString("ImportDialog.CSV.Label.Duration"));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    protected void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public Object showDialog() {
        this.pack();
        int w = 600;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.dispose();
        return this.value;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.createValueAndClose();
        } else if (e.getSource() == this.cancelButton) {
            this.value = null;
            this.setVisible(false);
        }
    }

    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.firstRowCB) {
            this.firstRowSpinner.setEnabled(this.firstRowCB.isSelected());
        } else if (ce.getSource() == this.delimiterCB) {
            this.delimiterCombo.setEnabled(this.delimiterCB.isSelected());
        } else if (ce.getSource() == this.defaultDurCB) {
            this.durationTF.setEnabled(this.defaultDurCB.isSelected());
        }
    }

    private void createValueAndClose() {
        Object val;
        Object val2;
        Object val1;
        for (int i = 0; i < this.selectionTable.getColumnCount(); ++i) {
            val1 = this.selectionTable.getValueAt(0, i);
            val2 = this.selectionTable.getValueAt(1, i);
            if (!(val1 instanceof Boolean) || !((Boolean)val1).booleanValue() || !this.colTypes[0].equals(val2)) continue;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.CSV.Warning.Select") + " " + (i + 1), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        int duration = 1000;
        if (this.defaultDurCB.isSelected()) {
            String durValue = this.durationTF.getText();
            if (durValue != null) {
                try {
                    duration = Integer.parseInt(durValue);
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("RegularAnnotationDialog.Message.InvalidSize"), ElanLocale.getString("Message.Error"), 0);
                    this.durationTF.requestFocus();
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("RegularAnnotationDialog.Message.InvalidSize"), ElanLocale.getString("Message.Error"), 0);
                this.durationTF.requestFocus();
                return;
            }
        }
        HashMap<Integer, Object> colMap = new HashMap<Integer, Object>(this.selectionTable.getColumnCount());
        int numAnnColumns = 0;
        for (int i = 0; i < this.selectionTable.getColumnCount(); ++i) {
            val1 = this.selectionTable.getValueAt(0, i);
            val2 = this.selectionTable.getValueAt(1, i);
            if (!(val1 instanceof Boolean) || !((Boolean)val1).booleanValue()) continue;
            colMap.put(new Integer(i), val2);
            if (!this.colTypes[1].equals(val2)) continue;
            ++numAnnColumns;
        }
        if (numAnnColumns == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.CSV.Warning.NoAnnotation"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        DelimitedTextDecoderInfo decoInfo = new DelimitedTextDecoderInfo(this.csvFile.getAbsolutePath());
        decoInfo.setDefaultDuration(duration);
        Preferences.set("ShoeboxChatBlockDuration", duration, null);
        decoInfo.setSingleAnnotationPerRow(numAnnColumns == 1);
        if (this.detectedDel != null) {
            decoInfo.setDelimiter(this.detectedDel);
        }
        if (this.delimiterCB.isSelected()) {
            Object delVal = this.delimiterCombo.getSelectedItem();
            if (ElanLocale.getString("ImportDialog.CSV.Label.Delimiter.Tab").equals(delVal)) {
                decoInfo.setDelimiter("\t");
            } else if (delVal != null) {
                decoInfo.setDelimiter((String)delVal);
            }
        }
        ArrayList<Integer> tempList = new ArrayList<Integer>();
        for (int i = 0; i < this.selectionTable.getColumnCount(); ++i) {
            val1 = this.selectionTable.getValueAt(0, i);
            if (!(val1 instanceof Boolean) || !((Boolean)val1).booleanValue()) continue;
            tempList.add(new Integer(i));
        }
        int[] inclCols = new int[tempList.size()];
        for (int i = 0; i < tempList.size(); ++i) {
            inclCols[i] = (Integer)tempList.get(i);
        }
        decoInfo.setIncludedColumns(inclCols);
        int firstRow = 0;
        if (this.firstRowCB.isSelected()) {
            firstRow = (Integer)this.firstRowSpinner.getValue() - 1;
        }
        decoInfo.setFirstRowIndex(firstRow);
        String[] inclColumnNames = null;
        if (firstRow > 0) {
            inclColumnNames = new String[tempList.size()];
            for (int i = 0; i < inclCols.length; ++i) {
                Object val3 = this.sampleTable.getValueAt(0, inclCols[i] + 1);
                inclColumnNames[i] = val3 instanceof String ? (String)val3 : "";
            }
            decoInfo.setIncludedColumnsNames(inclColumnNames);
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[3].equals(val)) continue;
            decoInfo.setBeginTimeColumn(keyInt);
            break;
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[4].equals(val)) continue;
            decoInfo.setEndTimeColumn(keyInt);
            break;
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[5].equals(val)) continue;
            decoInfo.setDurationColumn(keyInt);
            break;
        }
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[2].equals(val)) continue;
            decoInfo.setTierColumnIndex(keyInt);
            break;
        }
        ArrayList<Integer> annColumns = new ArrayList<Integer>();
        for (Integer keyInt : colMap.keySet()) {
            val = colMap.get(keyInt);
            if (!this.colTypes[1].equals(val)) continue;
            annColumns.add(keyInt);
        }
        int[] annArray = new int[annColumns.size()];
        for (int j = 0; j < annArray.length; ++j) {
            annArray[j] = (Integer)annColumns.get(j);
        }
        decoInfo.setAnnotationColumns(annArray);
        HashMap<Integer, String> tierColMap = new HashMap<Integer, String>(annArray.length);
        if (inclColumnNames != null) {
            for (int i = 0; i < annArray.length; ++i) {
                for (int j = 0; j < inclCols.length; ++j) {
                    if (annArray[i] != inclCols[j] || j >= inclColumnNames.length) continue;
                    tierColMap.put(new Integer(annArray[i]), inclColumnNames[j]);
                }
            }
        } else {
            for (int i = 0; i < annArray.length; ++i) {
                tierColMap.put(new Integer(annArray[i]), "Tier-" + i);
            }
        }
        decoInfo.setColumnsWithTierNames(tierColMap);
        this.value = decoInfo;
        this.setVisible(false);
    }

    private class SelectionTable
    extends JTable {
        private DefaultCellEditor cbEditor;
        private DefaultCellEditor comboEditor;
        private CheckBoxTableCellRenderer cbRenderer;
        private ComboBoxTableCellRenderer comboRenderer;

        public SelectionTable() {
            JCheckBox cb = new JCheckBox();
            cb.setHorizontalAlignment(0);
            this.cbEditor = new DefaultCellEditor(cb);
            this.comboEditor = new DefaultCellEditor(new JComboBox<String>(ImportCSVDialog.this.colTypes));
            this.cbRenderer = new CheckBoxTableCellRenderer();
            this.cbRenderer.setHorizontalAlignment(0);
            this.comboRenderer = new ComboBoxTableCellRenderer(ImportCSVDialog.this.colTypes);
            this.setRowMargin(3);
            this.setRowHeight(this.getRowHeight() + 10);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (row == 0) {
                return this.cbEditor;
            }
            if (row == 1) {
                return this.comboEditor;
            }
            return super.getCellEditor(row, column);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (row == 0) {
                return this.cbRenderer;
            }
            if (row == 1) {
                return this.comboRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }
}

