/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ElanFileFilter;

public class LogTextFrame
extends ClosableFrame
implements ActionListener {
    private JButton saveButton;
    private JButton closeButton;
    private JTextArea ta;

    public LogTextFrame(String title, String log) throws HeadlessException {
        super(title);
        this.setTitle(title);
        this.initComponents(log);
    }

    private void initComponents(String log) {
        this.ta = new JTextArea(log);
        this.ta.setLineWrap(false);
        JScrollPane pane = new JScrollPane(this.ta);
        pane.setPreferredSize(new Dimension(500, 500));
        Insets insets = new Insets(2, 6, 2, 6);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.fill = 1;
        this.getContentPane().add((Component)pane, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        this.saveButton = new JButton(ElanLocale.getString("Button.Save"));
        this.saveButton.addActionListener(this);
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.closeButton);
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttonPanel, gbc);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.saveButton) {
            File f;
            String exportDir = (String)Preferences.get("LastUsedExportDir", null);
            JFileChooser chooser = new JFileChooser(exportDir);
            FileFilter filter = ElanFileFilter.createFileFilter(11);
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            if (chooser.showSaveDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
                int answer;
                Preferences.set("LastUsedExportDir", chooser.getCurrentDirectory().getAbsolutePath(), null);
                if (f.exists() && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                    return;
                }
                try {
                    FileWriter writer = new FileWriter(f);
                    writer.write(this.ta.getText());
                    writer.flush();
                    writer.close();
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Could not save log file: " + ioe.getMessage());
                }
            }
        }
    }
}

